/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.flightrecorder.ui.common;

import com.oracle.jmc.common.item.IAggregator;
import com.oracle.jmc.common.item.IItemCollection;
import com.oracle.jmc.common.util.Pair;
import com.oracle.jmc.common.util.TypeHandling;
import com.oracle.jmc.flightrecorder.ui.messages.internal.Messages;
import com.oracle.jmc.ui.misc.CompositeToolkit;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class ItemAggregateViewer {
    private static final boolean SCROLL_WORKAROUND = !Boolean.getBoolean("com.oracle.jmc.ui.disablescrollworkaround");
    private final ScrolledComposite scroller;
    private final Composite infoContainer;
    private final FormToolkit toolkit;
    private final List<Pair<IAggregator<?, ?>, Text>> infos = new ArrayList();
    private int lineHeight;

    public ItemAggregateViewer(Composite container, FormToolkit toolkit) {
        this.toolkit = toolkit;
        this.scroller = CompositeToolkit.createVerticalScrollComposite((Composite)container);
        this.infoContainer = ItemAggregateViewer.createInfoContainer((Composite)this.scroller, toolkit);
        this.scroller.setContent((Control)this.infoContainer);
    }

    public Control getControl() {
        return this.scroller;
    }

    public void addCaption(String text) {
        this.addCaption(text, null);
    }

    public void addCaption(String text, String tooltip) {
        Label caption = this.toolkit.createLabel(this.infoContainer, text);
        caption.setFont(JFaceResources.getFontRegistry().getBold("org.eclipse.jface.defaultfont"));
        caption.setLayoutData((Object)new TableWrapData(128, 32, 1, 2));
        caption.setToolTipText(tooltip);
    }

    public void addAggregate(IAggregator<?, ?> aggregator) {
        Text valueText = ItemAggregateViewer.createInfoText(this.infoContainer, this.toolkit, aggregator.getName(), aggregator.getDescription(), 2138);
        this.infos.add(Pair.of(aggregator, (Object)valueText));
        if (SCROLL_WORKAROUND) {
            if (this.lineHeight <= 1) {
                this.lineHeight = valueText.getLineHeight();
            }
            valueText.addListener(37, new Listener(){

                public void handleEvent(Event event) {
                    int deltaPoints;
                    Point pos = ItemAggregateViewer.this.scroller.getOrigin();
                    switch (event.detail) {
                        case 2: {
                            deltaPoints = event.count * ((ItemAggregateViewer)ItemAggregateViewer.this).scroller.getClientArea().height;
                            break;
                        }
                        case 1: {
                            deltaPoints = event.count * ItemAggregateViewer.this.lineHeight;
                            break;
                        }
                        default: {
                            deltaPoints = event.count;
                        }
                    }
                    ItemAggregateViewer.this.scroller.setOrigin(pos.x, pos.y - deltaPoints);
                    event.doit = false;
                }
            });
        }
    }

    public void setValues(IItemCollection items) {
        for (Pair<IAggregator<?, ?>, Text> i : this.infos) {
            Object aggregate = items.getAggregate((IAggregator)i.left);
            ((Text)i.right).setText(aggregate == null ? Messages.INFORMATION_COMPONENT_NOT_AVAILABLE : TypeHandling.getValueString((Object)aggregate));
        }
    }

    public static Composite createInfoContainer(Composite container, FormToolkit toolkit) {
        Composite infoContainer = toolkit.createComposite(container, 0);
        TableWrapLayout layout = new TableWrapLayout();
        layout.numColumns = 2;
        infoContainer.setLayout((Layout)layout);
        return infoContainer;
    }

    public static Text createInfoText(Composite infoContainer, FormToolkit toolkit, String text, String tooltip, int style) {
        Label nameLabel = toolkit.createLabel(infoContainer, text);
        nameLabel.setLayoutData((Object)new TableWrapData(128, 32));
        nameLabel.setToolTipText(tooltip);
        Text valueText = toolkit.createText(infoContainer, "", style);
        valueText.setLayoutData((Object)new TableWrapData(256, 256));
        valueText.setToolTipText(tooltip);
        return valueText;
    }
}

