/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.flightrecorder.ui.common;

import com.oracle.jmc.common.IState;
import com.oracle.jmc.common.IWritableState;
import com.oracle.jmc.common.item.IItem;
import com.oracle.jmc.common.item.IItemCollection;
import com.oracle.jmc.common.item.IItemFilter;
import com.oracle.jmc.common.util.StateToolkit;
import com.oracle.jmc.flightrecorder.ui.FlightRecorderUI;
import com.oracle.jmc.flightrecorder.ui.common.DataPageToolkit;
import com.oracle.jmc.flightrecorder.ui.common.ItemHistogram;
import com.oracle.jmc.flightrecorder.ui.common.ItemList;
import com.oracle.jmc.flightrecorder.ui.messages.internal.Messages;
import com.oracle.jmc.flightrecorder.ui.selection.SelectionStore;
import com.oracle.jmc.ui.CoreImages;
import com.oracle.jmc.ui.column.ColumnManager;
import com.oracle.jmc.ui.column.ColumnsFilter;
import com.oracle.jmc.ui.handlers.ActionToolkit;
import com.oracle.jmc.ui.misc.FilterEditor;
import com.oracle.jmc.ui.misc.PersistableSashForm;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class FilterComponent {
    private static final String SHOW_SEARCH = "showSearch";
    private static final String SHOW_FILTER = "showFilter";
    private SashForm mainSash;
    private boolean isVisible;
    private Consumer<IItemFilter> onChange;
    private IAction showFilterAction;
    private IAction showSearchAction;
    private FilterEditor editor;
    private GridData searchLayoutData;
    private Text searchText;
    private String searchString;

    public static FilterComponent createFilterComponent(ItemList list, IItemFilter filter, IItemCollection items, Supplier<Stream<SelectionStore.SelectionStoreEntry>> selections, Consumer<IItemFilter> onSelect) {
        return FilterComponent.createFilterComponent(list.getManager().getViewer().getControl(), list.getManager(), filter, items, selections, onSelect);
    }

    public static FilterComponent createFilterComponent(ItemHistogram histogram, IItemFilter filter, IItemCollection items, Supplier<Stream<SelectionStore.SelectionStoreEntry>> selections, Consumer<IItemFilter> onSelect) {
        return FilterComponent.createFilterComponent(histogram.getManager().getViewer().getControl(), histogram.getManager(), filter, items, selections, onSelect);
    }

    public static FilterComponent createFilterComponent(Control component, ColumnManager table, IItemFilter filter, IItemCollection items, Supplier<Stream<SelectionStore.SelectionStoreEntry>> selections, Consumer<IItemFilter> onSelect) {
        FormToolkit toolkit = new FormToolkit(Display.getCurrent());
        SashForm mainSash = new SashForm(component.getParent(), 2560);
        mainSash.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        FilterEditor editor = DataPageToolkit.buildFilterSelector((Composite)mainSash, filter, items, selections, onSelect, false);
        Composite body = toolkit.createComposite((Composite)mainSash, 0);
        GridLayout bodyLayout = new GridLayout(1, true);
        bodyLayout.marginWidth = 0;
        bodyLayout.verticalSpacing = 0;
        bodyLayout.marginHeight = 0;
        body.setLayout((Layout)bodyLayout);
        body.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        Composite filterComposite = toolkit.createComposite(body);
        body.setBackground(new Color((Device)Display.getCurrent(), 128, 128, 128));
        GridLayout filterCompositeLayout = new GridLayout(1, false);
        filterCompositeLayout.marginWidth = 0;
        filterCompositeLayout.marginHeight = 0;
        filterComposite.setLayout((Layout)filterCompositeLayout);
        GridData filterCompositeData = new GridData(4, -1, true, false);
        filterCompositeData.heightHint = 0;
        filterComposite.setLayoutData((Object)filterCompositeData);
        Text filterText = ColumnsFilter.addFilterControl((Composite)filterComposite, (FormToolkit)toolkit, (ColumnManager)table);
        table.getViewer().getControl().setParent(body);
        table.getViewer().getControl().setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        toolkit.dispose();
        mainSash.setWeights(new int[]{15, 50});
        return new FilterComponent(mainSash, onSelect, editor, filterCompositeData, filterText);
    }

    private FilterComponent(SashForm mainSash, Consumer<IItemFilter> onChange, FilterEditor editor, GridData filterData, Text filterText) {
        this.mainSash = mainSash;
        this.onChange = onChange;
        this.editor = editor;
        this.searchLayoutData = filterData;
        this.searchText = filterText;
        this.searchString = filterText.getText();
        this.isVisible = false;
        this.showFilterAction = this.createShowFilterAction();
        this.showSearchAction = this.createShowSearchAction();
        this.setColor(1);
    }

    public void loadState(IState state) {
        PersistableSashForm.loadState((SashForm)this.mainSash, (IState)state);
        this.showFilterAction.setChecked(StateToolkit.readBoolean((IState)state, (String)SHOW_FILTER, (Boolean)false).booleanValue());
        this.showSearchAction.setChecked(StateToolkit.readBoolean((IState)state, (String)SHOW_SEARCH, (Boolean)false).booleanValue());
        this.showFilterAction.run();
        this.showSearchAction.run();
    }

    public void saveState(IWritableState state) {
        PersistableSashForm.saveState((SashForm)this.mainSash, (IWritableState)state);
        StateToolkit.writeBoolean((IWritableState)state, (String)SHOW_FILTER, (Boolean)this.showFilterAction.isChecked());
        StateToolkit.writeBoolean((IWritableState)state, (String)SHOW_SEARCH, (Boolean)this.showSearchAction.isChecked());
    }

    public IAction getShowSearchAction() {
        return this.showSearchAction;
    }

    public IAction getShowFilterAction() {
        return this.showFilterAction;
    }

    public SashForm getComponent() {
        return this.mainSash;
    }

    private IAction createShowSearchAction() {
        IAction checkAction = ActionToolkit.checkAction(max -> {
            if (max.booleanValue()) {
                this.searchLayoutData.heightHint = -1;
                this.searchText.setEnabled(true);
                this.searchText.setText(this.searchString);
            } else {
                this.searchLayoutData.heightHint = 0;
                this.searchText.setEnabled(false);
                this.searchString = this.searchText.getText();
                this.searchText.setText("");
            }
            this.searchLayoutData.heightHint = max != false ? -1 : 0;
            this.mainSash.layout(true, true);
        }, (String)Messages.FILTER_SHOW_SEARCH_ACTION, (ImageDescriptor)CoreImages.FIND);
        return checkAction;
    }

    private IAction createShowFilterAction() {
        IAction checkAction = ActionToolkit.checkAction(max -> {
            this.isVisible = max;
            if (!this.isVisible) {
                this.onChange.accept(null);
            } else {
                this.onChange.accept(this.editor.getFilter());
            }
            this.editor.getControl().setVisible(max.booleanValue());
            this.mainSash.layout(false);
        }, (String)Messages.FILTER_SHOW_FILTER_ACTION, (ImageDescriptor)FlightRecorderUI.getDefault().getMCImageDescriptor("filter.gif"));
        return checkAction;
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    public void notifyListener() {
        this.editor.notifyListener();
    }

    public void filterChangeHelper(IItemFilter filter, Consumer<IItemCollection> itemConsumer, Supplier<Integer> countSupplier, IItemCollection items) {
        if (this.isVisible()) {
            itemConsumer.accept(items.apply(filter));
            this.setColor(countSupplier.get());
        } else {
            itemConsumer.accept(items);
        }
    }

    public void filterChangeHelper(IItemFilter filter, ItemHistogram table, IItemCollection items) {
        this.filterChangeHelper(filter, table::show, table.getAllRows()::getRowCount, items);
    }

    public void filterChangeHelper(IItemFilter filter, ItemList table, IItemCollection items) {
        this.filterChangeHelper(filter, table::show, () -> {
            Object input = table.getManager().getViewer().getInput();
            return input instanceof IItem[] ? ((IItem[])input).length : 0;
        }, items);
    }

    public void setColor(int datapoints) {
        if (datapoints == 0) {
            this.mainSash.setBackground(new Color((Device)Display.getCurrent(), new RGB(180, 0, 0)));
        } else {
            this.mainSash.setBackground(new Color((Device)Display.getCurrent(), new RGB(0, 180, 0)));
        }
    }
}

