/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.flightrecorder.ui.common;

import com.oracle.jmc.common.IMemberAccessor;
import com.oracle.jmc.common.item.IAggregator;
import com.oracle.jmc.common.item.IAttribute;
import com.oracle.jmc.common.item.IItem;
import com.oracle.jmc.common.item.IItemCollection;
import com.oracle.jmc.common.item.IItemConsumer;
import com.oracle.jmc.common.item.IItemIterable;
import com.oracle.jmc.common.item.IType;
import com.oracle.jmc.common.unit.IQuantity;
import com.oracle.jmc.flightrecorder.ui.ItemCollectionToolkit;
import com.oracle.jmc.flightrecorder.ui.ItemIterableToolkit;
import com.oracle.jmc.ui.charts.IQuantitySeries;
import com.oracle.jmc.ui.charts.SubdividedQuantityRange;
import com.oracle.jmc.ui.charts.XYQuantities;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collector;
import java.util.stream.Collectors;

public class BucketBuilder<C extends IItemConsumer<C>> {
    int bucketCount;
    IAttribute<IQuantity> xAttribute;
    IAggregator<IQuantity, C> aggregator;
    SubdividedQuantityRange xRange;

    BucketBuilder(int bucketCount, IAttribute<IQuantity> xAttribute, IAggregator<IQuantity, C> aggregator, SubdividedQuantityRange xRange) {
        this.bucketCount = bucketCount;
        this.xAttribute = xAttribute;
        this.aggregator = aggregator;
        this.xRange = xRange;
    }

    private List<C> build(IType<IItem> type) {
        ArrayList<IItemConsumer> calculators = new ArrayList<IItemConsumer>(this.bucketCount);
        int i = 0;
        while (i < this.bucketCount) {
            calculators.add(this.aggregator.newItemConsumer(type));
            ++i;
        }
        return calculators;
    }

    private void consume(List<C> list, IItem item, IMemberAccessor<IQuantity, IItem> xAccessor) {
        int xPos = this.xRange.getFloorSubdivider((IQuantity)xAccessor.getMember((Object)item));
        if (xPos >= 0 && xPos < list.size()) {
            ((IItemConsumer)list.get(xPos)).consume(item);
        }
    }

    private List<C> combine(List<C> l1, List<C> l2) {
        int i = 0;
        while (i < this.bucketCount) {
            l1.set(i, (IItemConsumer)((IItemConsumer)l1.get(i)).merge((Object)((IItemConsumer)l2.get(i))));
            ++i;
        }
        return l1;
    }

    private Collector<IItem, List<C>, List<C>> collector(IType<IItem> type) {
        IMemberAccessor xAccessor = this.xAttribute.getAccessor(type);
        return Collector.of(() -> this.build(type), (l, i) -> this.consume((List<C>)l, (IItem)i, (IMemberAccessor<IQuantity, IItem>)xAccessor), this::combine, Collector.Characteristics.UNORDERED);
    }

    private boolean acceptItems(IItemIterable is) {
        return this.aggregator.acceptType(is.getType());
    }

    private List<C> collectItems(IItemIterable is) {
        return ItemIterableToolkit.parallelStream(is).collect(this.collector((IType<IItem>)is.getType()));
    }

    IQuantity[] buildBuckets(IItemCollection items) {
        IQuantity[] q = new IQuantity[this.bucketCount];
        List collect = ItemCollectionToolkit.parallelStream(items).filter(this::acceptItems).map(this::collectItems).collect(Collectors.toList());
        int i = 0;
        while (i < this.bucketCount) {
            int bucketIndex = i;
            Iterator iterator = collect.stream().map(list -> (Object)((IItemConsumer)list.get(bucketIndex))).iterator();
            q[i] = (IQuantity)this.aggregator.getValue(iterator);
            ++i;
        }
        return q;
    }

    public static <C extends IItemConsumer<C>, T> IQuantitySeries<T> aggregatorSeries(final IItemCollection items, final IAggregator<IQuantity, C> a, final IAttribute<IQuantity> xAttribute) {
        return new IQuantitySeries<T>(){

            public XYQuantities<T> getQuantities(SubdividedQuantityRange xBucketRange) {
                int bucketCount = xBucketRange.getNumSubdividers();
                BucketBuilder bb = new BucketBuilder(bucketCount, (IAttribute<IQuantity>)xAttribute, a, xBucketRange);
                IQuantity[] buckets = bb.buildBuckets(items);
                return XYQuantities.create(null, Arrays.asList(buckets), (SubdividedQuantityRange)xBucketRange);
            }
        };
    }
}

