/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.flightrecorder.ui;

import com.oracle.jmc.common.item.IItem;
import com.oracle.jmc.common.item.IType;
import com.oracle.jmc.flightrecorder.ui.EventTypeFolderNode;
import com.oracle.jmc.flightrecorder.ui.common.TypeFilterBuilder;
import com.oracle.jmc.ui.wizards.IPerformFinishable;
import com.oracle.jmc.ui.wizards.OnePageWizardDialog;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Composite;

class TypeSelectorWizardPage
extends WizardPage
implements IPerformFinishable {
    private final EventTypeFolderNode root;
    private final Consumer<Set<IType<IItem>>> onTypesSelected;
    private TypeFilterBuilder typeSelector;

    TypeSelectorWizardPage(EventTypeFolderNode root, Consumer<Set<IType<IItem>>> onTypesSelected, String title, String description) {
        super("TypeSelectorWizardPage");
        this.root = root;
        this.onTypesSelected = onTypesSelected;
        this.setTitle(title);
        this.setDescription(description);
    }

    public void createControl(Composite parent) {
        this.typeSelector = new TypeFilterBuilder(parent, () -> this.setPageComplete(this.typeSelector.getCheckedTypeIds().findAny().isPresent()));
        this.typeSelector.setInput(this.root);
        this.setControl(this.typeSelector.getControl());
    }

    public boolean performFinish() {
        this.onTypesSelected.accept(this.typeSelector.getSelectedTypes().map(EventTypeFolderNode.EventTypeNode::getType).collect(Collectors.toSet()));
        return true;
    }

    static void openDialog(EventTypeFolderNode root, Consumer<Set<IType<IItem>>> onTypesSelected, String title, String description) {
        OnePageWizardDialog.open((IWizardPage)new TypeSelectorWizardPage(root, onTypesSelected, title, description), (int)500, (int)600);
    }
}

