/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.flightrecorder.ui;

import com.oracle.jmc.common.IMemberAccessor;
import com.oracle.jmc.common.IPredicate;
import com.oracle.jmc.common.item.IItem;
import com.oracle.jmc.common.item.IItemCollection;
import com.oracle.jmc.common.item.IItemFilter;
import com.oracle.jmc.common.item.IItemIterable;
import com.oracle.jmc.common.item.IType;
import com.oracle.jmc.common.unit.IQuantity;
import com.oracle.jmc.common.unit.IRange;
import com.oracle.jmc.common.util.PredicateToolkit;
import com.oracle.jmc.flightrecorder.JfrAttributes;
import com.oracle.jmc.flightrecorder.internal.EventArray;
import com.oracle.jmc.flightrecorder.ui.EventTypeFolderNode;
import com.oracle.jmc.flightrecorder.ui.ItemCollectionToolkit;
import com.oracle.jmc.flightrecorder.ui.ItemIterableToolkit;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class StreamModel {
    private final EventArray[] eventsByType;

    StreamModel(EventArray[] eventsByType) {
        this.eventsByType = eventsByType;
    }

    public IItemCollection getItems(IRange<IQuantity> range, IItemFilter filter) {
        IItemIterable[] rangedStreams = (IItemIterable[])Stream.of(this.eventsByType).map(ea -> {
            IType eventType = ea.getType();
            IPredicate predicate = filter.getPredicate(eventType);
            if (PredicateToolkit.isTrueGuaranteed((IPredicate)predicate)) {
                return ItemIterableToolkit.build(StreamModel.itemSupplier(ea.getEvents(), (IType<IItem>)eventType, range), (IType<IItem>)eventType);
            }
            if (PredicateToolkit.isFalseGuaranteed((IPredicate)predicate)) {
                return null;
            }
            return ItemIterableToolkit.build(StreamModel.itemSupplier(ea.getEvents(), (IType<IItem>)eventType, range, arg_0 -> ((IPredicate)predicate).evaluate(arg_0)), (IType<IItem>)eventType);
        }).filter(Objects::nonNull).toArray(IItemIterable[]::new);
        return ItemCollectionToolkit.build(() -> Arrays.stream(rangedStreams));
    }

    public IItemCollection getItems(IRange<IQuantity> range) {
        return ItemCollectionToolkit.build(() -> Arrays.stream(this.eventsByType).map(ea -> ItemIterableToolkit.build(() -> StreamModel.itemSupplier(ea.getEvents(), (IType<IItem>)ea.getType(), range).get(), (IType<IItem>)ea.getType())));
    }

    public IItemCollection getItems() {
        return ItemCollectionToolkit.build(() -> Arrays.stream(this.eventsByType).map(ea -> ItemIterableToolkit.build(() -> Arrays.stream(ea.getEvents()), (IType<IItem>)ea.getType())));
    }

    private static Supplier<Stream<IItem>> itemSupplier(IItem[] events, IType<IItem> ofType, IRange<IQuantity> range) {
        int start = StreamModel.findStart(events, ofType, (IQuantity)range.getStart());
        int end = StreamModel.findEnd(events, ofType, (IQuantity)range.getEnd());
        return () -> Arrays.stream(events, start, end);
    }

    private static Supplier<Stream<IItem>> itemSupplier(IItem[] events, IType<IItem> ofType, IRange<IQuantity> range, Predicate<? super IItem> predicate) {
        int start = StreamModel.findStart(events, ofType, (IQuantity)range.getStart());
        int end = StreamModel.findEnd(events, ofType, (IQuantity)range.getEnd());
        return () -> Arrays.stream(events, start, end).filter(predicate);
    }

    private static int findStart(IItem[] events, IType<IItem> ofType, IQuantity boundary) {
        IMemberAccessor accessor = JfrAttributes.END_TIME.getAccessor(ofType);
        int index = StreamModel.binarySearch(events, (IMemberAccessor<IQuantity, IItem>)accessor, boundary);
        while (index > 0 && ((IQuantity)accessor.getMember((Object)events[index - 1])).compareTo((Object)boundary) == 0) {
            --index;
        }
        return index;
    }

    private static int findEnd(IItem[] events, IType<IItem> ofType, IQuantity boundary) {
        IMemberAccessor accessor = JfrAttributes.START_TIME.getAccessor(ofType);
        int index = StreamModel.binarySearch(events, (IMemberAccessor<IQuantity, IItem>)accessor, boundary);
        while (index < events.length && ((IQuantity)accessor.getMember((Object)events[index])).compareTo((Object)boundary) == 0) {
            ++index;
        }
        return index;
    }

    private static int binarySearch(IItem[] events, IMemberAccessor<IQuantity, IItem> accessor, IQuantity key) {
        int low = 0;
        int high = events.length - 1;
        while (low <= high) {
            int middle = low + high >>> 1;
            int comparison = key.compareTo((Object)((IQuantity)accessor.getMember((Object)events[middle])));
            if (comparison == 0) {
                return middle;
            }
            if (comparison > 0) {
                low = middle + 1;
                continue;
            }
            high = middle - 1;
        }
        return low;
    }

    public EventTypeFolderNode getTypeTree(Stream<IItemIterable> items) {
        Map<IType, Long> itemCountByType = items.collect(Collectors.toMap(IItemIterable::getType, is -> is.getItemCount(), Long::sum));
        Function<EventArray, EventTypeFolderNode.TypeWithCategory> eventArrayToTypeWithCategoryMapper = ea -> {
            Long count = (Long)itemCountByType.remove(ea.getType());
            return count == null ? null : new EventTypeFolderNode.TypeWithCategory((IType<IItem>)ea.getType(), ea.getTypeCategory(), count);
        };
        return EventTypeFolderNode.buildRoot(Stream.of(this.eventsByType).map(eventArrayToTypeWithCategoryMapper).filter(Objects::nonNull));
    }

    public EventTypeFolderNode getTypeTree() {
        return this.getTypeTree(ItemCollectionToolkit.stream(this.getItems()));
    }
}

