/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.flightrecorder.ui;

import com.oracle.jmc.common.unit.IQuantity;
import com.oracle.jmc.common.unit.IRange;
import com.oracle.jmc.flightrecorder.ui.common.JComponentNavigator;
import com.oracle.jmc.flightrecorder.ui.messages.internal.Messages;
import com.oracle.jmc.ui.wizards.IPerformFinishable;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;

class SelectRangeWizardPage
extends WizardPage
implements IPerformFinishable {
    private JComponentNavigator m_slider;
    private final IRange<IQuantity> m_fullRange;
    private final IRange<IQuantity> m_range;
    private Label m_selectedStartLabel;
    private Label m_selectedEndLabel;
    private Label m_warningLabel;
    private FormToolkit m_toolkit;
    private IRange<IQuantity> m_selectedRange;

    public SelectRangeWizardPage(IRange<IQuantity> range, IRange<IQuantity> fullRange) {
        super("SelectRangeWizardPage", Messages.SELECT_RANGE_WIZARD_TITLE, null);
        this.m_fullRange = fullRange;
        this.m_range = range;
    }

    public void createControl(Composite parent) {
        this.m_toolkit = new FormToolkit(parent.getDisplay());
        this.initializeDialogUnits((Control)parent);
        int indent = 0;
        this.setDescription(Messages.SELECT_RANGE_WIZARD_DESCRIPTION);
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        container.setLayout((Layout)layout);
        this.createHeader(container);
        this.createTimeLabels(container);
        this.createSlider(container, indent);
        this.createSelectedTimeLabels(container, indent);
        this.m_warningLabel = new Label(container, 16384);
        this.m_warningLabel.setLayoutData((Object)new GridData(16384, 0x1000000, true, false));
        this.m_warningLabel.setForeground(JFaceResources.getColorRegistry().get("ERROR_COLOR"));
        this.setControl((Control)container);
        this.m_slider.setNavigatorRange(this.m_fullRange);
        this.m_slider.setCurrentRange(this.m_range);
    }

    private void createHeader(Composite parent) {
        Label start = new Label(parent, 0x1000000);
        start.setText(Messages.SELECT_RANGE_WIZARD_TEXT);
        GridData g = new GridData(0x1000000, 0x1000000, true, false);
        g.horizontalSpan = 2;
        start.setLayoutData((Object)g);
    }

    private void createTimeLabels(Composite parent) {
        Label start = new Label(parent, 16384);
        start.setText(((IQuantity)this.m_fullRange.getStart()).displayUsing("auto"));
        start.setLayoutData((Object)new GridData(16384, 0x1000000, true, false));
        Label end = new Label(parent, 131072);
        end.setText(((IQuantity)this.m_fullRange.getEnd()).displayUsing("auto"));
        end.setLayoutData((Object)new GridData(131072, 0x1000000, true, false));
    }

    private void createSelectedTimeLabels(Composite parent, int indent) {
        this.m_selectedStartLabel = new Label(parent, 16384);
        this.m_selectedStartLabel.setLayoutData((Object)new GridData(16384, 0x1000000, true, false));
        this.m_selectedEndLabel = new Label(parent, 131072);
        this.m_selectedEndLabel.setLayoutData((Object)new GridData(131072, 0x1000000, true, false));
    }

    private GridData createGridData(boolean grabExcessHorizontalSpace, int horizontalSpan, int indent) {
        GridData gridData = new GridData(4, 0x1000000, grabExcessHorizontalSpace, false);
        gridData.horizontalSpan = horizontalSpan;
        gridData.horizontalIndent = indent;
        return gridData;
    }

    private void createSlider(Composite parent, int indent) {
        this.m_slider = new JComponentNavigator(parent, this.m_toolkit){
            private final Color RED;
            private final Color ORANGE;
            {
                this.RED = Color.getHSBColor(0.0f, 0.9f, 0.9f);
                this.ORANGE = Color.getHSBColor(0.1f, 0.9f, 0.8f);
            }

            @Override
            protected void renderBackdrop(Graphics2D g2d, int w, int h) {
                g2d.setColor(Color.WHITE);
                g2d.fillRect(0, 0, w, h);
                GradientPaint gradient = new GradientPaint(0.0f, (float)h / 2.0f, this.RED, 0.0f, h, this.ORANGE, false);
                g2d.setPaint(gradient);
                g2d.fillRect(2, h / 3, w - 4, h);
            }

            @Override
            protected void onRangeChange() {
                SelectRangeWizardPage.this.updateLabels((IRange<IQuantity>)this.getCurrentRange());
            }
        };
        this.m_slider.setLayoutData(this.createGridData(true, 2, indent));
    }

    private void updateLabels(IRange<IQuantity> range) {
        this.m_selectedRange = range;
        this.m_selectedStartLabel.setText(((IQuantity)range.getStart()).displayUsing("auto"));
        this.m_selectedEndLabel.setText(((IQuantity)range.getEnd()).displayUsing("auto"));
        IQuantity warnExtent = ((IQuantity)this.m_range.getExtent()).multiply(1.1);
        if (((IQuantity)range.getExtent()).compareTo((Object)warnExtent) > 0) {
            this.m_warningLabel.setText(Messages.SELECT_RANGE_WIZARD_TO_MUCH_SELECTED_WARNING);
        } else {
            this.m_warningLabel.setText("");
        }
        this.m_warningLabel.getParent().layout();
    }

    public IRange<IQuantity> getRange() {
        return this.m_selectedRange;
    }

    public void dispose() {
        super.dispose();
        if (this.m_toolkit != null) {
            this.m_toolkit.dispose();
        }
    }

    public boolean performFinish() {
        return true;
    }
}

