/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.flightrecorder.ui;

import com.oracle.jmc.common.IState;
import com.oracle.jmc.common.IStateful;
import com.oracle.jmc.common.util.StateToolkit;
import com.oracle.jmc.flightrecorder.rules.IRule;
import com.oracle.jmc.flightrecorder.rules.Result;
import com.oracle.jmc.flightrecorder.rules.RuleRegistry;
import com.oracle.jmc.flightrecorder.rules.Severity;
import com.oracle.jmc.flightrecorder.ui.BasicConfig;
import com.oracle.jmc.flightrecorder.ui.FlightRecorderUI;
import com.oracle.jmc.flightrecorder.ui.RulesUiToolkit;
import com.oracle.jmc.flightrecorder.ui.StreamModel;
import com.oracle.jmc.flightrecorder.ui.messages.internal.Messages;
import com.oracle.jmc.flightrecorder.ui.preferences.RulesPage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.RunnableFuture;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.stream.Collectors;
import java.util.stream.DoubleStream;
import java.util.stream.Stream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobGroup;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.osgi.util.NLS;
import org.xml.sax.SAXException;

public class RuleManager {
    public static final String RULE_CONFIGURATION_PREFERENCE_ID = "ruleConfiguration";
    public static final String UNMAPPED_REMAINDER_TOPIC = "";
    private final Object ruleJobFamily = new Object();
    private final ConcurrentMap<String, ConcurrentMap<String, Result>> resultsByTopicByRuleId;
    private final ConcurrentMap<String, Set<Consumer<Result>>> resultListenersByTopic;
    private final List<Consumer<Result>> resultListeners = Collections.synchronizedList(new ArrayList());
    private final List<String> unmappedTopics = Collections.synchronizedList(new ArrayList());
    private Set<String> ignoredRules = Collections.synchronizedSet(new HashSet());
    private BasicConfig config;
    private StreamModel items;
    private Runnable postEvaluationCallback;
    private int threadsPerEngine;

    RuleManager(Runnable postEvaluationCallback) {
        this.postEvaluationCallback = postEvaluationCallback;
        IPreferenceStore preferenceStore = FlightRecorderUI.getDefault().getPreferenceStore();
        this.loadIgnoredSet(preferenceStore);
        this.loadConfig(preferenceStore);
        int threads = preferenceStore.getInt("flightrecorder.rule.evaluation.threads");
        this.threadsPerEngine = Math.max(threads, 1);
        Collection<String> topics = RulesUiToolkit.getTopics();
        int initialCapacity = topics.size() > 0 ? topics.size() : 1;
        this.resultsByTopicByRuleId = new ConcurrentHashMap<String, ConcurrentMap<String, Result>>(initialCapacity, 0.75f, this.threadsPerEngine);
        this.resultListenersByTopic = new ConcurrentHashMap<String, Set<Consumer<Result>>>(initialCapacity, 0.75f, this.threadsPerEngine);
        for (String topic : topics) {
            this.resultsByTopicByRuleId.putIfAbsent(topic, new ConcurrentHashMap());
            for (IRule rule : RulesUiToolkit.getRules(topic)) {
                if (this.ignoredRules.contains(rule.getId())) continue;
                ((ConcurrentMap)this.resultsByTopicByRuleId.get(topic)).put(rule.getId(), new Result(rule, -200.0, Messages.JFR_EDITOR_RULES_WAITING));
            }
        }
    }

    private void updateListeners(Result result) {
        Set listeners = (Set)this.resultListenersByTopic.get(result.getRule().getTopic());
        if (listeners != null) {
            ((Stream)listeners.stream().parallel()).forEach(rl -> rl.accept(result));
        }
        this.resultListeners.forEach(rl -> rl.accept(result));
    }

    void setStreamModel(StreamModel items) {
        this.items = items;
    }

    void saveState() {
        try {
            if (this.config != null) {
                FlightRecorderUI.getDefault().getPreferenceStore().putValue(RULE_CONFIGURATION_PREFERENCE_ID, StateToolkit.toXMLString((IStateful)this.config));
            }
        }
        catch (Exception e) {
            FlightRecorderUI.getDefault().getLogger().log(Level.WARNING, "Could not save configuration!", e);
        }
        Job.getJobManager().cancel(this.ruleJobFamily);
    }

    BasicConfig getConfig() {
        return this.config;
    }

    public Collection<Result> getResults(String ... topics) {
        return this.getResults(Arrays.asList(topics));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Result> getResults(Collection<String> topics) {
        HashSet<Result> results = new HashSet<Result>();
        results.addAll(topics.stream().filter(t -> !UNMAPPED_REMAINDER_TOPIC.equals(t)).map(t -> (ConcurrentMap)this.resultsByTopicByRuleId.get(t)).filter(m -> m != null).flatMap(m -> m.values().stream()).collect(Collectors.toList()));
        if (topics.stream().anyMatch(t -> UNMAPPED_REMAINDER_TOPIC.equals(t))) {
            List<String> list = this.unmappedTopics;
            synchronized (list) {
                this.unmappedTopics.forEach(t -> {
                    boolean bl = results.addAll(((ConcurrentMap)this.resultsByTopicByRuleId.get(t)).values());
                });
            }
        }
        return results;
    }

    public Result getResult(IRule rule) {
        return (Result)((ConcurrentMap)this.resultsByTopicByRuleId.get(rule.getTopic())).get(rule.getId());
    }

    public DoubleStream getScoreStream(String ... topics) {
        return this.getResults(topics).parallelStream().mapToDouble(Result::getScore);
    }

    public Collection<IRule> getRules(String ... topics) {
        return this.getResults(topics).parallelStream().map(Result::getRule).collect(Collectors.toList());
    }

    public Severity getMaxSeverity(String ... topics) {
        return Severity.get((double)this.getResults(topics).parallelStream().mapToDouble(Result::getScore).max().orElse(-1.0));
    }

    public Collection<Result> getUnmappedResults() {
        return this.getResults(this.unmappedTopics);
    }

    public void evaluateRules(Collection<IRule> rules) {
        if (FlightRecorderUI.getDefault().isAnalysisEnabled() && this.items != null) {
            IProgressMonitor evaluationGroup = Job.getJobManager().createProgressGroup();
            evaluationGroup.setTaskName(Messages.JFR_EDITOR_RULES_TASK_NAME);
            JobGroup group = new JobGroup("Rule Evaluation Group", this.threadsPerEngine, rules.size());
            for (IRule rule : rules) {
                String topic;
                String string = topic = rule.getTopic() == null ? UNMAPPED_REMAINDER_TOPIC : rule.getTopic();
                if (!this.ignoredRules.contains(rule.getId())) {
                    EvaluateJob job = new EvaluateJob(rule);
                    job.setJobGroup(group);
                    Result result = new Result(rule, -200.0, Messages.JFR_EDITOR_RULES_SCHEDULED);
                    ((ConcurrentMap)this.resultsByTopicByRuleId.get(topic)).put(rule.getId(), result);
                    this.updateListeners(result);
                    job.setSystem(true);
                    job.setProgressGroup(evaluationGroup, 1);
                    job.setPriority(50);
                    job.schedule();
                    continue;
                }
                Result result = new Result(rule, -3.0, Messages.JFR_EDITOR_RULES_IGNORED);
                ((ConcurrentMap)this.resultsByTopicByRuleId.get(topic)).put(rule.getId(), result);
                this.updateListeners(result);
            }
        }
    }

    public void evaluateAllRules() {
        Collection rules = RuleRegistry.getRules();
        this.evaluateRules(rules);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void refreshTopics() {
        HashSet<String> topics = new HashSet<String>(RulesUiToolkit.getTopics());
        FlightRecorderUI.getDefault().getPageManager().getAllPages().forEach(dpd -> {
            boolean bl = topics.removeAll(Arrays.asList(dpd.getTopics()));
        });
        List<String> list = this.unmappedTopics;
        synchronized (list) {
            this.unmappedTopics.clear();
            this.unmappedTopics.addAll(topics);
        }
    }

    public void addResultListener(String topic, Consumer<Result> listener) {
        this.resultListenersByTopic.computeIfAbsent(topic, k -> Collections.synchronizedSet(new HashSet())).add(listener);
    }

    public void addResultListener(Consumer<Result> listener) {
        this.resultListeners.add(listener);
    }

    public void removeResultListener(Consumer<Result> listener) {
        this.resultListeners.remove(listener);
        this.resultListenersByTopic.values().forEach(r -> {
            boolean bl = r.remove(listener);
        });
    }

    private void loadIgnoredSet(IPreferenceStore preferenceStore) {
        preferenceStore.addPropertyChangeListener(e -> {
            if (e.getProperty().equals("ignoredRules")) {
                try {
                    Set<String> newIgnoredRules = RulesPage.loadIgnoredRules(preferenceStore);
                    HashSet<String> tempSet = new HashSet<String>();
                    tempSet.addAll(this.ignoredRules);
                    tempSet.addAll(newIgnoredRules);
                    this.ignoredRules = newIgnoredRules;
                    this.evaluateRules(RuleRegistry.getRules().stream().filter(r -> tempSet.contains(r.getId())).collect(Collectors.toList()));
                }
                catch (Exception e1) {
                    FlightRecorderUI.getDefault().getLogger().log(Level.WARNING, "Could not read ignored rules from preferences.", e1);
                }
            }
        });
        this.ignoredRules = RulesPage.loadIgnoredRules(preferenceStore);
    }

    private void loadConfig(IPreferenceStore preferenceStore) {
        String configStateString = preferenceStore.getString(RULE_CONFIGURATION_PREFERENCE_ID);
        preferenceStore.addPropertyChangeListener(e -> {
            if (e.getProperty().equals(RULE_CONFIGURATION_PREFERENCE_ID)) {
                String newConfig = e.getNewValue().toString();
                try {
                    IState newState = StateToolkit.fromXMLString((String)newConfig);
                    this.evaluateRules(this.config.update(newState));
                }
                catch (SAXException saxe) {
                    FlightRecorderUI.getDefault().getLogger().log(Level.WARNING, "Error reading configuration XML", saxe);
                }
            }
        });
        IState fromXMLString = null;
        try {
            fromXMLString = configStateString.length() != 0 ? StateToolkit.fromXMLString((String)configStateString) : null;
        }
        catch (SAXException saxe) {
            FlightRecorderUI.getDefault().getLogger().log(Level.WARNING, "Error reading configuration XML", saxe);
        }
        this.config = new BasicConfig(fromXMLString);
    }

    private class EvaluateJob
    extends Job {
        private final IRule rule;

        EvaluateJob(IRule rule) {
            super(rule.getId());
            this.rule = rule;
        }

        public boolean belongsTo(Object family) {
            return family == RuleManager.this.ruleJobFamily;
        }

        protected IStatus run(IProgressMonitor monitor) {
            monitor.beginTask(this.rule.getName(), -1);
            String topic = this.rule.getTopic() == null ? RuleManager.UNMAPPED_REMAINDER_TOPIC : this.rule.getTopic();
            Result result = new Result(this.rule, -200.0, Messages.JFR_EDITOR_RULES_EVALUATING);
            ((ConcurrentMap)RuleManager.this.resultsByTopicByRuleId.get(topic)).put(this.rule.getId(), result);
            RuleManager.this.updateListeners(result);
            try {
                RunnableFuture future = this.rule.evaluate(RuleManager.this.items.getItems(), RuleManager.this.config::getValue);
                Thread runner = new Thread(future);
                runner.start();
                while (true) {
                    if (monitor.isCanceled()) {
                        future.cancel(true);
                        runner.join();
                        result = new Result(this.rule, -2.0, Messages.JFR_EDITOR_RULES_CANCELLED);
                        break;
                    }
                    if (future.isDone()) {
                        result = (Result)future.get();
                        runner.join();
                        break;
                    }
                    Thread.sleep(100L);
                }
            }
            catch (Exception e) {
                FlightRecorderUI.getDefault().getLogger().log(Level.WARNING, "Could not evaluate " + this.rule.getName(), e);
                result = new Result(this.rule, -2.0, NLS.bind((String)Messages.JFR_EDITOR_RULE_EVALUATION_ERROR_DESCRIPTION, (Object)e));
            }
            if (result == null) {
                result = new Result(this.rule, -2.0, Messages.RuleManager_NULL_RESULT_DESCRIPTION);
            }
            ((ConcurrentMap)RuleManager.this.resultsByTopicByRuleId.get(topic)).put(this.rule.getId(), result);
            RuleManager.this.updateListeners(result);
            RuleManager.this.postEvaluationCallback.run();
            monitor.worked(1);
            monitor.done();
            return new Status(monitor.isCanceled() ? 8 : 0, "com.oracle.jmc.flightrecorder.ui", this.rule.getName());
        }
    }
}

