/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.flightrecorder.ui;

import com.oracle.jmc.flightrecorder.ui.FlightRecorderUI;
import com.oracle.jmc.flightrecorder.ui.JfrEditor;
import com.oracle.jmc.flightrecorder.ui.ResultPage;
import com.oracle.jmc.flightrecorder.ui.messages.internal.Messages;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.part.IPageBookViewPage;
import org.eclipse.ui.part.MessagePage;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.part.PageBookView;

public class ResultPageBookView
extends PageBookView {
    private static final String HELP_CONTEXT_ID = "com.oracle.jmc.flightrecorder.ui.ResultView";
    private IPropertyChangeListener analysisEnabledPropertyListener;

    protected IPage createDefaultPage(PageBook book) {
        MessagePage page = new MessagePage();
        this.initPage((IPageBookViewPage)page);
        page.createControl((Composite)book);
        this.analysisEnabledPropertyListener = e -> {
            if (e.getProperty().equals("flightrecorder.controlpanel.enable.recording.analysis")) {
                this.setDefaultMessage(page, (Boolean)e.getNewValue());
            }
        };
        FlightRecorderUI.getDefault().getPreferenceStore().addPropertyChangeListener(this.analysisEnabledPropertyListener);
        this.setDefaultMessage(page, FlightRecorderUI.getDefault().isAnalysisEnabled());
        return page;
    }

    private void setDefaultMessage(MessagePage page, Boolean analysisEnabled) {
        page.setMessage(analysisEnabled != false ? Messages.RESULT_VIEW_NO_EDITOR_SELECTED : Messages.RESULT_VIEW_ANALYSIS_DISABLED);
    }

    protected PageBookView.PageRec doCreatePage(IWorkbenchPart part) {
        if (this.isImportant(part)) {
            ResultPage p = ((JfrEditor)part).createResultPage();
            this.initPage((IPageBookViewPage)p);
            p.createControl((Composite)this.getPageBook());
            PlatformUI.getWorkbench().getHelpSystem().setHelp(p.getControl(), HELP_CONTEXT_ID);
            return new PageBookView.PageRec(part, (IPage)p);
        }
        return new PageBookView.PageRec(part, this.getDefaultPage());
    }

    protected void doDestroyPage(IWorkbenchPart part, PageBookView.PageRec pageRecord) {
        FlightRecorderUI.getDefault().getPreferenceStore().removePropertyChangeListener(this.analysisEnabledPropertyListener);
        pageRecord.page.dispose();
        pageRecord.dispose();
    }

    protected IWorkbenchPart getBootstrapPart() {
        IWorkbenchPage page = this.getSite().getPage();
        if (page != null) {
            return page.getActiveEditor();
        }
        return null;
    }

    protected boolean isImportant(IWorkbenchPart part) {
        return part instanceof JfrEditor && FlightRecorderUI.getDefault().isAnalysisEnabled();
    }
}

