/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.flightrecorder.ui;

import com.oracle.jmc.flightrecorder.rules.Result;
import com.oracle.jmc.flightrecorder.ui.DataPageDescriptor;
import com.oracle.jmc.flightrecorder.ui.FlightRecorderUI;
import com.oracle.jmc.flightrecorder.ui.IPageContainer;
import com.oracle.jmc.flightrecorder.ui.JfrEditor;
import com.oracle.jmc.flightrecorder.ui.messages.internal.Messages;
import com.oracle.jmc.flightrecorder.ui.overview.ResultReportUi;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.part.Page;

public class ResultPage
extends Page {
    private Browser browser;
    private ResultReportUi report;
    private Label errorMessage;
    private IPageContainer editor;
    private SashForm container;
    private IPropertyChangeListener analysisEnabledListener;
    private Set<String> topics;

    public void createControl(Composite parent) {
        this.container = new SashForm(parent, 256);
        this.errorMessage = new Label((Composite)this.container, 0);
        try {
            DataPageDescriptor currentPage;
            this.browser = new Browser((Composite)this.container, 0);
            this.container.setMaximizedControl((Control)this.browser);
            this.report = new ResultReportUi(true);
            this.report.setShowOk(true);
            if (this.editor != null && (currentPage = ((JfrEditor)this.editor).getCurrentPage()) != null) {
                this.setTopics(Arrays.asList(currentPage.getTopics()));
            }
        }
        catch (SWTError | SWTException e2) {
            this.browser = null;
            this.container.setMaximizedControl((Control)this.errorMessage);
            this.errorMessage.setText(e2.getMessage());
        }
        this.analysisEnabledListener = e -> {
            if (e.getProperty().equals("flightrecorder.controlpanel.enable.recording.analysis")) {
                Boolean isEnabled = (Boolean)e.getNewValue();
                this.container.setMaximizedControl((Control)(isEnabled != false ? this.browser : this.errorMessage));
                this.errorMessage.setText(isEnabled != false ? Messages.RESULT_VIEW_NO_EDITOR_SELECTED : Messages.RESULT_VIEW_ANALYSIS_DISABLED);
            }
        };
        FlightRecorderUI.getDefault().getPreferenceStore().addPropertyChangeListener(this.analysisEnabledListener);
    }

    public Control getControl() {
        return this.container;
    }

    public void dispose() {
        FlightRecorderUI.getDefault().getPreferenceStore().removePropertyChangeListener(this.analysisEnabledListener);
        super.dispose();
    }

    public void setFocus() {
        if (this.browser != null && FlightRecorderUI.getDefault().isAnalysisEnabled()) {
            this.browser.setFocus();
        } else {
            this.errorMessage.setFocus();
        }
    }

    public void setEditor(IPageContainer editor) {
        this.editor = editor;
    }

    public void setTopics(Collection<String> topics) {
        this.topics = new HashSet<String>(topics);
        this.report.setResults(this.editor.getRuleManager().getResults(topics));
        this.report.createHtmlOverview(this.browser, this.editor, null);
    }

    public void updateRule(Result result) {
        if (this.topics.contains(result.getRule().getTopic())) {
            this.report.updateRule(result.getRule());
        }
    }
}

