/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.flightrecorder.ui;

import com.oracle.jmc.common.IWritableState;
import com.oracle.jmc.common.util.StateToolkit;
import com.oracle.jmc.common.util.StatefulState;
import com.oracle.jmc.flightrecorder.ui.FlightRecorderUI;
import com.oracle.jmc.flightrecorder.ui.IDataPageFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;
import org.xml.sax.SAXException;

class PageExtensionReader {
    private static final String ELEMENT_PAGES = "pages";
    private static final String ELEMENT_PAGE = "page";
    private static final String ELEMENT_FACTORY = "factory";
    private static final String ATTRIBUTE_CLASS = "class";
    private static final String ATTRIBUTE_ID = "id";
    private static final String ATTRIBUTE_WEIGHT = "weight";
    private static final String ATTRIBUTE_FILE = "file";
    private static final String DATA_PAGE = "com.oracle.jmc.flightrecorder.ui.datapage";
    private static final Comparator<PageBundle> ASCENDING_WEIGHT = Comparator.comparing(p -> p.weight, Comparator.nullsLast(Comparator.naturalOrder()));
    private final Map<String, IDataPageFactory> factories = new HashMap<String, IDataPageFactory>();
    private final List<StatefulState> pages;

    PageExtensionReader() {
        ArrayList<PageBundle> pageBundleList = new ArrayList<PageBundle>();
        IConfigurationElement[] iConfigurationElementArray = Platform.getExtensionRegistry().getExtensionPoint(DATA_PAGE).getConfigurationElements();
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ce = iConfigurationElementArray[n2];
            switch (ce.getName()) {
                case "factory": {
                    String factoryId = ce.getAttribute(ATTRIBUTE_ID);
                    try {
                        IDataPageFactory factory = (IDataPageFactory)ce.createExecutableExtension(ATTRIBUTE_CLASS);
                        IDataPageFactory otherFactory = this.factories.put(factoryId, factory);
                        if (otherFactory == null) break;
                        FlightRecorderUI.getDefault().getLogger().log(Level.SEVERE, "Factory ID " + factoryId + " was used by both " + factory + " and " + otherFactory);
                    }
                    catch (CoreException e) {
                        FlightRecorderUI.getDefault().getLogger().log(Level.SEVERE, "Could not create factory with id " + factoryId, e);
                    }
                    break;
                }
                case "pages": {
                    Stream<StatefulState> pagesInPluginXml = Stream.of(ce.getChildren(ELEMENT_PAGE)).map(PageExtensionReader::elementToState);
                    Stream<StatefulState> pagesInExternalFile = PageExtensionReader.readPagesFromFile(ce);
                    pageBundleList.add(new PageBundle(ce.getAttribute(ATTRIBUTE_WEIGHT), Stream.concat(pagesInPluginXml, pagesInExternalFile)));
                    break;
                }
                default: {
                    FlightRecorderUI.getDefault().getLogger().log(Level.SEVERE, String.valueOf(ce.getName()) + " element not recognized");
                }
            }
            ++n2;
        }
        this.pages = pageBundleList.stream().sorted(ASCENDING_WEIGHT).flatMap(pages -> pages.pages).collect(Collectors.toList());
    }

    Map<String, IDataPageFactory> getFactories() {
        return this.factories;
    }

    Stream<StatefulState> getPages() {
        return this.pages.stream();
    }

    private static StatefulState elementToState(IConfigurationElement element) {
        return StatefulState.create(toState -> PageExtensionReader.write(element, toState));
    }

    private static void write(IConfigurationElement element, IWritableState toState) {
        String[] stringArray = element.getAttributeNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String attr = stringArray[n2];
            toState.putString(attr, element.getAttribute(attr));
            ++n2;
        }
        Stream.of(element.getChildren()).forEach(ce -> PageExtensionReader.write(ce, toState.createChild(ce.getName())));
    }

    private static Stream<StatefulState> readPagesFromFile(IConfigurationElement ce) {
        String fileName = ce.getAttribute(ATTRIBUTE_FILE);
        if (fileName != null) {
            String bundleId = ce.getContributor().getName();
            Bundle bundle = Platform.getBundle((String)bundleId);
            try {
                StatefulState fileContent = StatefulState.create(toState -> {
                    try {
                        Throwable throwable = null;
                        Object var4_6 = null;
                        try (InputStream is = FileLocator.openStream((Bundle)bundle, (IPath)new Path(fileName), (boolean)false);){
                            StateToolkit.saveXMLDocumentTo((Reader)new InputStreamReader(is, StandardCharsets.UTF_8), (IWritableState)toState);
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    catch (IOException | ParserConfigurationException | SAXException e) {
                        throw new RuntimeException(e);
                    }
                });
                StatefulState translatedFileContent = StatefulState.create(toState -> PageExtensionReader.writeTranslated(fileContent, toState, bundle));
                return Stream.of(translatedFileContent.getChildren());
            }
            catch (RuntimeException e) {
                FlightRecorderUI.getDefault().getLogger().log(Level.SEVERE, "Could not load pages from " + fileName + " in bundle " + bundleId, e);
            }
        }
        return Stream.empty();
    }

    private static void writeTranslated(StatefulState element, IWritableState toState, Bundle bundle) {
        String[] stringArray = element.getAttributeKeys();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String attr = stringArray[n2];
            toState.putString(attr, Platform.getResourceString((Bundle)bundle, (String)element.getAttribute(attr)));
            ++n2;
        }
        Stream.of(element.getChildren()).forEach(ce -> PageExtensionReader.writeTranslated(ce, toState.createChild(ce.getType()), bundle));
    }

    private static final class PageBundle {
        String weight;
        Stream<StatefulState> pages;

        PageBundle(String weight, Stream<StatefulState> pages) {
            this.weight = weight;
            this.pages = pages;
        }
    }
}

