/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.flightrecorder.ui;

import com.oracle.jmc.flightrecorder.ui.DataPageDescriptor;
import com.oracle.jmc.flightrecorder.ui.JfrEditor;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.INavigationLocation;

class JfrNavigationLocation
implements INavigationLocation {
    private final JfrEditor m_editor;
    private final DataPageDescriptor m_page;
    private boolean m_disposed;

    public JfrNavigationLocation(JfrEditor editor, DataPageDescriptor page) {
        this.m_editor = editor;
        this.m_page = page;
    }

    public void dispose() {
        this.m_disposed = true;
    }

    public void releaseState() {
    }

    public void saveState(IMemento memento) {
    }

    public void restoreState(IMemento memento) {
        this.m_disposed = true;
    }

    public void restoreLocation() {
        if (!this.m_disposed) {
            this.m_editor.navigateTo(this.m_page);
        }
    }

    public boolean mergeInto(INavigationLocation currentLocation) {
        if (this.m_disposed) {
            return true;
        }
        if (currentLocation instanceof JfrNavigationLocation) {
            JfrNavigationLocation that = (JfrNavigationLocation)currentLocation;
            return that.m_editor == this.m_editor && that.m_page == this.m_page;
        }
        return false;
    }

    public Object getInput() {
        return null;
    }

    public String getText() {
        return String.valueOf(this.m_page.getName()) + " [" + this.m_editor.getPartName() + "]";
    }

    public String toString() {
        return String.valueOf(super.toString()) + '[' + this.getText() + ']';
    }

    public void setInput(Object input) {
    }

    public void update() {
    }
}

