/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.flightrecorder.ui;

import com.oracle.jmc.common.unit.IQuantity;
import com.oracle.jmc.common.unit.ITypedQuantity;
import com.oracle.jmc.common.unit.QuantityConversionException;
import com.oracle.jmc.common.unit.UnitLookup;
import com.oracle.jmc.flightrecorder.ui.JfrEditor;
import com.oracle.jmc.flightrecorder.ui.PageManager;
import com.oracle.jmc.flightrecorder.ui.common.ImageConstants;
import com.oracle.jmc.flightrecorder.ui.messages.internal.Messages;
import com.oracle.jmc.flightrecorder.ui.preferences.PreferenceKeys;
import com.oracle.jmc.ui.MCAbstractUIPlugin;
import com.oracle.jmc.ui.misc.DisplayToolkit;
import java.io.File;
import java.io.IOException;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.osgi.framework.BundleContext;

public final class FlightRecorderUI
extends MCAbstractUIPlugin {
    public static final String FLIGHT_RECORDING_FILE_EXTENSION = "jfr";
    public static final String TEMP_RECORDINGS_FOLDER = "tempRecordings";
    public static final String PLUGIN_ID = "com.oracle.jmc.flightrecorder.ui";
    private static final String PAGE_MANAGER_ID = "pageManager";
    private static final String PAGE_STRUCTURE_LOCK_ID = "pageStructureLock";
    private static FlightRecorderUI plugin;
    private PageManager pageManager;

    public FlightRecorderUI() {
        super(PLUGIN_ID);
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        if (this.pageManager != null) {
            this.getPreferences(new String[0]).put(PAGE_MANAGER_ID, this.pageManager.getState());
        }
        super.stop(context);
    }

    protected void initializeImageRegistry(ImageRegistry registry) {
        this.registerFromImageConstantClass(registry, ImageConstants.class);
    }

    public boolean removeFinishedRecordings() {
        return this.getPreferenceStore().getBoolean("flightRecorder.removeFinishedRecording");
    }

    public boolean getConfirmRemoveTemplate() {
        return this.getPreferenceStore().getBoolean("flightRecorder.confirmRemoveTemplate");
    }

    public void setConfirmRemoveTemplate(boolean value) {
        this.getPreferenceStore().setValue("flightRecorder.confirmRemoveTemplate", value);
    }

    public IQuantity getLastPartToDumpTimespan() {
        return FlightRecorderUI.parseDumpTimespan(this.getPreferenceStore().getString("flightrecorder.controlpanel.default.dump.timespan"));
    }

    public static IQuantity parseDumpTimespan(String timespan) {
        try {
            return UnitLookup.TIMESPAN.parsePersisted(timespan);
        }
        catch (QuantityConversionException e) {
            return PreferenceKeys.DUMP_TIMESPAN_DEFAULT;
        }
    }

    public IQuantity getSelectionStoreSize() {
        return FlightRecorderUI.parseSelectionStoreSize(this.getPreferenceStore().getString("flightrecorder.selectionstore.size"));
    }

    public static IQuantity parseSelectionStoreSize(String size) {
        try {
            return UnitLookup.NUMBER.parsePersisted(size);
        }
        catch (QuantityConversionException e) {
            return PreferenceKeys.DEFAULT_SELECTION_STORE_SIZE;
        }
    }

    public IQuantity getItemListSize() {
        return FlightRecorderUI.parseItemListSize(this.getPreferenceStore().getString("flightrecorder.itemlist.size"));
    }

    public static IQuantity parseItemListSize(String size) {
        try {
            return UnitLookup.NUMBER.parsePersisted(size);
        }
        catch (QuantityConversionException e) {
            return PreferenceKeys.DEFAULT_ITEM_LIST_SIZE;
        }
    }

    public static String validateDumpTimespan(String text) {
        try {
            ITypedQuantity timespan = UnitLookup.TIMESPAN.parseInteractive(text);
            if (timespan.doubleValue() <= 0.0) {
                return Messages.DUMP_RECORDING_TIMESPAN_LESS_THAN_ZERO;
            }
        }
        catch (QuantityConversionException qce) {
            return NLS.bind((String)Messages.DUMP_RECORDING_TIMESPAN_UNPARSABLE, (Object)qce.getLocalizedMessage());
        }
        return null;
    }

    public boolean isSetLastPartToDump() {
        return this.getPreferenceStore().getInt("flightrecorder.controlpanel.default.dump.type") == 1;
    }

    public boolean isSetDumpWhole() {
        return this.getPreferenceStore().getInt("flightrecorder.controlpanel.default.dump.type") == 2;
    }

    public boolean getShowMonitoringWarning() {
        return this.getPreferenceStore().getBoolean("flightrecorder.controlpanel.show.monitoring.warning");
    }

    public void setShowMonitoringWarning(boolean showWarning) {
        this.getPreferenceStore().setValue("flightrecorder.controlpanel.show.monitoring.warning", showWarning);
    }

    public boolean isAnalysisEnabled() {
        return this.getPreferenceStore().getBoolean("flightrecorder.controlpanel.enable.recording.analysis");
    }

    public boolean includeExperimentalEventsAndFields() {
        return this.getPreferenceStore().getBoolean("flightrecorder.ui.includeExperimentalEventsAndFields");
    }

    public void setPageStructureLocked(boolean lock) {
        this.getPreferences(new String[0]).putBoolean(PAGE_STRUCTURE_LOCK_ID, lock);
    }

    public boolean isPageStructureLocked() {
        return this.getPreferences(new String[0]).getBoolean(PAGE_STRUCTURE_LOCK_ID, false);
    }

    public File getTempRecordingsDir() throws IOException {
        File dir = this.getStateLocation().append(TEMP_RECORDINGS_FOLDER).toFile();
        if (!dir.isDirectory() && !dir.mkdirs()) {
            throw new IOException(NLS.bind((String)Messages.FOLDER_COULD_NOT_BE_CREATED, (Object)dir.getAbsolutePath()));
        }
        return dir;
    }

    public PageManager getPageManager() {
        if (this.pageManager == null) {
            IWorkbench workbench = this.getWorkbench();
            Runnable callback = () -> DisplayToolkit.safeAsyncExec(() -> FlightRecorderUI.refreshJfrEditors(workbench));
            this.pageManager = new PageManager(this.getPreferences(new String[0]).get(PAGE_MANAGER_ID, null), callback);
        }
        return this.pageManager;
    }

    private static void refreshJfrEditors(IWorkbench workbench) {
        IWorkbenchWindow[] iWorkbenchWindowArray = workbench.getWorkbenchWindows();
        int n = iWorkbenchWindowArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchWindow ww = iWorkbenchWindowArray[n2];
            IWorkbenchPage[] iWorkbenchPageArray = ww.getPages();
            int n3 = iWorkbenchPageArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IWorkbenchPage wp = iWorkbenchPageArray[n4];
                IEditorReference[] iEditorReferenceArray = wp.getEditorReferences();
                int n5 = iEditorReferenceArray.length;
                int n6 = 0;
                while (n6 < n5) {
                    IEditorReference er = iEditorReferenceArray[n6];
                    IEditorPart editor = er.getEditor(false);
                    if (editor instanceof JfrEditor) {
                        ((JfrEditor)editor).refreshPages();
                    }
                    ++n6;
                }
                ++n4;
            }
            ++n2;
        }
    }

    public static FlightRecorderUI getDefault() {
        return plugin;
    }
}

