/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.flightrecorder.ui;

import com.oracle.jmc.common.util.TypedPreference;
import com.oracle.jmc.flightrecorder.rules.IRule;
import com.oracle.jmc.flightrecorder.ui.messages.internal.Messages;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class AttributeConfiguration {
    private String title;
    private String description;
    private List<AttributeGroup> pageAttributes;

    private AttributeConfiguration(String title, String description) {
        this.title = title;
        this.description = description;
    }

    public AttributeConfiguration(String title, String description, List<AttributeGroup> attributeGroups) {
        this(title, description);
        this.pageAttributes = attributeGroups;
    }

    public AttributeConfiguration(String title, String description, AttributeGroup ... attributeGroups) {
        this(title, description, new ArrayList<AttributeGroup>(Arrays.asList(attributeGroups)));
    }

    public AttributeConfiguration(IRule rule) {
        this(MessageFormat.format(Messages.ATTRIBUTE_CONFIG_RULE, rule.getName()), MessageFormat.format(Messages.ATTRIBUTE_CONFIG_RULE_DESC, rule.getName()), new AttributeGroup(rule.getName(), rule.getConfigurationAttributes()));
    }

    public AttributeConfiguration(Collection<IRule> rules) {
        this(MessageFormat.format(Messages.ATTRIBUTE_CONFIG_RULES, rules.size()), MessageFormat.format(Messages.ATTRIBUTE_CONFIG_RULES_DESC, rules.size()), new ArrayList<AttributeGroup>());
        this.addAttributesFromRules(rules);
    }

    public void addAttributesFromRules(Collection<IRule> rules) {
        Set currentPreferences = this.pageAttributes.stream().map(a -> ((AttributeGroup)a).attributes).flatMap(a -> a.stream()).map(a -> ((GroupEntry)a).preference).collect(Collectors.toSet());
        List unknownPreferences = rules.stream().flatMap(r -> r.getConfigurationAttributes().stream()).filter(p -> !currentPreferences.contains(p)).collect(Collectors.toList());
        if (!unknownPreferences.isEmpty()) {
            Set preferences = rules.parallelStream().filter(r -> r.getConfigurationAttributes().size() > 0).flatMap(r -> r.getConfigurationAttributes().stream()).distinct().collect(Collectors.toSet());
            HashMap rulesByPreferences = new HashMap();
            for (TypedPreference preference : preferences) {
                List rulesWithPreference = rules.stream().filter(rule -> rule.getConfigurationAttributes().contains(preference)).collect(Collectors.toList());
                rulesByPreferences.put(preference.getIdentifier(), rulesWithPreference);
            }
            ArrayList rest = new ArrayList();
            for (IRule rule2 : rules) {
                List<TypedPreference<?>> unique = rule2.getConfigurationAttributes().stream().filter(p -> rulesByPreferences.get(p.getIdentifier()).size() == 1).collect(Collectors.toList());
                rest.addAll(rule2.getConfigurationAttributes().stream().filter(p -> rulesByPreferences.get(p.getIdentifier()).size() > 1).collect(Collectors.toList()));
                if (unique.size() <= 0) continue;
                this.pageAttributes.add(new AttributeGroup(rule2.getName(), (Collection<TypedPreference<?>>)unique));
            }
            Collections.sort(this.pageAttributes, (p1, p2) -> ((AttributeGroup)p1).groupTitle.compareTo(((AttributeGroup)p2).groupTitle));
            if (rest.size() > 0) {
                this.pageAttributes.add(new AttributeGroup(Messages.ATTRIBUTE_CONFIG_SHARED_GROUP_NAME, rest));
            }
        }
    }

    public String getTitle() {
        return this.title;
    }

    public String getDescription() {
        return this.description;
    }

    public List<AttributeGroup> getPageAttributes() {
        return this.pageAttributes;
    }

    public static class AttributeGroup {
        private String groupTitle;
        private List<GroupEntry> attributes;

        public AttributeGroup(String title, GroupEntry ... attributes) {
            this.groupTitle = title;
            this.attributes = Arrays.asList(attributes);
        }

        public AttributeGroup(String title, List<GroupEntry> attributes) {
            this.groupTitle = title;
            this.attributes = attributes;
        }

        public AttributeGroup(String title, Collection<TypedPreference<?>> preferences) {
            this.groupTitle = title;
            this.attributes = new ArrayList<GroupEntry>();
            for (TypedPreference<?> preference : preferences) {
                this.attributes.add(new GroupEntry(preference.getLabel(), preference));
            }
        }

        public List<GroupEntry> getEntries() {
            return this.attributes;
        }

        public String getTitle() {
            return this.groupTitle;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.groupTitle);
            for (GroupEntry entry : this.attributes) {
                sb.append(", ");
                sb.append("[");
                sb.append(entry.getName());
                sb.append(", ");
                sb.append(entry.getPreference());
                sb.append("]");
            }
            return sb.toString();
        }
    }

    public static class GroupEntry {
        private String simpleName;
        private TypedPreference<?> preference;

        public GroupEntry(String name, TypedPreference<?> preference) {
            this.simpleName = name;
            this.preference = preference;
        }

        public String getName() {
            return this.simpleName;
        }

        public TypedPreference<?> getPreference() {
            return this.preference;
        }
    }
}

