/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.xdg;

import com.sun.deploy.association.Association;
import com.sun.deploy.association.AssociationAlreadyRegisteredException;
import com.sun.deploy.association.AssociationNotRegisteredException;
import com.sun.deploy.association.RegisterFailedException;
import com.sun.deploy.association.utility.AppAssociationWriter;
import com.sun.deploy.model.LocalApplicationProperties;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.xdg.Associations;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;

public class XDGAppAssociationWriter
implements AppAssociationWriter {
    public XDGAppAssociationWriter(LocalApplicationProperties lap) {
    }

    @Override
    public void checkAssociationValidForRegistration(Association assoc) throws IllegalArgumentException {
        if (assoc.getName() == null || assoc.getMimeType() == null) {
            throw new IllegalArgumentException("The given association is invalid. It should specify both the name and mimeType fields to perform this operation.");
        }
    }

    @Override
    public void checkAssociationValidForUnregistration(Association assoc) throws IllegalArgumentException {
        if (assoc.getName() == null) {
            throw new IllegalArgumentException("The given association is invalid. It should specify the name field to perform this operation.");
        }
    }

    @Override
    public boolean isAssociationExist(Association assoc, int level) {
        Associations assImpl = Associations.getInstance();
        return assImpl.isAssociationExist(assoc, level);
    }

    @Override
    public void registerAssociation(Association assoc, int level) throws AssociationAlreadyRegisteredException, RegisterFailedException {
        Trace.println("XDGAppAssociationWriter.registerAssociation " + assoc.getMimeType(), TraceLevel.TEMP);
        this.writeMimetype(assoc, level);
        this.updateMimeDatabase(level);
        this.makeApplicationDefault(assoc, level);
        this.updateDesktopDatabase(level);
    }

    private void writeMimetype(Association assoc, int level) throws RegisterFailedException {
        File mimetypeFile = Associations.getMimeTypeFile(assoc, level);
        Trace.println("XDGAppAssociationWriter.writeMimetype " + mimetypeFile, TraceLevel.TEMP);
        try {
            FileOutputStream fos = new FileOutputStream(mimetypeFile);
            OutputStreamWriter osw = new OutputStreamWriter(fos);
            BufferedWriter w = new BufferedWriter(osw);
            w.write("<?xml version=\"1.0\"?>\n");
            w.write("<mime-info xmlns='http://www.freedesktop.org/standards/shared-mime-info'>\n");
            w.write("<mime-type type=\"" + assoc.getMimeType() + "\">\n");
            w.write("<comment>" + assoc.getDescription() + "</comment>\n");
            for (String ext : assoc.getFileExtList()) {
                w.write("<glob pattern=\"*" + ext + "\"/>");
            }
            w.write("\n");
            w.write("</mime-type>\n");
            w.write("</mime-info>\n");
            w.close();
        }
        catch (FileNotFoundException ex) {
            Trace.ignored(ex);
            throw new RegisterFailedException();
        }
        catch (IOException ex) {
            Trace.ignored(ex);
            throw new RegisterFailedException();
        }
    }

    private void updateMimeDatabase(int level) throws RegisterFailedException {
        Trace.println("XDGAppAssociationWriter.updateMimeDatabase ", TraceLevel.TEMP);
        try {
            String[] mimeBasePath = Associations.getMimeBasePaths(level);
            for (int i = 0; i < mimeBasePath.length; ++i) {
                String[] args = new String[]{"update-mime-database", mimeBasePath[i]};
                Process p = Runtime.getRuntime().exec(args);
                p.waitFor();
            }
        }
        catch (Throwable e) {
            Trace.ignored(e);
            throw new RegisterFailedException();
        }
    }

    private void updateDesktopDatabase(int level) throws RegisterFailedException {
        Trace.println("XDGAppAssociationWriter.updateDesktopDatabase ", TraceLevel.TEMP);
        try {
            String[] appBasePath = Associations.getAppBasePaths(level);
            for (int i = 0; i < appBasePath.length; ++i) {
                String[] args = new String[]{"update-desktop-database", appBasePath[i]};
                Process p = Runtime.getRuntime().exec(args);
                p.waitFor();
            }
        }
        catch (Throwable e) {
            Trace.ignored(e);
            throw new RegisterFailedException();
        }
    }

    private void makeApplicationDefault(Association assoc, int level) throws RegisterFailedException {
        Trace.println("XDGAppAssociationWriter.makeApplicationDefault ", TraceLevel.TEMP);
        try {
            File desktopEntryFile = Associations.getDesktopEntryFile(assoc, level);
            String[] args = new String[]{"xdg-mime", "default", desktopEntryFile.getName(), assoc.getMimeType()};
            Process p = Runtime.getRuntime().exec(args);
            int exitValue = p.waitFor();
            if (exitValue != 0) {
                Trace.println(" xdg-mime default fails, exitValue == " + exitValue);
                throw new RegisterFailedException();
            }
        }
        catch (Throwable e) {
            Trace.ignored(e);
            throw new RegisterFailedException();
        }
    }

    @Override
    public void unregisterAssociation(Association assoc, int level) throws AssociationNotRegisteredException, RegisterFailedException {
        Trace.println("XDGAppAssociationWriter.unregisterAssociation " + assoc.getMimeType(), TraceLevel.TEMP);
        File mimetypeFile = Associations.getMimeTypeFile(assoc, level);
        if (!mimetypeFile.exists()) {
            Trace.print("mime-info file doesn't exist, path == " + mimetypeFile.getAbsolutePath(), TraceLevel.TEMP);
        } else {
            mimetypeFile.delete();
        }
        this.updateMimeDatabase(level);
        this.updateDesktopDatabase(level);
    }
}

