/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.xdg;

import com.sun.deploy.Environment;
import com.sun.deploy.association.Action;
import com.sun.deploy.association.utility.AppAssociationReader;
import com.sun.deploy.model.LocalApplicationProperties;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.xdg.Associations;
import com.sun.deploy.xdg.MimeGlob2File;
import com.sun.deploy.xml.XMLNode;
import com.sun.deploy.xml.XMLParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.xml.sax.SAXException;

public class XDGAppAssociationReader
implements AppAssociationReader {
    private static final String ACTION_COMMAND = "command";

    public XDGAppAssociationReader(LocalApplicationProperties lap) {
    }

    private String getDescriptionByMimeType(String mimeBasePath, String mimeType) {
        String desc = null;
        String fullFilePath = mimeBasePath + File.separatorChar + mimeType + ".xml";
        if (new File(fullFilePath).exists()) {
            try {
                FileInputStream fis = new FileInputStream(fullFilePath);
                InputStreamReader isr = new InputStreamReader(fis);
                BufferedReader br = new BufferedReader(isr);
                StringBuffer xmlFile = new StringBuffer();
                String line = br.readLine();
                while (line != null) {
                    xmlFile.append(line);
                    line = br.readLine();
                }
                br.close();
                XMLParser parser = new XMLParser(xmlFile.toString());
                XMLNode root = parser.parse();
                XMLNode node = root.getNested();
                while (!node.getName().equals("comment")) {
                    node = node.getNext();
                }
                desc = node.getNested().getName();
            }
            catch (IOException e) {
                Trace.ignored(e);
            }
            catch (SAXException se) {
                Trace.ignored(se);
            }
        }
        return desc;
    }

    @Override
    public String getDescriptionByMimeType(String mimeType) {
        String desc = null;
        String[] mimeBasePaths = Associations.getMimeBasePaths();
        for (int i = 0; i < mimeBasePaths.length && desc == null; ++i) {
            desc = this.getDescriptionByMimeType(mimeBasePaths[i], mimeType);
        }
        return desc;
    }

    @Override
    public boolean isMimeTypeExist(String mimeType) {
        ArrayList fileExts = new ArrayList();
        String[] mimeBasePaths = Associations.getMimeBasePaths();
        for (int i = 0; i < mimeBasePaths.length; ++i) {
            this.getFileExtListByMimeType(fileExts, mimeBasePaths[i], mimeType);
        }
        return fileExts.size() != 0;
    }

    @Override
    public String getDescriptionByFileExt(String fileExt) {
        String mimeType = this.getMimeTypeByFileExt(fileExt);
        String desc = mimeType != null ? this.getDescriptionByMimeType(mimeType) : null;
        return desc;
    }

    @Override
    public String getMimeTypeByURL(URL url) {
        throw new UnsupportedOperationException("Unexpected call");
    }

    private void getFileExtListByMimeType(List fileExts, String mimeBasePath, String mimeType) {
        String glob2Path = mimeBasePath + File.separatorChar + "globs2";
        MimeGlob2File mg2f = new MimeGlob2File(glob2Path);
        mg2f.getFileExtListByMimeType(fileExts, mimeType);
    }

    public List getFileExtListByMimeType(String mimeType) {
        ArrayList fileExts = new ArrayList();
        String[] mimeBasePaths = Associations.getMimeBasePaths();
        for (int i = 0; i < mimeBasePaths.length; ++i) {
            this.getFileExtListByMimeType(fileExts, mimeBasePaths[i], mimeType);
        }
        return fileExts;
    }

    private String getMimeTypeByFileExt(String mimeBasePath, String fileExt) {
        String glob2Path = mimeBasePath + File.separatorChar + "globs2";
        MimeGlob2File mg2f = new MimeGlob2File(glob2Path);
        return mg2f.getMimeTypeByFileExt(fileExt);
    }

    @Override
    public String getMimeTypeByFileExt(String fileExt) {
        String mimeType = null;
        String[] mimeBasePaths = Associations.getMimeBasePaths();
        for (int i = 0; i < mimeBasePaths.length && mimeType == null; ++i) {
            mimeType = this.getMimeTypeByFileExt(mimeBasePaths[i], fileExt);
        }
        return mimeType;
    }

    @Override
    public String getIconFileNameByMimeType(String mimeType) {
        return Environment.getJavaHome() + File.separator + "lib" + File.separator + "deploy" + File.separator + "java-icon.ico";
    }

    @Override
    public String getIconFileNameByFileExt(String fileExt) {
        return Environment.getJavaHome() + File.separator + "lib" + File.separator + "deploy" + File.separator + "java-icon.ico";
    }

    public List getActionListByFileExt(String fileExt) {
        ArrayList<Action> actionList = new ArrayList<Action>();
        actionList.add(new Action("open", ACTION_COMMAND));
        return actionList;
    }

    public List getActionListByMimeType(String mimeType) {
        ArrayList<Action> actionList = new ArrayList<Action>();
        actionList.add(new Action("open", ACTION_COMMAND));
        return actionList;
    }

    @Override
    public boolean isFileExtExist(String fileExt) {
        String mimeType = this.getMimeTypeByFileExt(fileExt);
        return mimeType != null;
    }

    public List getAssociations() {
        throw new RuntimeException("Unexpected call");
    }
}

