/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.xdg;

import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

class MimeGlob2File {
    private String filePath;
    private Map fileExtToMime;

    MimeGlob2File(String path) {
        this.filePath = path;
    }

    private void initIfNecessary() {
        File file;
        if (this.fileExtToMime == null) {
            this.fileExtToMime = new HashMap();
        }
        if ((file = new File(this.filePath)).exists()) {
            try {
                FileInputStream fis = new FileInputStream(file);
                InputStreamReader isr = new InputStreamReader(fis);
                BufferedReader br = new BufferedReader(isr);
                String line = br.readLine();
                while (line != null) {
                    this.parseLine(line);
                    line = br.readLine();
                }
            }
            catch (IOException ex) {
                Trace.ignored(ex);
            }
        } else {
            Trace.println("globs2 doesn't exist, path == " + this.filePath, TraceLevel.TEMP);
        }
    }

    private void parseLine(String line) {
        if (line.startsWith("#")) {
            return;
        }
        StringTokenizer tokens = new StringTokenizer(line, ":");
        String prio = tokens.nextToken();
        String mime = tokens.nextToken();
        String fileExt = tokens.nextToken();
        this.fileExtToMime.put(fileExt, mime);
    }

    boolean mapsFileExtToMimetype(String fileExt, String mimeType) {
        this.initIfNecessary();
        String mappedMime = (String)this.fileExtToMime.get(fileExt);
        boolean doesMap = false;
        if (mappedMime != null) {
            doesMap = mappedMime.equals(mimeType);
        }
        return doesMap;
    }

    void getFileExtListByMimeType(List fileExts, String mimeType) {
        this.initIfNecessary();
        Set keySet = this.fileExtToMime.keySet();
        for (String fileExt : keySet) {
            if (!this.mapsFileExtToMimetype(fileExt, mimeType)) continue;
            if (fileExt.startsWith("*.")) {
                fileExt = fileExt.substring(2, fileExt.length());
            }
            fileExts.add(fileExt);
        }
    }

    String getMimeTypeByFileExt(String fileExt) {
        this.initIfNecessary();
        return (String)this.fileExtToMime.get(fileExt);
    }
}

