/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.xdg;

import com.sun.deploy.Environment;
import com.sun.deploy.association.Association;
import com.sun.deploy.xdg.BaseDir;
import com.sun.deploy.xdg.MimeGlob2File;
import java.io.File;
import java.util.Iterator;

public class Associations {
    private static Associations instance;

    static synchronized Associations getInstance() {
        if (instance == null) {
            instance = new Associations();
        }
        return instance;
    }

    private Associations() {
    }

    public static String[] getMimeBasePaths(int level) {
        BaseDir bd = BaseDir.getInstance();
        if (level == 1) {
            String userDir = bd.getUserDataDir();
            String mimeBasePath = userDir + File.separatorChar + "mime";
            return new String[]{mimeBasePath};
        }
        String[] sysDirs = bd.getSystemDataDirs();
        String[] mimeBasePaths = new String[sysDirs.length];
        for (int i = 0; i < sysDirs.length; ++i) {
            mimeBasePaths[i] = sysDirs[i] + File.separatorChar + "mime";
        }
        return mimeBasePaths;
    }

    public static String[] getMimeBasePaths() {
        int level = Environment.isSystemCacheMode() ? 2 : 1;
        return Associations.getMimeBasePaths(level);
    }

    public static String[] getAppBasePaths(int level) {
        BaseDir bd = BaseDir.getInstance();
        if (level == 1) {
            String userDir = bd.getUserDataDir();
            String appBasePath = userDir + File.separatorChar + "applications";
            return new String[]{appBasePath};
        }
        String[] sysDirs = bd.getSystemDataDirs();
        String[] appBasePaths = new String[sysDirs.length];
        for (int i = 0; i < sysDirs.length; ++i) {
            appBasePaths[i] = sysDirs[i] + File.separatorChar + "applications";
        }
        return appBasePaths;
    }

    public static String[] getAppBasePaths() {
        int level = Environment.isSystemCacheMode() ? 2 : 1;
        return Associations.getAppBasePaths(level);
    }

    private boolean isAssociationExists(String basePath, Association assoc) {
        String glob2Path = basePath + File.separatorChar + "globs2";
        MimeGlob2File mg2f = new MimeGlob2File(glob2Path);
        boolean assoExistsForAll = true;
        Iterator<String> i = assoc.getFileExtList().iterator();
        while (i.hasNext() && assoExistsForAll) {
            String fileExt = i.next();
            if (mg2f.mapsFileExtToMimetype("*" + fileExt, assoc.getMimeType())) continue;
            assoExistsForAll = false;
        }
        return assoExistsForAll;
    }

    boolean isAssociationExist(Association assoc, int level) {
        String[] mimeBasePaths = Associations.getMimeBasePaths(level);
        boolean exists = false;
        for (int i = 0; !exists && i < mimeBasePaths.length; ++i) {
            if (!this.isAssociationExists(mimeBasePaths[i], assoc)) continue;
            exists = true;
        }
        return exists;
    }

    public static File getMimeTypeFile(Association assoc, int level) {
        BaseDir bd = BaseDir.getInstance();
        String baseDir = null;
        baseDir = level == 2 ? bd.getSystemDataDir() : bd.getUserDataDir();
        String mimeDir = baseDir + File.separatorChar + "mime" + File.separatorChar + "packages";
        new File(mimeDir).mkdirs();
        String mimetype = assoc.getMimeType();
        mimetype = mimetype.replace('/', '_');
        String shortName = "oracle-" + assoc.getName() + "_" + mimetype + ".xml";
        return new File(mimeDir + File.separatorChar + shortName);
    }

    public static File getDesktopEntryFile(Association assoc, int level) {
        BaseDir bd = BaseDir.getInstance();
        String baseDir = null;
        baseDir = level == 2 ? bd.getSystemDataDir() : bd.getUserDataDir();
        String appDir = baseDir + File.separatorChar + "applications";
        new File(appDir).mkdirs();
        String mimetype = assoc.getMimeType();
        mimetype = mimetype.replace('/', '_');
        String shortName = "oracle-" + assoc.getName() + "_" + mimetype + ".desktop";
        return new File(appDir + File.separatorChar + shortName);
    }
}

