/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.util;

import com.sun.deploy.config.Config;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLPermission;
import java.security.Permission;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;

public class URLUtil {
    static final BitSet encodedInPath = new BitSet(256);
    private static final WeakHashMap<String, String> canonicalizedURLMap;
    private static final ThreadLocal<Map<String, URL>> packURLOriginal;

    public static void setHostHeader(URLConnection urlc) {
        int port = urlc.getURL().getPort();
        Object host = urlc.getURL().getHost();
        if (port != -1 && port != 80) {
            host = (String)host + ":" + String.valueOf(port);
        }
        urlc.setRequestProperty("Host", (String)host);
    }

    public static URL getBase(URL url) {
        if (url == null) {
            return null;
        }
        String file = url.getFile();
        if (file != null) {
            int idx = file.lastIndexOf(47);
            if (idx != -1) {
                file = file.substring(0, idx + 1);
            }
            try {
                return new URL(url.getProtocol(), url.getHost(), url.getPort(), file);
            }
            catch (MalformedURLException mue) {
                Trace.ignoredException(mue);
            }
        }
        return url;
    }

    public static boolean isUNCFileURL(URL u) {
        if (u == null || !u.getProtocol().equalsIgnoreCase("file")) {
            return false;
        }
        String urlString = u.toString();
        urlString = urlString.replaceAll("////", "//");
        try {
            URL javaUrl = new URL(urlString);
            if (javaUrl.getHost().equals("")) {
                return false;
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return true;
    }

    public static URL asPathURL(URL url) {
        if (url == null) {
            return null;
        }
        String path = url.getFile();
        if (path != null && !path.endsWith("/")) {
            try {
                return new URL(url.getProtocol(), url.getHost(), url.getPort(), url.getFile() + "/");
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return url;
    }

    public static String toNormalizedString(URL u) {
        if (u == null) {
            return "";
        }
        try {
            u = u.getPort() == u.getDefaultPort() ? new URL(u.getProtocol().toLowerCase(), u.getHost().toLowerCase(), -1, u.getFile()) : new URL(u.getProtocol().toLowerCase(), u.getHost().toLowerCase(), u.getPort(), u.getFile());
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return u.toExternalForm();
    }

    public static boolean sameURLs(URL u1, URL u2) {
        if (u1 == null || u2 == null || u1 == u2) {
            return u1 == u2;
        }
        String f1 = u1.getFile();
        String f2 = u2.getFile();
        return f1.length() == f2.length() && URLUtil.sameBase(u1, u2) && f1.equalsIgnoreCase(f2);
    }

    public static boolean sameBase(URL u1, URL u2) {
        return u1 != null && u2 != null && URLUtil.sameHost(u1, u2) && URLUtil.samePort(u1, u2) && URLUtil.sameProtocol(u1, u2);
    }

    private static boolean sameProtocol(URL u1, URL u2) {
        return u1.getProtocol().equals(u2.getProtocol());
    }

    private static boolean sameHost(URL u1, URL u2) {
        String host = u1.getHost();
        String otherHost = u2.getHost();
        if (host == null || otherHost == null) {
            return host == null && otherHost == null;
        }
        return host.length() == otherHost.length() && host.equalsIgnoreCase(otherHost);
    }

    private static boolean samePort(URL u1, URL u2) {
        return URLUtil.getPort(u1) == URLUtil.getPort(u2);
    }

    public static int getPort(URL u) {
        if (u.getPort() != -1) {
            return u.getPort();
        }
        return u.getDefaultPort();
    }

    public static String urlToLocation(URL u) {
        try {
            return u.getProtocol() + "//" + u.getHost().toLowerCase() + ":" + URLUtil.getPort(u);
        }
        catch (Exception e) {
            Trace.ignored(e);
            return null;
        }
    }

    public static String encodePath(String path) {
        StringBuffer sb = new StringBuffer();
        int n = path.length();
        for (int i = 0; i < n; ++i) {
            char c = path.charAt(i);
            if (c == File.separatorChar) {
                sb.append('/');
                continue;
            }
            if (c <= '\u007f') {
                if (encodedInPath.get(c)) {
                    URLUtil.escape(sb, c);
                    continue;
                }
                sb.append(c);
                continue;
            }
            if (c > '\u07ff') {
                URLUtil.escape(sb, (char)(0xE0 | c >> 12 & 0xF));
                URLUtil.escape(sb, (char)(0x80 | c >> 6 & 0x3F));
                URLUtil.escape(sb, (char)(0x80 | c & 0x3F));
                continue;
            }
            URLUtil.escape(sb, (char)(0xC0 | c >> 6 & 0x1F));
            URLUtil.escape(sb, (char)(0x80 | c & 0x3F));
        }
        if (!path.equals(sb.toString())) {
            Trace.println("     String: " + path, TraceLevel.BASIC);
            Trace.println(" encoded to: " + sb.toString(), TraceLevel.BASIC);
        }
        return sb.toString();
    }

    private static void escape(StringBuffer s, char c) {
        s.append('%');
        s.append(Character.forDigit(c >> 4 & 0xF, 16));
        s.append(Character.forDigit(c & 0xF, 16));
    }

    public static String decodePath(String path) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < path.length()) {
            char c;
            block15: {
                c = path.charAt(i);
                if (c != '%') {
                    ++i;
                } else {
                    try {
                        c = URLUtil.unescape(path, i);
                        i += 3;
                        if ((c & 0x80) == 0) break block15;
                        switch (c >> 4) {
                            case 12: 
                            case 13: {
                                char c2 = URLUtil.unescape(path, i);
                                if (c2 >> 6 != 2) {
                                    throw new SecurityException("Unexpected decoding error:");
                                }
                                i += 3;
                                if ((c = (char)((c & 0x1F) << 6 | c2 & 0x3F)) <= '\u007f') {
                                    throw new SecurityException("unsupported overlong encoding");
                                }
                                break;
                            }
                            case 14: {
                                char c2 = URLUtil.unescape(path, i);
                                if (c2 >> 6 != 2) {
                                    throw new SecurityException("Unexpected decoding error:");
                                }
                                char c3 = URLUtil.unescape(path, i += 3);
                                if (c3 >> 6 != 2) {
                                    throw new SecurityException("Unexpected decoding error:");
                                }
                                i += 3;
                                if ((c = (char)((c & 0xF) << 12 | (c2 & 0x3F) << 6 | c3 & 0x3F)) <= '\u007f') {
                                    throw new SecurityException("unsupported overlong encoding");
                                }
                                break;
                            }
                            default: {
                                throw new SecurityException("Unexpected decoding error:");
                            }
                        }
                    }
                    catch (NumberFormatException e) {
                        throw new SecurityException("Unexpected decoding error: " + path, e);
                    }
                }
            }
            sb.append(c);
        }
        if (!path.equals(sb.toString())) {
            Trace.println("     String: " + path, TraceLevel.BASIC);
            Trace.println(" decoded to: " + sb.toString(), TraceLevel.BASIC);
        }
        return sb.toString();
    }

    private static char unescape(String s, int i) {
        return (char)Integer.parseInt(s.substring(i + 1, i + 3), 16);
    }

    public static String getEncodedPath(File file) {
        Object path = file.getAbsolutePath();
        if (!((String)path).endsWith(File.separator) && file.isDirectory()) {
            path = (String)path + File.separator;
        }
        return URLUtil.encodePath((String)path);
    }

    public static String getDecodedPath(URL url) {
        String path = url.getFile();
        path = path.replace('/', File.separatorChar);
        return URLUtil.decodePath(path);
    }

    public static String getPathFromURL(URL url) {
        return URLUtil.getDecodedPath(url);
    }

    public static synchronized String canonicalize(String url) {
        if (url.indexOf("file:") == -1) {
            return url;
        }
        String value = canonicalizedURLMap.get(url);
        if (value != null) {
            return value;
        }
        StringBuilder urlString = new StringBuilder();
        if (url.indexOf("file://///") == 0) {
            urlString.append("file:////");
            urlString.append(url.substring(10));
        } else if (url.indexOf("file:///\\") == 0) {
            urlString.append("file:////");
            urlString.append(url.substring(9));
        } else if (url.indexOf("file://\\") == 0) {
            urlString.append("file:////");
            urlString.append(url.substring(9));
        } else if (url.indexOf("file:\\") == 0) {
            if (url.indexOf(58, 6) != -1 || url.indexOf(124, 6) != -1) {
                urlString.append("file:///");
            } else {
                urlString.append("file:////");
            }
            urlString.append(url.substring(6));
        } else if (url.indexOf("file://") == 0 && url.charAt(7) != '/') {
            if (url.indexOf(58, 7) != -1 || url.indexOf(124, 7) != -1) {
                urlString.append("file:///");
            } else {
                urlString.append("file:////");
            }
            urlString.append(url.substring(7));
        } else {
            urlString.append(url);
        }
        boolean found = false;
        for (int i = 0; i < urlString.length(); ++i) {
            char c = urlString.charAt(i);
            if (c == '\\') {
                urlString.setCharAt(i, '/');
                continue;
            }
            if (found || c != '|') continue;
            urlString.setCharAt(i, ':');
            found = true;
        }
        String canonicalizedURL = urlString.toString();
        canonicalizedURLMap.put(url, canonicalizedURL);
        return canonicalizedURL;
    }

    public static String canonicalizeDocumentBaseURL(String url) {
        int fromIndex = -1;
        int fragmentIndex = url.indexOf(35);
        int queryIndex = url.indexOf(63);
        if (queryIndex != -1 && fragmentIndex != -1) {
            fromIndex = Math.min(fragmentIndex, queryIndex);
        } else if (fragmentIndex != -1) {
            fromIndex = fragmentIndex;
        } else if (queryIndex != -1) {
            fromIndex = queryIndex;
        }
        String strippedURL = fromIndex == -1 ? url : url.substring(0, fromIndex);
        StringBuilder urlBuffer = new StringBuilder(strippedURL);
        int index = urlBuffer.toString().indexOf("|");
        if (index >= 0) {
            urlBuffer.setCharAt(index, ':');
        }
        if (fromIndex != -1) {
            urlBuffer.append(url.substring(fromIndex));
        }
        return urlBuffer.toString();
    }

    private static String slashify(String path, boolean isDirectory) {
        Object p = path;
        if (File.separatorChar != '/') {
            p = ((String)p).replace(File.separatorChar, '/');
        }
        if (!((String)p).startsWith("/")) {
            p = "/" + (String)p;
        }
        if (!((String)p).endsWith("/") && isDirectory) {
            p = (String)p + "/";
        }
        return p;
    }

    public static URL fileToURL(File file) {
        if (file == null) {
            return null;
        }
        try {
            File f = file.getAbsoluteFile();
            Object sp = URLUtil.slashify(f.getPath(), f.isDirectory());
            if (((String)sp).startsWith("//")) {
                sp = "//" + (String)sp;
            }
            return new URI("file", null, (String)sp, null).toURL();
        }
        catch (URISyntaxException x) {
            throw new Error(x);
        }
        catch (MalformedURLException mue) {
            throw new Error(mue);
        }
    }

    public static String urlNoFragString(URL url) {
        String file;
        String host;
        StringBuilder strForm = new StringBuilder(128);
        String protocol = url.getProtocol();
        if (protocol != null) {
            protocol = protocol.toLowerCase();
            strForm.append(protocol);
            strForm.append("://");
        }
        if ((host = url.getHost()) != null) {
            host = host.toLowerCase();
            strForm.append(host);
            int port = url.getPort();
            if (port == -1) {
                try {
                    port = url.getDefaultPort();
                }
                catch (NoSuchMethodError nsme) {
                    port = url.getPort();
                }
            }
            if (port != -1) {
                strForm.append(":").append(port);
            }
        }
        if ((file = url.getFile()) != null) {
            strForm.append(file);
        }
        return strForm.toString();
    }

    public static boolean checkTargetURL(URL sourceURL, URL targetURL) {
        if (sourceURL == null || targetURL == null) {
            return false;
        }
        if ("jar".equals(sourceURL.getProtocol())) {
            try {
                sourceURL = new URL(sourceURL.toString().substring(4));
            }
            catch (MalformedURLException mue) {
                Trace.ignoredException(mue);
                return false;
            }
        }
        if ("jar".equals(targetURL.getProtocol())) {
            try {
                targetURL = new URL(targetURL.toString().substring(4));
            }
            catch (MalformedURLException mue) {
                Trace.ignoredException(mue);
                return false;
            }
        }
        if ("file".equals(sourceURL.getProtocol())) {
            return !URLUtil.isUNCFileURL(sourceURL) || URLUtil.isUNCFileURL(targetURL);
        }
        return !targetURL.getProtocol().equals("file") && !targetURL.getProtocol().equals("netdoc");
    }

    public static boolean checkDocumentURL(URL source, URL target) throws SecurityException {
        if (URLUtil.checkTargetURL(source, target)) {
            return true;
        }
        URL targetURL = target;
        boolean passSecurityCheck = false;
        if ("jar".equals(target.getProtocol())) {
            try {
                targetURL = new URL(target.toString().substring(4));
            }
            catch (MalformedURLException mue) {
                Trace.ignoredException(mue);
                return passSecurityCheck;
            }
        }
        if ("file".equals(targetURL.getProtocol())) {
            try {
                File targetfile = new File(targetURL.getFile());
                targetfile.canRead();
                passSecurityCheck = true;
            }
            catch (SecurityException targetfile) {
                // empty catch block
            }
        }
        if (!passSecurityCheck) {
            String msg = ResourceManager.getString("show.document.denied");
            Trace.println(msg, TraceLevel.SECURITY);
            throw new SecurityException(msg);
        }
        return true;
    }

    public static URL getJarEntryURL(URL jarURL, String entryName) throws MalformedURLException {
        return URLUtil.getJarEntryURL(jarURL.toString(), entryName);
    }

    public static URL getJarEntryURL(String jarURL, String entryName) throws MalformedURLException {
        if (entryName == null) {
            throw new MalformedURLException("null entryName");
        }
        if (!((String)entryName).startsWith("/")) {
            entryName = "/" + (String)entryName;
        }
        return new URL("jar:" + jarURL + "!" + (String)entryName);
    }

    private static int indexOfBangSlash(String spec) {
        int indexOfBang = spec.length();
        while ((indexOfBang = spec.lastIndexOf(33, indexOfBang)) != -1) {
            if (indexOfBang != spec.length() - 1 && spec.charAt(indexOfBang + 1) == '/') {
                return indexOfBang + 1;
            }
            --indexOfBang;
        }
        return -1;
    }

    public static URL getInnerURL(URL sourceURL) {
        String spec = sourceURL.toString();
        if (spec.length() >= 4 && spec.substring(0, 4).equalsIgnoreCase("jar:")) {
            spec = spec.substring(4);
            int index = -1;
            index = URLUtil.indexOfBangSlash(spec);
            if (index == -1) {
                throw new NullPointerException("no !/ in spec");
            }
            try {
                return new URL(spec.substring(0, index - 1));
            }
            catch (MalformedURLException e) {
                throw new NullPointerException("invalid url: " + spec + " (" + e + ")");
            }
        }
        return sourceURL;
    }

    public static URL getPack200URL(URL u, boolean saveInThreadContext) {
        URL pack200RequestURL = null;
        if (u == null) {
            return null;
        }
        String protocol = u.getProtocol();
        String host = u.getHost();
        int port = u.getPort();
        String path = u.getPath();
        String query = u.getQuery();
        StringBuilder file = new StringBuilder(path);
        if (!file.toString().endsWith(".pack.gz")) {
            file.append(".pack.gz");
        }
        if (query != null) {
            file.append("?");
            file.append(query);
        }
        try {
            pack200RequestURL = new URL(protocol, host, port, file.toString());
        }
        catch (MalformedURLException mue) {
            Trace.ignoredException(mue);
        }
        if (saveInThreadContext) {
            Map<String, URL> urls = URLUtil.getOriginalURLMap();
            urls.put(pack200RequestURL.toString(), u);
        }
        return pack200RequestURL;
    }

    private static Map<String, URL> getOriginalURLMap() {
        Map<String, URL> urls = packURLOriginal.get();
        if (urls == null) {
            urls = new HashMap<String, URL>();
            packURLOriginal.set(urls);
        }
        return urls;
    }

    public static void clearPack200Original() {
        packURLOriginal.set(null);
    }

    public static URL getPack200Original(URL u) {
        return URLUtil.getOriginalURLMap().get(u.toString());
    }

    private static String getEmbeddedVersionPath(String path, String version) {
        int index = ((String)path).lastIndexOf("/");
        String filename = ((String)path).substring(index + 1);
        path = ((String)path).substring(0, index + 1);
        String ext = null;
        index = filename.lastIndexOf(".");
        if (index != -1) {
            ext = filename.substring(index + 1);
            filename = filename.substring(0, index);
        }
        StringBuilder filenameSB = new StringBuilder(filename);
        if (version != null) {
            filenameSB.append("__V");
            filenameSB.append(version);
        }
        if (ext != null) {
            filenameSB.append(".");
            filenameSB.append(ext);
        }
        path = (String)path + filenameSB.toString();
        return path;
    }

    public static URL getEmbeddedVersionURL(URL u, String version) {
        if (u == null) {
            return null;
        }
        if (version == null || version.indexOf("*") != -1 || version.indexOf("+") != -1) {
            return u;
        }
        URL versionURL = null;
        String protocol = u.getProtocol();
        String host = u.getHost();
        int port = u.getPort();
        String path = u.getPath();
        path = URLUtil.getEmbeddedVersionPath(path, version);
        try {
            versionURL = new URL(protocol, host, port, path);
        }
        catch (MalformedURLException mue) {
            Trace.ignoredException(mue);
        }
        return versionURL;
    }

    public static Permission getConnectPermission(URL url) throws IOException {
        if (Config.isJavaVersionAtLeast18()) {
            String urlStringLowerCase = url.toString().toLowerCase();
            if (urlStringLowerCase.startsWith("http:") || urlStringLowerCase.startsWith("https:")) {
                return URLUtil.getURLConnectPermission(url);
            }
            if (urlStringLowerCase.startsWith("jar:http:") || urlStringLowerCase.startsWith("jar:https:")) {
                String urlString;
                int bangPos = (urlString = url.toString()).indexOf("!/");
                urlString = urlString.substring(4, bangPos > -1 ? bangPos : urlString.length());
                URL u = new URL(urlString);
                return URLUtil.getURLConnectPermission(u);
            }
            return url.openConnection().getPermission();
        }
        return url.openConnection().getPermission();
    }

    public static Permission getURLConnectPermission(URL url) {
        String urlString = url.getProtocol() + "://" + url.getAuthority() + url.getPath();
        return new URLPermission(urlString);
    }

    public static URL filterProtocols(URL original) {
        String s = URLUtil.filterProtocols(original.toString());
        try {
            return new URL(s);
        }
        catch (MalformedURLException mue) {
            Trace.ignored(mue);
            return original;
        }
    }

    public static String filterProtocols(String s) {
        if (s.startsWith("jnlps://")) {
            return s.replaceFirst("jnlps", "https");
        }
        if (s.startsWith("jnlp://")) {
            return s.replaceFirst("jnlp", "http");
        }
        if (s.startsWith("jnlp:")) {
            return s.substring("jnlp:".length());
        }
        return s;
    }

    static {
        encodedInPath.set(61);
        encodedInPath.set(59);
        encodedInPath.set(63);
        encodedInPath.set(47);
        encodedInPath.set(35);
        encodedInPath.set(32);
        encodedInPath.set(60);
        encodedInPath.set(62);
        encodedInPath.set(37);
        encodedInPath.set(34);
        encodedInPath.set(123);
        encodedInPath.set(125);
        encodedInPath.set(124);
        encodedInPath.set(92);
        encodedInPath.set(94);
        encodedInPath.set(91);
        encodedInPath.set(93);
        encodedInPath.set(96);
        for (int i = 0; i < 32; ++i) {
            encodedInPath.set(i);
        }
        encodedInPath.set(127);
        canonicalizedURLMap = new WeakHashMap();
        packURLOriginal = new ThreadLocal();
    }
}

