/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.uitoolkit.impl.awt.ui;

import com.sun.applet2.preloader.CancelException;
import com.sun.applet2.preloader.Preloader;
import com.sun.applet2.preloader.event.AppInitEvent;
import com.sun.applet2.preloader.event.ConfigEvent;
import com.sun.applet2.preloader.event.DownloadEvent;
import com.sun.applet2.preloader.event.ErrorEvent;
import com.sun.applet2.preloader.event.InitEvent;
import com.sun.applet2.preloader.event.PreloaderEvent;
import com.sun.deploy.Environment;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.ui.AppInfo;
import com.sun.deploy.ui.ProgressDialog;
import com.sun.deploy.ui.UIFactory;
import com.sun.deploy.util.DeploySysAction;
import com.sun.deploy.util.DeploySysRun;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.SwingUtilities;

public class DownloadWindow
extends Preloader
implements ActionListener {
    private ProgressDialog progressDialog = null;
    String titleMsg = null;
    String headingMsg = null;
    private int answer = -1;
    private boolean isVisible = false;
    private boolean isInstaller = false;
    private boolean allowVisible = false;
    private int percentComplete = 0;
    private URL currentUrl = null;
    private boolean isCanceled = false;
    private boolean exitOnCancel = false;
    private String statusString = null;
    private static final int TIMER_UPDATE_RATE = 1500;
    private static final int TIMER_INITIAL_DELAY = 8000;
    private static final int TIMER_RECENT_SIZE = 10;
    static final int DELAY_TO_MAKE_VISIBLE = 2000;
    private boolean showOnDelayEnabled = false;
    Timer delayTimer = null;
    javax.swing.Timer timerObject = null;
    private int[] timerDownloadPercents = new int[10];
    private int timerCount = 0;
    private int timerLastPercent = 0;
    private boolean timerOn = false;
    private String pendingHeading;
    WindowAdapter closeListener = new WindowAdapter(){

        @Override
        public void windowClosing(WindowEvent we) {
            DownloadWindow.this.cancelAction();
            DownloadWindow.this.resetCanceled();
        }
    };
    private boolean hideOnDownloadCompletion = false;
    private volatile boolean lazyInitialize = false;
    private Component owner;
    private AppInfo ainfo;
    private boolean includeOk;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showOnDelay(boolean enabled) {
        if (enabled == this.showOnDelayEnabled) {
            return;
        }
        if (enabled) {
            DownloadWindow downloadWindow = this;
            synchronized (downloadWindow) {
                this.delayTimer = new Timer();
            }
            TimerTask t = new TimerTask(){

                @Override
                public void run() {
                    DownloadWindow.this.cancelTimer();
                    if (!UIFactory.hasVisibleDialogs()) {
                        DownloadWindow.this.setVisible(true);
                    } else {
                        DownloadWindow.this.showOnDelay(false);
                        DownloadWindow.this.showOnDelay(true);
                    }
                }
            };
            this.delayTimer.schedule(t, 2000L);
            this.showOnDelayEnabled = true;
        } else {
            this.cancelTimer();
            this.showOnDelayEnabled = false;
        }
    }

    @Override
    public synchronized Object getOwner() {
        final Object[] ret = new Object[]{null};
        this.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (DownloadWindow.this.progressDialog != null) {
                    ret[0] = DownloadWindow.this.progressDialog.getDialog();
                }
            }
        });
        return ret[0];
    }

    @Override
    public boolean handleEvent(PreloaderEvent event) throws CancelException {
        block0 : switch (event.getType()) {
            case 2: {
                ConfigEvent e = (ConfigEvent)event;
                switch (e.getAction()) {
                    case 1: {
                        this.setStatus((String)e.getValue());
                        break block0;
                    }
                    case 2: {
                        this.setHeading((String)e.getValue(), true);
                        break block0;
                    }
                    case 3: {
                        AppInfo info = (AppInfo)e.getValue();
                        this.initialize(null, info, true, false);
                        break block0;
                    }
                    case 6: {
                        this.setVisible(false);
                        break block0;
                    }
                    case 5: {
                        if (this.progressDialog == null) break block0;
                        this.progressDialog.showProgress(9999);
                        break block0;
                    }
                    default: {
                        return false;
                    }
                }
            }
            case 3: {
                this.showOnDelay(false);
                if (this.isCanceled()) {
                    throw new CancelException("Cancelled");
                }
                DownloadEvent de = (DownloadEvent)event;
                switch (de.getDownloadType()) {
                    case 0: {
                        if (de.getResourceLabel() != null) {
                            this.setStatus(de.getResourceLabel());
                        }
                        this.setHeading(ResourceManager.getString("progress.downloading"), true);
                        this.progress(this.currentUrl, de.getCompletedCount(), de.getTotalCount(), de.getOverallPercentage());
                        break block0;
                    }
                    case 2: {
                        this.setHeading(ResourceManager.getString("progress.patching"), true);
                        this.upgradingArchive(this.currentUrl, null, (int)de.getCompletedCount(), de.getOverallPercentage());
                        break block0;
                    }
                    case 1: {
                        this.setHeading(ResourceManager.getString("progress.verifying"), true);
                        this.validating(this.currentUrl, null, de.getCompletedCount(), de.getTotalCount(), de.getOverallPercentage());
                        break block0;
                    }
                }
                return false;
            }
            case 1: {
                InitEvent ie = (InitEvent)event;
                this.hideOnDownloadCompletion = false;
                switch (ie.getInitType()) {
                    case 2: {
                        this.titleMsg = "progress.title.installer";
                        this.headingMsg = "progress.launching";
                        this.setAllowVisible(true);
                        this.setVisible(true);
                        this.isInstaller = true;
                        break block0;
                    }
                    case 0: {
                        this.titleMsg = "progress.download.jre";
                        this.headingMsg = "progress.downloading";
                        this.setAllowVisible(true);
                        this.setVisible(true);
                        this.isInstaller = true;
                        break block0;
                    }
                    case 1: {
                        this.hideOnDownloadCompletion = true;
                        this.titleMsg = "progress.title.app";
                        this.headingMsg = "progress.downloading";
                        this.setAllowVisible(true);
                        this.setVisible(true);
                        this.startTimer();
                        break block0;
                    }
                    case 4: {
                        this.titleMsg = "progress.title.app";
                        this.headingMsg = "progress.downloading";
                        this.setAllowVisible(true);
                        this.showOnDelay(true);
                        break block0;
                    }
                    case 5: {
                        this.disposeWindow();
                        break block0;
                    }
                }
                return false;
            }
            case 6: {
                ErrorEvent ee = (ErrorEvent)event;
                this.showOnDelay(false);
                this.downloadFailed(ee.getLocation(), ee.getValue());
                return true;
            }
            case 5: {
                this.showOnDelay(false);
                this.setVisible(false);
                return true;
            }
            case 4: {
                this.showOnDelay(false);
                AppInitEvent aie = (AppInitEvent)event;
                switch (aie.getSubtype()) {
                    case 2: {
                        if (!this.isInstaller) {
                            this.setVisible(false);
                            break block0;
                        }
                        this.isInstaller = false;
                        break block0;
                    }
                }
                Trace.println("AppInitEvent that is not handled explicitly", TraceLevel.PRELOADER);
                if (!this.isInstaller) {
                    this.setVisible(false);
                }
                return false;
            }
            default: {
                Trace.println("DownloadWindow can not handle " + event, TraceLevel.PRELOADER);
                return false;
            }
        }
        return true;
    }

    private synchronized void initialize(Component owner, AppInfo ainfo, boolean exitOnCancel, boolean includeOk) {
        this.isCanceled = false;
        this.exitOnCancel = exitOnCancel;
        this.includeOk = includeOk;
        this.owner = owner;
        this.ainfo = ainfo;
        this.lazyInitialize = true;
    }

    private void lazyInitializeIfNeeded() {
        if (!this.lazyInitialize) {
            return;
        }
        Trace.println("Performing actual init of DownloadWindow", TraceLevel.PRELOADER);
        this.lazyInitialize = false;
        String title = ResourceManager.getString("product.javaws.name", "");
        if (this.progressDialog == null) {
            this.progressDialog = UIFactory.createProgressDialog(this.ainfo, this.owner, title, null, this.includeOk);
        } else {
            this.progressDialog.reset(this.ainfo, title, this.includeOk);
        }
        if (this.progressDialog != null) {
            this.progressDialog.addWindowListener(this.closeListener);
        }
    }

    private void startTimer() {
        this.timerObject = new javax.swing.Timer(1500, this);
        this.timerCount = 0;
        this.timerObject.start();
    }

    private void setStatus(String text) {
        this.statusString = text;
        this.setStatusStringText(text);
    }

    private void setEstimatedTime(String text) {
        if (this.statusString == null || this.statusString.length() == 0) {
            this.setStatusStringText(text);
        }
    }

    private void setStatusStringText(final String text) {
        Runnable action = new Runnable(){

            @Override
            public void run() {
                if (DownloadWindow.this.progressDialog != null) {
                    DownloadWindow.this.progressDialog.setProgressStatusText(text);
                }
            }
        };
        this.invokeLater(action);
    }

    private void setHeading(final String text, final boolean singleLine) {
        Runnable action = new Runnable(){

            @Override
            public void run() {
                if (DownloadWindow.this.progressDialog != null) {
                    DownloadWindow.this.progressDialog.setMasthead(text == null ? " " : text, singleLine);
                }
            }
        };
        this.pendingHeading = null;
        this.invokeLater(action);
    }

    private void setHeadingLater(String text) {
        if (this.timerObject != null && this.timerObject.isRunning()) {
            this.pendingHeading = text;
        } else {
            this.setHeading(text, true);
        }
    }

    private void clearWindow() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.clearWindowHelper();
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        DownloadWindow.this.clearWindowHelper();
                    }
                });
            }
            catch (Exception e) {
                Trace.ignoredException(e);
            }
        }
    }

    private void clearWindowHelper() {
        this.reset();
    }

    void disposeWindow() {
        this.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (DownloadWindow.this.progressDialog != null) {
                    DownloadWindow.this.clearWindow();
                    DownloadWindow.this.exitOnCancel = false;
                    DownloadWindow.this.progressDialog.removeWindowListener(DownloadWindow.this.closeListener);
                    DownloadWindow.this.setVisible(false);
                    DownloadWindow.this.progressDialog = null;
                }
            }
        });
    }

    private void reset() {
        this.stopTimer();
        this.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (DownloadWindow.this.progressDialog != null) {
                    DownloadWindow.this.progressDialog.setMasthead("", true);
                    DownloadWindow.this.progressDialog.showProgress(9999);
                    DownloadWindow.this.progressDialog.setProgressStatusText(null);
                }
            }
        });
    }

    private void showDownloadWindow() {
        if (this.allowVisible && !this.isVisible()) {
            this.setVisible(true);
        }
    }

    private void progress(URL rc, long loaded, final long totalSize, final int percent) {
        if (percent != 100) {
            this.showDownloadWindow();
        }
        this.timerOn = true;
        this.percentComplete = percent;
        if (rc != this.currentUrl && rc != null) {
            this.setHeadingLater(ResourceManager.getString("progress.downloading"));
            this.currentUrl = rc;
        }
        this.percentComplete = percent;
        this.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (DownloadWindow.this.progressDialog != null) {
                    if (totalSize == -1L) {
                        DownloadWindow.this.progressDialog.showProgress(9999);
                    } else {
                        DownloadWindow.this.progressDialog.showProgress(percent);
                    }
                }
            }
        });
    }

    private void upgradingArchive(URL rc, String version, int patchPercent, int percent) {
        if (percent != 100) {
            this.showDownloadWindow();
        }
        if (this.currentUrl != rc || patchPercent == 0) {
            if (this.pendingHeading == null) {
                this.setHeadingLater(ResourceManager.getString("progress.patching"));
            }
            this.currentUrl = rc;
        }
    }

    private void validating(URL rc, String version, long count, long total, int percent) {
        if (percent != 100) {
            this.showDownloadWindow();
        } else if (this.hideOnDownloadCompletion) {
            this.setVisible(false);
        }
        if (this.currentUrl != rc || count == 0L) {
            if (this.pendingHeading == null) {
                this.setHeadingLater(ResourceManager.getString("progress.verifying"));
            }
            this.currentUrl = rc;
        }
    }

    private void downloadFailed(URL url, String version) {
        this.stopTimer();
        this.setHeading(ResourceManager.getString("progress.download.failed"), true);
        this.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (DownloadWindow.this.progressDialog != null) {
                    DownloadWindow.this.progressDialog.showProgress(9999);
                }
            }
        });
        this.setVisible(false);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.pendingHeading != null) {
            this.setHeading(this.pendingHeading, true);
        }
        if (!this.timerOn || this.percentComplete <= 0) {
            return;
        }
        ++this.timerCount;
        int timeSoFar = this.timerCount * 1500;
        int delta = this.percentComplete - this.timerLastPercent;
        this.timerLastPercent = this.percentComplete;
        this.timerDownloadPercents[this.timerCount % 10] = delta;
        if (timeSoFar > 8000) {
            int recentPercent = 0;
            int count = Math.min(10, this.timerCount);
            for (int i = 0; i < count; ++i) {
                recentPercent += this.timerDownloadPercents[i];
            }
            if (this.percentComplete == 100) {
                this.setEstimatedTime("");
            } else if (recentPercent != 0 && this.percentComplete > 0) {
                String text;
                int totalSecsLeft = timeSoFar / 1000 * (100 - this.percentComplete) / this.percentComplete;
                int mins = totalSecsLeft / 60;
                int secs = totalSecsLeft - mins * 60;
                if (mins > 0) {
                    String key = mins == 1 ? (secs == 1 ? "progress.time.left.minute.second" : "progress.time.left.minute.seconds") : (secs == 1 ? "progress.time.left.minutes.second" : "progress.time.left.minutes.seconds");
                    text = ResourceManager.getString(key, mins, secs);
                } else {
                    String key = secs == 1 ? "progress.time.left.second" : "progress.time.left.seconds";
                    text = ResourceManager.getString(key, secs);
                }
                this.setEstimatedTime(text);
            }
        }
    }

    private void stopTimer() {
        this.timerOn = false;
        if (this.timerObject != null) {
            this.timerObject.stop();
            this.timerObject = null;
        }
        if (this.pendingHeading != null) {
            this.setHeading(this.pendingHeading, true);
        }
    }

    private synchronized void cancelTimer() {
        if (this.delayTimer != null) {
            this.delayTimer.cancel();
            this.delayTimer = null;
        }
    }

    synchronized void cancelAction() {
        this.setVisible(false);
        if (this.exitOnCancel) {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    try {
                        DownloadWindow.systemExit(-1);
                    }
                    catch (Exception ee) {
                        Trace.println("systemExit: " + ee, TraceLevel.BASIC);
                        Trace.ignoredException(ee);
                    }
                    return null;
                }
            });
        } else {
            this.isCanceled = true;
        }
    }

    private static void systemExit(int status) throws Exception {
        Trace.flush();
        if (Environment.isJavaPlugin()) {
            RuntimeException ee = new RuntimeException("exit(" + status + ")");
            throw ee;
        }
        System.exit(status);
    }

    private boolean isCanceled() {
        return this.isCanceled;
    }

    private synchronized void resetCanceled() {
        this.isCanceled = false;
    }

    private void setAllowVisible(boolean show) {
        this.allowVisible = show;
    }

    private void setVisible(final boolean show) {
        if (!show) {
            this.exitOnCancel = false;
            this.stopTimer();
        }
        this.showOnDelay(false);
        if (show != this.isVisible) {
            this.isVisible = show;
            this.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (show) {
                        DownloadWindow.this.lazyInitializeIfNeeded();
                        if (DownloadWindow.this.progressDialog != null) {
                            DownloadWindow.this.progressDialog.setTitle(ResourceManager.getString(DownloadWindow.this.titleMsg));
                            DownloadWindow.this.setHeading(ResourceManager.getString(DownloadWindow.this.headingMsg), true);
                            UIFactory.showProgressDialog(DownloadWindow.this.progressDialog);
                            DownloadWindow.this.answer = DownloadWindow.this.progressDialog.getUserAnswer();
                            if (DownloadWindow.this.answer == 1) {
                                DownloadWindow.this.cancelAction();
                            }
                        }
                    } else if (DownloadWindow.this.progressDialog != null) {
                        UIFactory.hideProgressDialog(DownloadWindow.this.progressDialog);
                    }
                }
            });
        } else if (!show) {
            this.isVisible = false;
            this.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (DownloadWindow.this.progressDialog != null) {
                        UIFactory.hideProgressDialog(DownloadWindow.this.progressDialog);
                    }
                }
            });
            this.showOnDelay(false);
        }
    }

    boolean isVisible() {
        return this.isVisible;
    }

    private void invokeLater(final Runnable r) {
        if (r == null) {
            return;
        }
        try {
            DeploySysRun.execute(new DeploySysAction(){

                @Override
                public Object execute() {
                    SwingUtilities.invokeLater(r);
                    return null;
                }
            });
        }
        catch (Exception e) {
            Trace.ignoredException(e);
        }
    }
}

