/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.ui;

import java.awt.Font;
import java.io.StringReader;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;

class PromptEditorKit
extends HTMLEditorKit {
    private static final long serialVersionUID = -216473056766022735L;
    private StyleSheet _defaultStyles;
    private final Font base;
    private final Font bold;
    private final boolean increaseFontSize;

    public PromptEditorKit(Font base, Font bold, boolean increaseFontSize) {
        this.base = base;
        this.bold = bold;
        this.increaseFontSize = increaseFontSize;
    }

    @Override
    public StyleSheet getStyleSheet() {
        if (this._defaultStyles == null) {
            this._defaultStyles = new StyleSheet();
            this._defaultStyles.addStyleSheet(super.getStyleSheet());
            this._defaultStyles.addStyleSheet(this.createStyleSheetFromString("body { margin-top: 0; margin-bottom: 0; margin-left: 0; margin-right: 0 }"));
            this._defaultStyles.addStyleSheet(this.createStyleSheetFromString("a { color:blue; text-decoration: none; }"));
            this._defaultStyles.addStyleSheet(this.createStyleSheetFromString("A:hover {color:red;}"));
            this._defaultStyles.addStyleSheet(this.createStyleSheetFromString(this.displayPropertiesToCSS("body", this.base)));
            this._defaultStyles.addStyleSheet(this.createStyleSheetFromString(this.displayPropertiesToCSS("b", this.bold)));
        }
        return this._defaultStyles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StyleSheet createStyleSheetFromString(String s) {
        StyleSheet ss = new StyleSheet();
        try (StringReader r = null;){
            r = new StringReader(s);
            ss.loadRules(r, null);
        }
        return ss;
    }

    private String displayPropertiesToCSS(String tag, Font font) {
        StringBuilder rule = new StringBuilder(tag + " {");
        if (font != null) {
            rule.append(" font-family: ");
            rule.append(font.getFamily());
            rule.append(" ; ");
            rule.append(" font-size: ");
            rule.append(font.getSize());
            rule.append("pt ;");
            if (font.isBold() && this.increaseFontSize) {
                rule.append(" font-weight: 700 ; ");
            }
        }
        rule.append(" }");
        return rule.toString();
    }
}

