/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.ui;

import com.sun.deploy.config.Config;
import com.sun.deploy.config.OSType;
import com.sun.deploy.ui.JavaTrayIconController;
import java.lang.reflect.Constructor;

public abstract class JavaTrayIcon {
    private static JavaTrayIcon soleInstance;
    protected JavaTrayIconController controller;

    public static void install(JavaTrayIconController controller) {
        if (JavaTrayIcon.isSupported()) {
            if (soleInstance != null) {
                throw new IllegalStateException("Already installed");
            }
            JavaTrayIcon icon = null;
            String classname = OSType.isWin() ? "com.sun.deploy.ui.WindowsJavaTrayIcon" : "com.sun.deploy.ui.MacJavaTrayIcon";
            try {
                Class<?> cls = JavaTrayIcon.class.getClassLoader().loadClass(classname);
                if (cls != null) {
                    Constructor<?> c = cls.getDeclaredConstructor(JavaTrayIconController.class);
                    icon = (JavaTrayIcon)c.newInstance(controller);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (icon != null && JavaTrayIcon.isEnabled()) {
                icon.installImpl();
            }
            soleInstance = icon;
        }
    }

    public static void notifyConsoleClosed() {
        if (soleInstance != null) {
            soleInstance.notifyConsoleClosedImpl();
        }
    }

    protected JavaTrayIcon(JavaTrayIconController controller) {
        this.controller = controller;
    }

    protected static boolean isEnabled() {
        return Config.getBooleanProperty("deployment.system.tray.icon");
    }

    protected abstract void installImpl();

    protected abstract void notifyConsoleClosedImpl();

    private static boolean isSupported() {
        return OSType.isWin() || OSType.isMac();
    }
}

