/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.security.ruleset;

import com.sun.deploy.config.Config;
import com.sun.deploy.ref.AppRef;
import com.sun.deploy.ref.CodeRef;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.security.BlockedException;
import com.sun.deploy.security.CertUtils;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.util.URLUtil;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.CodeSigner;
import java.security.cert.Certificate;
import java.util.Arrays;

public class RuleId {
    protected String title;
    protected String location;
    protected String certAlgorithm;
    protected String certHash;
    protected String checksumAlg;
    protected String checksumHash;
    protected String[] jnlpHash;
    private static String[] exceptionSites = null;

    public RuleId(String title, String location, String certAlgorithm, String certHash, String checksumAlg, String checksumHash) {
        this(title, location, certAlgorithm, certHash, checksumAlg, checksumHash, null);
    }

    public RuleId(String title, String location, String certAlgorithm, String certHash, String checksumAlg, String checksumHash, String[] jnlpHash) {
        this.title = title;
        this.location = location;
        this.certAlgorithm = certAlgorithm;
        this.certHash = certHash;
        this.checksumAlg = checksumAlg;
        this.checksumHash = checksumHash;
        if (jnlpHash != null) {
            this.jnlpHash = Arrays.copyOf(jnlpHash, jnlpHash.length);
        }
    }

    public String getTitle() {
        return this.title;
    }

    public String getLocation() {
        return this.location;
    }

    public String getCertAlgorithm() {
        return this.certAlgorithm;
    }

    public String getCertHash() {
        return this.certHash;
    }

    public String getChecksumAlg() {
        return this.checksumAlg;
    }

    public String getChecksumHash() {
        return this.checksumHash;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean contains(AppRef appRef, CodeRef codeRef) {
        if (appRef.getType() == AppRef.Type.DOCBASE) {
            block30: {
                try {
                    if (this.title != null || this.certHash != null || this.checksumHash != null) break block30;
                    URL appLoc = appRef.getLocation();
                    if (this.location == null || appLoc != null && RuleId.compareStringToURL(this.location, appLoc, true, true)) {
                        Trace.println("Matching Rule id for docbase only: " + this, TraceLevel.RULESET);
                        return true;
                    }
                    if (appLoc == null && this.jnlpHash != null) {
                        for (String hash : this.jnlpHash) {
                            if (hash != null && hash.equals(appRef.getJnlpHash())) {
                                Trace.println("Rule location: " + this.location + " matches UNKNOWN jnlp location due to matching jnlp-checksum", TraceLevel.RULESET);
                                return true;
                            }
                            Trace.println("hash: " + hash + " does not match app jnlp hash: " + appRef.getJnlpHash(), TraceLevel.RULESET);
                        }
                    }
                }
                catch (Exception e) {
                    Trace.ignored(e);
                }
            }
            Trace.println("Rule location: " + this.location + " doesn't match docbase location: " + appRef.getLocation(), TraceLevel.RULESET);
            return false;
        }
        if (this.title != null && !this.title.equals(appRef.getTitle())) {
            Trace.println("Rule title: " + this.title + " doesn't match artifactId: " + appRef.getTitle(), TraceLevel.RULESET);
            return false;
        }
        Trace.println("Rule title: " + this.title + " matches artifactId: " + appRef.getTitle(), TraceLevel.RULESET);
        if (this.location != null) {
            try {
                if (appRef.getLocation() != null) {
                    boolean match = RuleId.compareStringToURL(this.location, appRef.getLocation(), true, true);
                    if (!match) {
                        Trace.println("Rule location: " + this.location + " does not match artifact location: " + appRef.getLocation(), TraceLevel.RULESET);
                        return false;
                    }
                } else {
                    boolean matchJnlpHash = false;
                    if (this.jnlpHash == null) {
                        Trace.println("Rule location: " + this.location + " does not match UNKNOWN artifact location", TraceLevel.RULESET);
                        return false;
                    }
                    for (String hash : this.jnlpHash) {
                        if (hash == null || !hash.equals(appRef.getJnlpHash())) continue;
                        matchJnlpHash = true;
                        break;
                    }
                    if (!matchJnlpHash) {
                        Trace.println("Rule location: " + this.location + " does not match UNKNOWN artifact location with jnlp checksum: " + appRef.getJnlpHash(), TraceLevel.RULESET);
                        return false;
                    }
                    Trace.println("Rule location: " + this.location + " matches UNKNOWN jnlp location due to matching jnlp-checksum", TraceLevel.RULESET);
                }
            }
            catch (Exception e) {
                Trace.ignored(e);
                return false;
            }
            Trace.println("Rule location: " + this.location + " matches artifactId: " + appRef.getLocation(), TraceLevel.RULESET);
        }
        if (this.certHash != null) {
            try {
                Certificate[] certs = null;
                boolean hashMatch = false;
                String artifactHash = null;
                CodeSigner[] signers = codeRef.getCodeSigners();
                for (int i = 0; signers != null && i < signers.length; ++i) {
                    certs = codeRef.getCerts(signers[i]);
                    if (certs == null || !this.certHash.equals(artifactHash = CertUtils.getMainCertHash(certs, this.certAlgorithm))) continue;
                    hashMatch = true;
                    break;
                }
                if (certs == null) {
                    Trace.println("Rule hash not matching unsigned artifact", TraceLevel.RULESET);
                    return false;
                }
                if (!hashMatch) {
                    Trace.println("Rule hash:\n         " + this.certHash + "\nnot matching artifact certificate hash:\n         " + artifactHash, TraceLevel.RULESET);
                    return false;
                }
                Trace.println("Rule hash matches certificate hash", TraceLevel.RULESET);
            }
            catch (IOException ioe) {
                Trace.println("IOException: " + ioe + "while finding hash for codeRef: " + codeRef, TraceLevel.RULESET);
                Trace.ignored(ioe);
                return false;
            }
        }
        if (this.checksumHash != null) {
            try {
                CodeSigner[] signers = codeRef.getCodeSigners();
                if (signers != null && signers.length > 0) {
                    Trace.println("checksum rule cannot match signed content", TraceLevel.RULESET);
                    return false;
                }
                String artifactChecksum = codeRef.getChecksum(this.checksumAlg);
                if (!this.checksumHash.equals(artifactChecksum)) {
                    if (artifactChecksum == null) {
                        Trace.println("Rule checksum not equal to codebase artifact", TraceLevel.RULESET);
                        return false;
                    }
                    Trace.println("Rule checksum not equal to artifact checksum: " + artifactChecksum, TraceLevel.RULESET);
                    return false;
                }
            }
            catch (NumberFormatException nfe) {
                Trace.println("invalid checksum in rule: " + this.checksumHash);
                return false;
            }
            catch (IOException ioe) {
                Trace.println("IOException: " + ioe + " while finding checksum for: " + codeRef.getJarLocation(), TraceLevel.RULESET);
                Trace.ignored(ioe);
                return false;
            }
        }
        Trace.println("Matching Rule ID: " + this, TraceLevel.RULESET);
        return true;
    }

    public String toString() {
        String rulesetString = "\n        title: " + this.title + "\n        location: " + this.location;
        if (this.certHash != null) {
            rulesetString = rulesetString + "\n        certificate algorithm: " + this.certAlgorithm + "\n        certificate hash: " + this.certHash;
        }
        if (this.checksumHash != null) {
            rulesetString = rulesetString + "\n        checksum algorithm: " + this.checksumAlg + "\n        checksum hash: " + this.checksumHash;
        }
        return rulesetString;
    }

    public static boolean compareStringToURL(String compareString, URL url, boolean allowWild, boolean matchBelow) {
        int port;
        String actualHost = url.getHost();
        String actualProtocol = url.getProtocol();
        int defaultPort = url.getDefaultPort();
        int actualPort = url.getPort();
        String actualPath = url.getPath();
        boolean protocolMatch = false;
        boolean hostMatch = false;
        boolean portMatch = false;
        boolean pathMatch = false;
        boolean isFileProtocol = false;
        String hostname = null;
        String protocol = null;
        String path = null;
        URL u = null;
        try {
            u = new URL(compareString);
            protocol = u.getProtocol();
            hostname = u.getHost();
            port = u.getPort();
            path = u.getPath();
        }
        catch (MalformedURLException mue) {
            try {
                u = new URL("http://" + compareString);
                protocol = null;
                hostname = u.getHost();
                port = u.getPort();
                path = u.getPath();
            }
            catch (MalformedURLException me) {
                Trace.println("invalid location: " + compareString, TraceLevel.RULESET);
                return false;
            }
        }
        Trace.println("RuleId compare: (" + protocol + ", " + hostname + ", " + port + ", " + path + ") to url: " + url, TraceLevel.RULESET);
        if (allowWild) {
            if (port == -1 || port == actualPort || port == defaultPort && actualPort == -1) {
                portMatch = true;
            }
        } else if (port == actualPort || port == -1 && actualPort == defaultPort || port == defaultPort && actualPort == -1) {
            portMatch = true;
        }
        if (protocol == null || protocol.equals(actualProtocol)) {
            protocolMatch = true;
            if ("file".equals(protocol)) {
                isFileProtocol = true;
            }
        }
        if (hostname.equals("*")) {
            hostMatch = false;
        } else if (allowWild && hostname.startsWith("*.")) {
            String subdomain = hostname.substring(2);
            if (actualHost.toLowerCase().endsWith(subdomain.toLowerCase())) {
                hostMatch = true;
            }
        } else if (hostname.equalsIgnoreCase(actualHost)) {
            hostMatch = true;
        }
        if (matchBelow) {
            pathMatch = RuleId.pathIncludes(path, actualPath, actualProtocol, actualHost, isFileProtocol);
        } else if (path == null || path.length() == 0 || path.equals(actualPath)) {
            pathMatch = true;
        } else if (isFileProtocol) {
            try {
                String actTmp = new File(actualPath).getCanonicalPath();
                String pathTmp = new File(path).getCanonicalPath();
                pathMatch = pathTmp.equals(actTmp);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return protocolMatch && hostMatch && portMatch && pathMatch;
    }

    private static boolean pathIncludes(String rulePath, String artifactPath, String artifactProtocol, String artifactHost, boolean isFileProtocol) {
        boolean pathMatch = false;
        int start = artifactPath.indexOf(37);
        if (start >= 0 && (artifactPath.indexOf("%2E", start) >= 0 || artifactPath.indexOf("%2e", start) >= 0 || artifactPath.indexOf("%2F", start) >= 0 || artifactPath.indexOf("%2f", start) >= 0)) {
            throw new SecurityException("Unsupported encoded character in path");
        }
        String decodedPathString = URLUtil.decodePath(artifactPath);
        for (int i = 0; i < decodedPathString.length(); ++i) {
            char c = decodedPathString.charAt(i);
            if (c > '\u001f' && c != '\u007f' && c != '?' && c != '%' && c != '\\' && c != '#') continue;
            throw new SecurityException("Unsupported character in decoded path");
        }
        try {
            artifactPath = new URI(artifactProtocol, artifactHost, decodedPathString, null).normalize().getPath();
        }
        catch (URISyntaxException use) {
            throw new SecurityException("unexpected excpetion", use);
        }
        if (rulePath == null || rulePath.length() == 0 || artifactPath.equals(rulePath)) {
            pathMatch = true;
        } else {
            Object tmpRulePath;
            Object object = tmpRulePath = rulePath.endsWith("/") ? rulePath : rulePath + "/";
            if (artifactPath.startsWith((String)tmpRulePath)) {
                pathMatch = true;
            } else if (isFileProtocol) {
                try {
                    String artTmp = new File(artifactPath).getCanonicalPath();
                    String ruleTmp = new File((String)tmpRulePath).getCanonicalPath();
                    if (artTmp.startsWith(ruleTmp)) {
                        pathMatch = true;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return pathMatch;
    }

    protected static boolean isException(AppRef appRef, CodeRef codeRef) {
        try {
            URL jarURL;
            URL htmlURL = appRef.getHTMLLocation() != null ? appRef.getHTMLLocation() : null;
            URL jnlpURL = appRef.getJNLPLocation() != null ? appRef.getJNLPLocation() : null;
            URL uRL = jarURL = codeRef != null ? codeRef.getJarLocation() : null;
            if (exceptionSites == null) {
                exceptionSites = Config.getExceptionSites();
            }
            if (htmlURL != null && RuleId.onExceptionList(htmlURL)) {
                if (jnlpURL != null && !URLUtil.sameBase(htmlURL, jnlpURL) && !RuleId.onExceptionList(jnlpURL)) {
                    String msg = ResourceManager.getString("deployment.blocked.exception.list.domains", "html", String.valueOf(appRef.getHTMLLocation()), "jnlp", String.valueOf(appRef.getJNLPLocation()));
                    Trace.println(msg, TraceLevel.BASIC);
                    throw new BlockedException(msg, new Exception());
                }
                if (jarURL != null && !URLUtil.sameBase(htmlURL, jarURL) && !RuleId.onExceptionList(jarURL)) {
                    String msg = ResourceManager.getString("deployment.blocked.exception.list.domains", "html", String.valueOf(appRef.getHTMLLocation()), "jar", String.valueOf(codeRef.getJarLocation()));
                    Trace.println(msg, TraceLevel.BASIC);
                    throw new BlockedException(msg, new Exception());
                }
                return true;
            }
            if (htmlURL == null && jnlpURL != null && RuleId.onExceptionList(jnlpURL)) {
                if (jarURL != null && !URLUtil.sameBase(jnlpURL, jarURL) && !RuleId.onExceptionList(jarURL)) {
                    String msg = ResourceManager.getString("deployment.blocked.exception.list.domains", "jnlp", String.valueOf(appRef.getJNLPLocation()), "jar", String.valueOf(codeRef.getJarLocation()));
                    Trace.println(msg, TraceLevel.BASIC);
                    throw new BlockedException(msg, new Exception());
                }
                return true;
            }
            if (htmlURL == null && jnlpURL == null) {
                if (appRef.getAnchorURL() != null && RuleId.onExceptionList(appRef.getAnchorURL())) {
                    if (jarURL != null && !URLUtil.sameBase(appRef.getAnchorURL(), jarURL) && !RuleId.onExceptionList(jarURL)) {
                        String msg = ResourceManager.getString("deployment.blocked.exception.list.domains", "jar", String.valueOf(appRef.getAnchorURL()), "jar", String.valueOf(codeRef.getJarLocation()));
                        Trace.println(msg, TraceLevel.BASIC);
                        throw new BlockedException(msg, new Exception());
                    }
                    return true;
                }
                return false;
            }
            return false;
        }
        catch (IOException ioe) {
            Trace.println("IOException processing exception list: " + ioe, TraceLevel.RULESET);
            Trace.ignored(ioe);
            return false;
        }
    }

    private static boolean onExceptionList(URL url) throws IOException {
        for (int i = 0; i < exceptionSites.length; ++i) {
            boolean matchBelow;
            if (exceptionSites[i] == null || exceptionSites[i].length() <= 0 || !RuleId.compareStringToURL(exceptionSites[i], url, false, matchBelow = exceptionSites[i].endsWith("/"))) continue;
            return true;
        }
        return false;
    }
}

