/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.security;

import com.sun.applet2.preloader.CancelException;
import com.sun.applet2.preloader.Preloader;
import com.sun.applet2.preloader.event.UserDeclinedEvent;
import com.sun.deploy.appcontext.AppContext;
import com.sun.deploy.cache.Cache;
import com.sun.deploy.config.Config;
import com.sun.deploy.config.Platform;
import com.sun.deploy.model.LocalApplicationProperties;
import com.sun.deploy.model.Resource;
import com.sun.deploy.model.ResourceProvider;
import com.sun.deploy.net.JARSigningException;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.security.BlacklistedCerts;
import com.sun.deploy.security.BlockedDialog;
import com.sun.deploy.security.CertStore;
import com.sun.deploy.security.CertUtils;
import com.sun.deploy.security.CertValidator;
import com.sun.deploy.security.DecisionTime;
import com.sun.deploy.security.DeniedCertStore;
import com.sun.deploy.security.DeployCertPathChecker;
import com.sun.deploy.security.DeployManifestChecker;
import com.sun.deploy.security.DeploySigningCertStore;
import com.sun.deploy.security.JarVerifier;
import com.sun.deploy.security.LazyRootStore;
import com.sun.deploy.security.RevocationCheckHelper;
import com.sun.deploy.security.RevocationChecker;
import com.sun.deploy.security.RootCertStore;
import com.sun.deploy.security.SandboxSecurity;
import com.sun.deploy.security.SessionCertStore;
import com.sun.deploy.security.TrustRecorder;
import com.sun.deploy.security.UserDeclinedException;
import com.sun.deploy.security.ValidationState;
import com.sun.deploy.security.X509CertificateWrapper;
import com.sun.deploy.security.X509Util;
import com.sun.deploy.security.ruleset.BlockRule;
import com.sun.deploy.security.ruleset.DeploymentRuleSet;
import com.sun.deploy.services.Service;
import com.sun.deploy.services.ServiceManager;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.ui.AppInfo;
import com.sun.deploy.uitoolkit.ToolkitStore;
import com.sun.deploy.util.DeployLock;
import com.sun.deploy.util.JarUtil;
import com.sun.deploy.util.SecurityBaseline;
import com.sun.deploy.util.URLUtil;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.security.CodeSigner;
import java.security.CodeSource;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Timestamp;
import java.security.cert.CRLException;
import java.security.cert.CertPath;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXParameters;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.jar.JarFile;
import sun.security.validator.PKIXValidator;
import sun.security.validator.Validator;
import sun.security.validator.ValidatorException;

public class TrustDecider {
    public static final int TrustOption_GrantThisSession = 0;
    public static final int TrustOption_Deny = 1;
    public static final int TrustOption_GrantAlways = 2;
    static final String ROOT_CA_NOT_VALID = "self-signed";
    private static CertStore rootStore = null;
    private static CertStore permanentStore = null;
    private static CertStore sandboxStore = null;
    private static CertStore sessionStore = null;
    private static CertStore sessionRevocationStore = null;
    private static CertStore sessionSandboxStore = null;
    private static CertStore sessionDRSStore = null;
    private static CertStore deniedStore = null;
    private static CertStore browserRootStore = null;
    private static CertStore browserTrustedStore = null;
    private static CertStore browserUntrustedStore = null;
    private static LazyRootStore lazyRootStore = null;
    private static X509CRL crl509 = null;
    private static boolean ocspValidConfig = false;
    private static String ocspSigner = null;
    private static String ocspURL = null;
    private static String revType = null;
    private static boolean crlCheck = false;
    private static boolean ocspCheck = false;
    private static DeployLock deployLock = null;
    private static String timeout = null;
    private static String clockSkew = null;
    public static final long PERMISSION_DENIED = 0L;
    public static final long PERMISSION_GRANTED_FOR_SESSION = 1L;
    public static final long PERMISSION_UNKNOWN = 2L;
    private static boolean storesLoaded;
    private static boolean reloadDeniedStore;
    private static final String MAIN_JAR_FOUND = "true";

    protected static void grabDeployLock() throws InterruptedException {
        deployLock.lock();
    }

    protected static void releaseDeployLock() {
        try {
            deployLock.unlock();
        }
        catch (IllegalMonitorStateException illegalMonitorStateException) {
            // empty catch block
        }
    }

    public static void resetDenyStore() {
        Trace.msgSecurityPrintln("trustdecider.check.reset.denystore");
        try {
            TrustDecider.grabDeployLock();
            deniedStore = new DeniedCertStore();
            reloadDeniedStore = true;
        }
        catch (InterruptedException ie) {
            throw new RuntimeException(ie);
        }
        finally {
            TrustDecider.releaseDeployLock();
        }
    }

    public static void reset() {
        try {
            TrustDecider.grabDeployLock();
            storesLoaded = false;
            rootStore = RootCertStore.getCertStore();
            permanentStore = DeploySigningCertStore.getCertStore();
            sandboxStore = DeploySigningCertStore.getSandboxCertStore();
            sessionStore = new SessionCertStore("TrustDecider");
            sessionRevocationStore = new SessionCertStore("Revocation");
            sessionSandboxStore = new SessionCertStore("SandboxSecurity");
            sessionDRSStore = new SessionCertStore("DeploymentRuleSet");
            deniedStore = new DeniedCertStore();
            if (Config.getBooleanProperty("deployment.security.browser.keystore.use")) {
                Service service = ServiceManager.getService();
                browserRootStore = service.getBrowserSigningRootCertStore();
                browserTrustedStore = service.getBrowserTrustedCertStore();
                browserUntrustedStore = service.getBrowserUntrustedCertStore();
            }
            try {
                lazyRootStore = new LazyRootStore(browserRootStore, rootStore);
            }
            catch (Exception ex) {
                Trace.ignored(ex);
            }
            revType = Config.getStringProperty("deployment.security.revocation.check");
            if (revType.equals("NO_CHECK")) {
                crlCheck = false;
                ocspCheck = false;
                return;
            }
            ocspCheck = Config.getBooleanProperty("deployment.security.validation.ocsp");
            crlCheck = Config.getBooleanProperty("deployment.security.validation.crl");
            if (!ocspCheck && !crlCheck) {
                crlCheck = true;
                ocspCheck = true;
            }
            timeout = Config.getStringProperty("deployment.security.validation.timeout");
            clockSkew = Config.getStringProperty("deployment.security.validation.clockskew");
            if (crlCheck) {
                crl509 = RevocationCheckHelper.retrieveCRL(Config.getStringProperty("deployment.security.validation.crl.url"));
            }
            if (ocspCheck) {
                ocspSigner = Config.getStringProperty("deployment.security.validation.ocsp.signer");
                ocspURL = Config.getStringProperty("deployment.security.validation.ocsp.url");
                if (ocspSigner != null && ocspSigner.length() > 0 && ocspURL != null && ocspURL.length() > 0) {
                    ocspValidConfig = true;
                }
            }
        }
        catch (InterruptedException ie) {
            throw new RuntimeException(ie);
        }
        finally {
            TrustDecider.releaseDeployLock();
        }
    }

    static void notifyOnUserDeclined(Preloader p, String url) {
        if (p == null) {
            p = (Preloader)ToolkitStore.get().getAppContext().get("preloader_key");
        }
        try {
            if (p != null) {
                p.handleEvent(new UserDeclinedEvent(url));
            }
        }
        catch (CancelException cancelException) {
            // empty catch block
        }
    }

    protected static List<List<X509Certificate>> breakDownMultiSignerChains(Certificate[] certs) {
        int start = 0;
        int end = 0;
        int chainNum = 0;
        ArrayList<List<X509Certificate>> chains = new ArrayList<List<X509Certificate>>();
        while (end < certs.length) {
            ArrayList<X509Certificate> certChain = new ArrayList<X509Certificate>();
            int i = start;
            while (i + 1 < certs.length && certs[i] instanceof X509Certificate && certs[i + 1] instanceof X509Certificate && CertUtils.isIssuerOf((X509Certificate)certs[i], (X509Certificate)certs[i + 1])) {
                ++i;
            }
            end = i + 1;
            for (int j = start; j < end; ++j) {
                certChain.add((X509Certificate)certs[j]);
            }
            chains.add(certChain);
            start = end;
            ++chainNum;
        }
        return chains;
    }

    private static boolean haveValidatorSupport() {
        try {
            Class<?> validatorClass = Class.forName("sun.security.validator.Validator", true, ClassLoader.getSystemClassLoader());
            if (validatorClass != null) {
                return true;
            }
        }
        catch (ClassNotFoundException cnfe) {
            Trace.msgSecurityPrintln("trustdecider.check.validate.notfound");
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void validateChainForWarmup(X509Certificate[] certArr, CodeSource cs, int chainNum, AppInfo ai, DeploymentRuleSet drs) throws KeyStoreException, IOException, CertificateException, NoSuchAlgorithmException, CRLException, InvalidAlgorithmParameterException {
        try {
            TrustDecider.grabDeployLock();
            TrustDecider.ensureBasicStoresLoaded();
            long res = TrustDecider.validateChain(certArr, cs, chainNum, ai, drs, null, true);
            Trace.println("Warmup validation completed (res=" + res + ")", TraceLevel.SECURITY);
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            TrustDecider.releaseDeployLock();
        }
    }

    private static long validateChain(X509Certificate[] certArr, CodeSource cs, int chainNum, AppInfo ai, DeploymentRuleSet drs, Preloader preloader, boolean forWarmup) throws KeyStoreException, IOException, CertificateException, NoSuchAlgorithmException, CRLException, InvalidAlgorithmParameterException {
        boolean bestEffort = drs.isRevocationCheckBestEffort();
        boolean runRule = drs.isRuleRun();
        ValidationState state = TrustDecider.getValidationState(certArr, cs, chainNum, ValidationState.TYPE.ALL_PERMISSIONS, bestEffort, runRule, ai, drs, forWarmup);
        LocalApplicationProperties lap = Cache.getLocalApplicationProperties(ai.getLapURL());
        if (lap != null) {
            lap.storeMainPublisherAndTitle(state.getPublisher(), ai.getDisplayTitle());
        }
        if (runRule) {
            state.trustDecision = 1L;
            sessionDRSStore.add(certArr[0], TrustDecider.getLocString(cs.getLocation(), ai), state.timeValid);
        }
        String blockedKey = null;
        SecurityException blockedException = null;
        if (state.trustDecision == 2L) {
            if (!state.rootCAValid) {
                if (!drs.isAskGrantSelfSignedSet()) {
                    blockedKey = "deployment.grant.notinca.never.text";
                } else if (SecurityBaseline.isExpired() && drs.isSSVModeNever()) {
                    blockedKey = "deployment.ssv2.mode.never.selfsigned";
                }
            }
            if (blockedKey == null && !state.timeValid && drs.isExpiredBlocked()) {
                blockedKey = "deployment.block.expired.text";
            }
            if (blockedKey == null && !drs.isAskGrantShowSet()) {
                blockedKey = "deployment.grant.signed.never.text";
            }
        }
        if (blockedKey == null && state.trustDecision != 0L) {
            try {
                TrustDecider.checkMainJarManifest(drs, cs.getLocation(), ai, true);
            }
            catch (SecurityException e) {
                blockedKey = "deployment.blocked.permissions";
                blockedException = e;
            }
        }
        if (blockedKey != null) {
            String loc = TrustDecider.getLocString(cs.getLocation(), ai);
            deniedStore.add(certArr[0], loc, state.timeValid);
            deniedStore.save();
            BlockedDialog.show(ai, null, blockedKey, blockedException, cs, drs);
        }
        if (state.trustDecision == 2L) {
            if (DecisionTime.withinTime(cs.getLocation(), ai, certArr[0], "ssv.decision.all-perms.time")) {
                state.trustDecision = 1L;
            } else {
                state.trustDecision = TrustDecider.askUser(certArr, cs, state, ai, drs, preloader);
                if (state.trustDecision == 1L && !Platform.get().isNativeSandbox()) {
                    DecisionTime.setTime(cs.getLocation(), ai, certArr[0], "ssv.decision.all-perms.time");
                }
            }
        }
        return state.trustDecision;
    }

    static ValidationState getValidationState(X509Certificate[] certArr, CodeSource cs, int chainNum, ValidationState.TYPE validationType, boolean bestEffort, boolean runRule, AppInfo ai, DeploymentRuleSet drs, boolean forWarmup) throws KeyStoreException, IOException, CertificateException, NoSuchAlgorithmException, CRLException, InvalidAlgorithmParameterException {
        int certArrLen;
        X509Certificate last;
        LazyRootStore.TrustedRootResult trustRoots;
        List<X509Certificate> matchedCAList;
        boolean crlCheckLocal = crlCheck;
        boolean ocspCheckLocal = ocspCheck;
        String loc = TrustDecider.getLocString(cs.getLocation(), ai);
        boolean[] expired = new boolean[certArr.length];
        ValidationState state = new ValidationState(validationType);
        for (int i = 0; i < certArr.length; ++i) {
            long ntime = certArr[i].getNotAfter().getTime();
            if (ntime < state.expirationDate) {
                state.expirationDate = ntime;
            }
            try {
                expired[i] = true;
                certArr[i].checkValidity();
                expired[i] = false;
                continue;
            }
            catch (CertificateExpiredException e1) {
                if (state.certExpiredException != null) continue;
                state.certExpiredException = e1;
                state.certValidity = -1;
                state.certValidityNoTS = -1;
                state.timeValid = false;
                continue;
            }
            catch (CertificateNotYetValidException e2) {
                if (state.certNotYetValidException != null) continue;
                state.certNotYetValidException = e2;
                state.certValidity = 1;
                state.certValidityNoTS = 1;
                state.timeValid = false;
            }
        }
        state.timestamp = TrustDecider.getTimeStamp(cs, chainNum, certArr, lazyRootStore, drs, ai);
        if (!state.timeValid && state.timestamp != null) {
            state.timeValid = true;
            state.certValidity = 0;
        }
        List<X509Certificate> list = matchedCAList = (trustRoots = lazyRootStore.getTrustAnchors(last = certArr[(certArrLen = certArr.length) - 1])) == null ? null : trustRoots.getMatchedCAList();
        if (matchedCAList == null) {
            state.rootCAValid = false;
            TrustDecider.setSelfSignedUsage();
            matchedCAList = new ArrayList<X509Certificate>();
            matchedCAList.add(last);
        }
        PKIXBuilderParameters params = null;
        X509Certificate[] newChain = null;
        try {
            Validator v = Validator.getInstance("PKIX", "plugin code signing", matchedCAList);
            PKIXValidator pkixv = (PKIXValidator)v;
            params = pkixv.getParameters();
            params.addCertPathChecker(new DeployCertPathChecker(pkixv));
            params.setDate(new Date());
            newChain = new X509Certificate[certArrLen];
            for (int k = 0; k < certArrLen; ++k) {
                newChain[k] = new X509CertificateWrapper(certArr[k]);
            }
            newChain = v.validate(newChain, null, state.timestamp);
        }
        catch (CertificateException ce) {
            if (ce instanceof ValidatorException) {
                ValidatorException ve = (ValidatorException)ce;
                if (ValidatorException.T_NO_TRUST_ANCHOR.equals(ve.getErrorType())) {
                    state.rootCAValid = false;
                    TrustDecider.setSelfSignedUsage();
                }
                throw ve;
            }
            throw ce;
        }
        if (state.rootCAValid) {
            state.setPublisher(CertUtils.extractSubjectAliasName(certArr[0]));
        }
        if (state.type != ValidationState.TYPE.SPECIAL && !forWarmup) {
            TrustDecider.ensureAllJarEntriesSigned(cs.getLocation(), drs);
        }
        if (sessionStore.contains(certArr[0], loc, state.timeValid) || state.type == ValidationState.TYPE.SANDBOX_PERMISSIONS && sessionSandboxStore.contains(certArr[0], loc, state.timeValid) || runRule && sessionDRSStore.contains(certArr[0], loc, state.timeValid)) {
            state.trustDecision = 1L;
            return state;
        }
        ArrayList<X509Certificate> certs = new ArrayList<X509Certificate>(Arrays.asList(certArr));
        if (matchedCAList != null && state.rootCAValid) {
            certs.addAll(matchedCAList);
        }
        for (X509Certificate cert : certs) {
            BlacklistedCerts.check(cert);
            if (browserUntrustedStore == null || !browserUntrustedStore.contains(cert)) continue;
            String msg = ResourceManager.getString("security.dialog.unverified.signed.publisher");
            Trace.println(msg, TraceLevel.SECURITY);
            throw new CertificateException(msg);
        }
        if (!sessionRevocationStore.contains(certArr[0], loc, false)) {
            if (sessionRevocationStore.contains(certArr[0], loc, true)) {
                state.revStatusUnknown = true;
            } else if (!TrustDecider.willBlock(state, drs)) {
                TrustDecider.checkRevocationStatus(ocspCheckLocal, crlCheckLocal, newChain, params, state, bestEffort, expired);
                sessionRevocationStore.add(certArr[0], loc, state.revStatusUnknown);
                sessionRevocationStore.save();
            }
        }
        if (deniedStore.contains(certArr[0], loc, state.timeValid)) {
            state.trustDecision = 0L;
            return state;
        }
        if (!state.rootCAValid) {
            state.trustDecision = 2L;
            return state;
        }
        if (permanentStore.contains(certArr[0], loc, state.timeValid)) {
            state.trustDecision = state.expirationDate;
            sessionStore.add(certArr[0], loc, state.timeValid);
            sessionStore.save();
            return state;
        }
        if (state.type == ValidationState.TYPE.SANDBOX_PERMISSIONS && sandboxStore.contains(certArr[0], loc, state.timeValid)) {
            state.trustDecision = state.expirationDate;
            sessionSandboxStore.add(certArr[0], loc, state.timeValid);
            sessionSandboxStore.save();
            return state;
        }
        if (browserTrustedStore != null && browserTrustedStore.contains(certArr[0])) {
            state.trustDecision = 1L;
            return state;
        }
        state.trustDecision = 2L;
        return state;
    }

    public static ValidationState getJarValidationState(CodeSource cs, AppInfo ai, DeploymentRuleSet drs) {
        return TrustDecider.getJarValidationState(cs, ai, ValidationState.TYPE.SPECIAL, drs);
    }

    public static ValidationState getJarValidationState(CodeSource cs, AppInfo ai, ValidationState.TYPE type, DeploymentRuleSet drs) {
        X509Certificate[] certArr = null;
        Certificate[] certs = cs.getCertificates();
        if (certs != null) {
            try {
                TrustDecider.ensureBasicStoresLoaded();
                List<List<X509Certificate>> chains = TrustDecider.breakDownMultiSignerChains(certs);
                if (TrustDecider.haveValidatorSupport()) {
                    Iterator<List<X509Certificate>> iterChains = chains.iterator();
                    if (iterChains.hasNext()) {
                        List<X509Certificate> certList = iterChains.next();
                        certArr = certList.toArray(new X509Certificate[certList.size()]);
                        try {
                            return TrustDecider.getValidationState(certArr, cs, 0, type, true, false, ai, drs, false);
                        }
                        catch (Exception e) {
                            Trace.ignored(e);
                        }
                    } else {
                        Trace.println("Canot validate certificate - unsigned", TraceLevel.SECURITY);
                    }
                } else {
                    Trace.msgSecurityPrintln("trustdecider.check.validate.legacy.algorithm");
                    rootStore.load();
                    if (browserRootStore != null) {
                        browserRootStore.load();
                    }
                    if (CertValidator.validate(cs, ai, certs, chains.size(), rootStore, browserRootStore, browserTrustedStore, sessionStore, permanentStore, deniedStore, drs)) {
                        ValidationState state = new ValidationState(type);
                        state.rootCAValid = true;
                        return state;
                    }
                }
            }
            catch (Exception e) {
                Trace.ignored(e);
            }
        }
        ValidationState state = new ValidationState(type);
        state.trustDecision = 0L;
        return state;
    }

    private static void ensureAllJarEntriesSigned(URL url, DeploymentRuleSet drs) throws CertificateException {
        String version = (String)ToolkitStore.get().getAppContext().get("deploy-" + url);
        Resource re = null;
        int reason = 2;
        try {
            re = ResourceProvider.get().getCachedResource(url, version);
            if (re == null) {
                re = ResourceProvider.get().getResource(url, version);
            }
        }
        catch (IOException ioe) {
            Trace.ignored(ioe);
        }
        if (re != null) {
            JarFile jf = re.getJarFile();
            if (jf != null) {
                try {
                    boolean skipMeta;
                    if (JarUtil.isBlobSigned(jf)) {
                        return;
                    }
                    boolean bl = skipMeta = drs != null && drs.skipMetaInfDirectory();
                    if (JarUtil.allJarEntriesSigned(jf, skipMeta)) {
                        return;
                    }
                    reason = 3;
                }
                catch (IOException ioe) {
                    throw new CertificateException(ioe.getMessage(), ioe);
                }
            } else {
                Trace.println("getJarFile() returned null from resource: " + re, TraceLevel.SECURITY);
            }
        } else {
            Trace.println("Unable to retrieve resource from: " + url + ", " + version, TraceLevel.SECURITY);
        }
        JARSigningException jse = new JARSigningException(url, version, reason);
        Trace.ignored(jse);
        throw new CertificateException(jse.getRealMessage(), jse);
    }

    public static boolean willBlock(ValidationState state, DeploymentRuleSet drs) {
        if (!state.timeValid && (drs == null || drs.isExpiredBlocked())) {
            return true;
        }
        if (!state.rootCAValid && (drs == null || drs.isSSVModeNever() && SecurityBaseline.isExpired())) {
            return true;
        }
        switch (state.type) {
            case SANDBOX_PERMISSIONS: {
                return drs == null || (state.rootCAValid ? drs.isCaSignedNever() : drs.isSelfSignedNever());
            }
            case ALL_PERMISSIONS: {
                return drs == null || (state.rootCAValid ? !drs.isAskGrantShowSet() : !drs.isAskGrantSelfSignedSet());
            }
            case SPECIAL: {
                return !state.rootCAValid;
            }
        }
        return false;
    }

    private static void checkRevocationStatus(boolean checkOCSP, boolean checkCRL, X509Certificate[] chain, PKIXParameters params, ValidationState state, boolean bestEffort, boolean[] expired) throws CertificateException {
        if (checkOCSP) {
            Trace.msgSecurityPrintln("trustdecider.check.validation.ocsp.on");
        } else {
            Trace.msgSecurityPrintln("trustdecider.check.validation.ocsp.off");
        }
        if (checkCRL) {
            Trace.msgSecurityPrintln("trustdecider.check.validation.crl.on");
        } else {
            Trace.msgSecurityPrintln("trustdecider.check.validation.crl.off");
        }
        if (!checkOCSP && !checkCRL) {
            Trace.msgSecurityPrintln("Revocation check disabled");
            return;
        }
        if (chain.length < 2) {
            return;
        }
        X509Certificate ocspCert = null;
        if (checkOCSP && ocspValidConfig) {
            try {
                lazyRootStore.containSubject(ocspSigner);
                ocspCert = lazyRootStore.getOCSPCert();
            }
            catch (Exception e) {
                Trace.ignored(e);
            }
        }
        boolean onlyPublisher = revType.equals("PUBLISHER_ONLY");
        X509Certificate anchor = chain[chain.length - 1];
        RevocationChecker rc = new RevocationChecker(anchor, params, checkOCSP, checkCRL, ocspURL, ocspCert, onlyPublisher, crl509, state.timestamp != null ? state.timestamp.getTimestamp() : null, timeout, clockSkew, "plugin code signing");
        for (int i = chain.length - 2; i >= 0; --i) {
            X509Certificate cert = chain[i];
            try {
                rc.check(cert, expired[i]);
                continue;
            }
            catch (CertificateException ce) {
                if (ce instanceof RevocationChecker.StatusUnknownException && bestEffort) {
                    Trace.msgSecurityPrintln("Revocation Status Unknown");
                    Trace.ignored(ce);
                    state.revStatusUnknown = true;
                    continue;
                }
                throw ce;
            }
        }
        if (!state.revStatusUnknown) {
            Trace.msgSecurityPrintln("trustdecider.check.revocation.succeed");
        }
    }

    private static long askUser(X509Certificate[] certArr, CodeSource cs, ValidationState state, AppInfo ai, DeploymentRuleSet drs, Preloader preloader) throws CertificateException, KeyStoreException, IOException, NoSuchAlgorithmException {
        String loc = TrustDecider.getLocString(cs.getLocation(), ai);
        TrustDecider.releaseDeployLock();
        int action = X509Util.showSecurityDialog(certArr, cs.getLocation(), 0, certArr.length, !state.rootCAValid, state.certValidity, state.timestamp != null ? state.timestamp.getTimestamp() : null, new AppInfo(ai), state.revStatusUnknown);
        try {
            TrustDecider.grabDeployLock();
        }
        catch (InterruptedException ie) {
            throw new RuntimeException("Intermediate error trying to perform security validation");
        }
        if (action == 0) {
            Trace.msgSecurityPrintln("trustdecider.user.grant.session");
            sessionStore.add(certArr[0], loc, state.timeValid);
            sessionStore.save();
            state.trustDecision = 1L;
        } else if (action == 2) {
            Trace.msgSecurityPrintln("trustdecider.user.grant.forever");
            CertStore userPermanentStore = DeploySigningCertStore.getUserCertStore();
            userPermanentStore.load(true);
            if (userPermanentStore.add(certArr[0], loc, state.timeValid)) {
                userPermanentStore.save();
            }
            storesLoaded = false;
            state.trustDecision = state.expirationDate;
        } else {
            Trace.msgSecurityPrintln("trustdecider.user.deny");
            deniedStore.add(certArr[0], loc, state.timeValid);
            deniedStore.save();
            String location = cs.getLocation() != null ? cs.getLocation().toString() : null;
            TrustDecider.notifyOnUserDeclined(preloader, location);
            state.trustDecision = 0L;
        }
        return state.trustDecision;
    }

    protected static void recordSandboxAnswer(Certificate[] certs, CodeSource cs, ValidationState state, Preloader preloader, int action, AppInfo ai) {
        boolean denied = false;
        try {
            String loc = TrustDecider.getLocString(cs.getLocation(), ai);
            if (action == 0) {
                sessionSandboxStore.add(certs[0], loc, state.timeValid);
                sessionSandboxStore.save();
                state.trustDecision = 1L;
            } else if (action == 2) {
                sandboxStore.load(true);
                if (sandboxStore.add(certs[0], loc, state.timeValid)) {
                    sandboxStore.save();
                }
                state.trustDecision = state.expirationDate;
            } else {
                deniedStore.add(certs[0], loc, state.timeValid);
                deniedStore.save();
                denied = true;
                String location = cs.getLocation() != null ? cs.getLocation().toString() : null;
                state.trustDecision = 0L;
                TrustDecider.notifyOnUserDeclined(preloader, location);
            }
        }
        catch (Exception e) {
            Trace.ignored(e);
        }
        if (denied) {
            throw new UserDeclinedException("user declined to run signed sandbox app");
        }
    }

    protected static void ensureBasicStoresLoaded() throws InterruptedException, IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
        if (reloadDeniedStore || !storesLoaded) {
            deniedStore.load();
            reloadDeniedStore = false;
        }
        if (storesLoaded) {
            return;
        }
        storesLoaded = true;
        permanentStore.load();
        sandboxStore.load();
        sessionStore.load();
        sessionRevocationStore.load();
        sessionSandboxStore.load();
        sessionDRSStore.load();
        if (browserTrustedStore != null) {
            browserTrustedStore.load();
        }
        if (browserUntrustedStore != null) {
            browserUntrustedStore.load();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long isAllPermissionGranted(CodeSource cs, AppInfo ai, DeploymentRuleSet drs, Preloader preloader) throws CertificateException, KeyStoreException, NoSuchAlgorithmException, IOException, CRLException, InvalidAlgorithmParameterException {
        Config.getHooks().trackUsage(ai, drs);
        boolean isException = true;
        try {
            if (TrustRecorder.isGranted(cs.getLocation(), true)) {
                isException = false;
                long l = 1L;
                return l;
            }
            long ret = TrustDecider.isAllPermissionGrantedInt(cs, ai, drs, preloader);
            isException = false;
            if (ret == 0L) {
                Config.getHooks().confirmAppDenied(drs);
            } else {
                TrustRecorder.grant(cs.getLocation(), true);
            }
            long l = ret;
            return l;
        }
        finally {
            if (isException) {
                Config.getHooks().confirmAppBlocked(drs);
            }
        }
    }

    private static synchronized long isAllPermissionGrantedInt(CodeSource cs, AppInfo ai, DeploymentRuleSet drs, Preloader preloader) throws CertificateException, KeyStoreException, NoSuchAlgorithmException, IOException, CRLException, InvalidAlgorithmParameterException {
        if (drs.isRuleBlock()) {
            String key = "deployment.blocked.by.rule";
            if (drs instanceof BlockRule && ((BlockRule)drs).isFromExceptionList()) {
                key = "deployment.blocked.by.exception.list";
            }
            BlockedDialog.show(ai, drs.getMessage(), key, drs.getException(), cs, drs);
        }
        try {
            TrustDecider.grabDeployLock();
            Certificate[] certs = cs.getCertificates();
            if (certs == null) {
                String weakJarMessage = JarVerifier.getWeakAlgorithmMessage();
                int code = weakJarMessage == null ? 3 : 6;
                JARSigningException jse = new JARSigningException(cs.getLocation(), null, code);
                throw new SecurityException(jse.getRealMessage(), jse);
            }
            try {
                DeployManifestChecker.verify(drs, cs.getLocation(), true, ai);
            }
            catch (SecurityException se) {
                Trace.ignored(se);
                BlockedDialog.show(ai, null, null, se, cs, drs);
            }
            TrustDecider.ensureBasicStoresLoaded();
            List<List<X509Certificate>> chains = TrustDecider.breakDownMultiSignerChains(certs);
            if (TrustDecider.haveValidatorSupport()) {
                Trace.msgSecurityPrintln("trustdecider.check.validate.certpath.algorithm");
                long trustDecision = 0L;
                Iterator<List<X509Certificate>> iterChains = chains.iterator();
                int chainNum = 0;
                while (iterChains.hasNext()) {
                    List<X509Certificate> certList = iterChains.next();
                    X509Certificate[] certArr = certList.toArray(new X509Certificate[certList.size()]);
                    if (iterChains.hasNext() && drs.skipThisCertArray(certArr)) {
                        Trace.println("Skipping cert chain - using DRS run rule for differand cert hash", TraceLevel.RULESET);
                    } else {
                        trustDecision = TrustDecider.validateChain(certArr, cs, chainNum, ai, drs, preloader, false);
                        if (trustDecision != 0L) {
                            if (drs.isRuleRun()) {
                                SandboxSecurity.checkRunRuleMessage(drs, cs.getLocation(), ai, certArr[0]);
                            }
                            long l = trustDecision;
                            return l;
                        }
                    }
                    ++chainNum;
                }
                if (trustDecision == 0L) {
                    String location = cs.getLocation() != null ? cs.getLocation().toString() : null;
                    TrustDecider.notifyOnUserDeclined(preloader, location);
                }
            } else {
                Trace.msgSecurityPrintln("trustdecider.check.validate.legacy.algorithm");
                rootStore.load();
                if (browserRootStore != null) {
                    browserRootStore.load();
                }
                if (CertValidator.validate(cs, ai, certs, chains.size(), rootStore, browserRootStore, browserTrustedStore, sessionStore, permanentStore, deniedStore, drs)) {
                    if (drs.isRuleRun()) {
                        X509Certificate cert = certs[0] instanceof X509Certificate ? (X509Certificate)certs[0] : null;
                        SandboxSecurity.checkRunRuleMessage(drs, cs.getLocation(), ai, cert);
                    }
                    long l = 1L;
                    return l;
                }
            }
        }
        catch (InterruptedException ie) {
            throw new RuntimeException(ie);
        }
        finally {
            TrustDecider.releaseDeployLock();
        }
        return 0L;
    }

    private static boolean checkTSAPath(CertPath tsCertPath, LazyRootStore lazyRootStore, Timestamp timestamp, DeploymentRuleSet drs, CodeSource cs, AppInfo ai) {
        Trace.msgSecurityPrintln("trustdecider.check.timestamping.tsapath");
        List<? extends Certificate> tsCertList = tsCertPath.getCertificates();
        X509Certificate[] tsCerts = tsCertList.toArray(new X509Certificate[tsCertList.size()]);
        X509Certificate last = tsCerts[tsCerts.length - 1];
        try {
            List<X509Certificate> matchedCAList;
            LazyRootStore.TrustedRootResult trustRoots = lazyRootStore.getTrustAnchors(last);
            List<X509Certificate> list = matchedCAList = trustRoots == null ? null : trustRoots.getMatchedCAList();
            if (matchedCAList == null) {
                return false;
            }
            Validator v = Validator.getInstance("PKIX", "tsa server", matchedCAList);
            X509Certificate[] newChain = v.validate(tsCerts, null, timestamp);
            PKIXBuilderParameters params = ((PKIXValidator)v).getParameters();
            boolean bestEffort = drs == null || drs.isRevocationCheckBestEffort();
            boolean[] expired = new boolean[tsCerts.length];
            ValidationState state = new ValidationState(ValidationState.TYPE.ALL_PERMISSIONS);
            String loc = TrustDecider.getLocString(cs.getLocation(), ai);
            if (!sessionRevocationStore.contains(newChain[0], loc, false)) {
                if (sessionRevocationStore.contains(newChain[0], loc, true)) {
                    state.revStatusUnknown = true;
                } else if (!TrustDecider.willBlock(state, drs)) {
                    TrustDecider.checkRevocationStatus(ocspCheck, crlCheck, newChain, params, state, bestEffort, expired);
                    sessionRevocationStore.add(newChain[0], loc, state.revStatusUnknown);
                    sessionRevocationStore.save();
                }
            }
            return true;
        }
        catch (CertificateException ce) {
            Trace.msgSecurityPrintln(ce.getMessage());
        }
        catch (IOException ioe) {
            Trace.msgSecurityPrintln(ioe.getMessage());
        }
        catch (KeyStoreException ke) {
            Trace.msgSecurityPrintln(ke.getMessage());
        }
        catch (NoSuchAlgorithmException nsae) {
            Trace.msgSecurityPrintln(nsae.getMessage());
        }
        return false;
    }

    private static Timestamp getTimeStamp(CodeSource cs, int chainNum, X509Certificate[] certArr, LazyRootStore lazyRootStore, DeploymentRuleSet drs, AppInfo ai) {
        try {
            CodeSigner[] signersArray = cs.getCodeSigners();
            if (signersArray == null || signersArray.length < chainNum + 1) {
                return null;
            }
            Timestamp ts = signersArray[chainNum].getTimestamp();
            if (ts != null) {
                Trace.msgSecurityPrintln("trustdecider.check.timestamping.yes");
                Date timeStampInfo = ts.getTimestamp();
                CertPath tsCertPath = ts.getSignerCertPath();
                boolean foundInvalidCert = false;
                for (int i = 0; i < certArr.length; ++i) {
                    try {
                        certArr[i].checkValidity(timeStampInfo);
                        continue;
                    }
                    catch (CertificateExpiredException e1) {
                        foundInvalidCert = true;
                        break;
                    }
                    catch (CertificateNotYetValidException e2) {
                        foundInvalidCert = true;
                        break;
                    }
                }
                if (!foundInvalidCert) {
                    if (!TrustDecider.checkTSAPath(tsCertPath, lazyRootStore, ts, drs, cs, ai)) {
                        Trace.msgSecurityPrintln("trustdecider.check.timestamping.notinca");
                        return null;
                    }
                    Trace.msgSecurityPrintln("trustdecider.check.timestamping.valid");
                    return ts;
                }
                Trace.msgSecurityPrintln("trustdecider.check.timestamping.invalid");
                return null;
            }
            Trace.msgSecurityPrintln("trustdecider.check.timestamping.no");
            return null;
        }
        catch (NoSuchMethodError nsme) {
            Trace.msgSecurityPrintln("trustdecider.check.timestamping.notfound");
            return null;
        }
    }

    protected static String getLocString(URL u, AppInfo ai) {
        StringBuffer sb = new StringBuffer();
        String urlToLoc = URLUtil.urlToLocation(u);
        if (urlToLoc != null) {
            sb.append(urlToLoc);
        }
        if (ai != null) {
            String jnlp;
            if (ai.isJNLPSourceUnknown()) {
                jnlp = CertUtils.hashToAlias(ai.getAppArgsHashString());
            } else {
                URL jnlpURL = ai.getMainJNLP();
                String string = jnlp = jnlpURL == null ? null : URLUtil.urlToLocation(jnlpURL);
            }
            if (jnlp != null) {
                sb.append("##jnlp:");
                sb.append(jnlp);
            }
            if (ai.getDocumentBase() != null) {
                sb.append("##docbase:");
                sb.append(URLUtil.urlToLocation(ai.getDocumentBase()));
            }
            if (ai.getFrom() != null) {
                sb.append("##from:");
                sb.append(URLUtil.urlToLocation(ai.getFrom()));
            }
        }
        return sb.toString();
    }

    private static void setSelfSignedUsage() {
        ToolkitStore.get().getAppContext().put(ROOT_CA_NOT_VALID, MAIN_JAR_FOUND);
    }

    protected static void checkMainJarManifest(DeploymentRuleSet drs, URL url, AppInfo ai, boolean allPermissions) {
        if (drs.isPermissionsManifestRequired()) {
            AppContext ac = ToolkitStore.get().getAppContext();
            String main = (String)ac.get("deploy-main-class");
            String ver = (String)ac.get("deploy-" + url);
            if (main != null) {
                if (main.equals(MAIN_JAR_FOUND)) {
                    return;
                }
                JarFile jf = null;
                try {
                    jf = JarUtil.createJarFile(new File(ResourceProvider.get().getCachedResourceFilePath(url, ver)), false);
                }
                catch (IOException ioe) {
                    return;
                }
                if (jf != null) {
                    String entryName;
                    if (main.endsWith(".class")) {
                        main = main.substring(0, main.length() - ".class".length());
                    }
                    if (jf.getJarEntry(entryName = main.replace('.', '/') + ".class") != null) {
                        Trace.println("Verifying permission attribute in main jar: " + url, TraceLevel.SECURITY);
                        DeployManifestChecker.verifyMainJar(drs, url, allPermissions, ai);
                        ac.put("deploy-main-class", MAIN_JAR_FOUND);
                    } else {
                        Trace.println("Verified non-main jar: " + url, TraceLevel.SECURITY);
                    }
                } else {
                    throw new SecurityException("could not construct jar file for jar: " + url);
                }
            }
        }
    }

    static {
        deployLock = new DeployLock();
        TrustDecider.reset();
        storesLoaded = false;
        reloadDeniedStore = false;
    }
}

