/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.security;

import com.sun.deploy.config.Config;
import com.sun.deploy.config.SecuritySettings;
import com.sun.deploy.security.CertStore;
import com.sun.deploy.security.LazyRootStore;
import com.sun.deploy.security.RevocationChecker;
import com.sun.deploy.security.SessionCertStore;
import com.sun.deploy.trace.Trace;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.PKIXParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

class RevocationCheckHelper {
    private final CertStore sessionStore;
    private final boolean crlCheck;
    private final boolean ocspCheck;
    private final String ocspSigner;
    private final String ocspURL;
    private final boolean ocspValidConfig;
    private final String revType;
    private final X509CRL crl509;
    private final boolean bestEffort;
    private final String timeout;
    private final String clockSkew;
    private volatile boolean sessionStoreLoaded;
    private final Object sessionStoreLock = new Object();

    RevocationCheckHelper() {
        this.sessionStore = new SessionCertStore("RevocationCheckHelper");
        this.revType = Config.getStringProperty("deployment.security.tls.revocation.check");
        boolean sslRevocationCheckEnabled = !this.revType.equals("NO_CHECK");
        this.timeout = Config.getStringProperty("deployment.security.tls.validation.timeout");
        this.clockSkew = Config.getStringProperty("deployment.security.tls.validation.clockskew");
        this.crlCheck = sslRevocationCheckEnabled && Config.getBooleanProperty("deployment.security.tls.validation.crl");
        this.crl509 = this.crlCheck ? RevocationCheckHelper.retrieveCRL(Config.getStringProperty("deployment.security.tls.validation.crl.url")) : null;
        this.ocspCheck = sslRevocationCheckEnabled && Config.getBooleanProperty("deployment.security.tls.validation.ocsp");
        this.ocspSigner = this.ocspCheck ? Config.getStringProperty("deployment.security.tls.validation.ocsp.signer") : null;
        this.ocspURL = this.ocspCheck ? Config.getStringProperty("deployment.security.tls.validation.ocsp.url") : null;
        this.ocspValidConfig = this.ocspSigner != null && this.ocspSigner.length() > 0 && this.ocspURL != null && this.ocspURL.length() > 0;
        this.bestEffort = SecuritySettings.getManagedBooleanValue("deployment.security.tls.revocation.check.best.effort");
    }

    static X509CRL retrieveCRL(final String crlURL) {
        final X509CRL[] crls = new X509CRL[1];
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Void run() throws Exception {
                    if (crlURL != null && crlURL.length() > 0) {
                        CertificateFactory cf = CertificateFactory.getInstance("X509");
                        URL url = new URL(crlURL);
                        URLConnection connection = url.openConnection();
                        connection.setDoInput(true);
                        connection.setUseCaches(false);
                        try (DataInputStream inStream = null;){
                            inStream = new DataInputStream(connection.getInputStream());
                            crls[0] = (X509CRL)cf.generateCRL(inStream);
                        }
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            Trace.ignored(e);
        }
        return crls[0];
    }

    boolean checkRevocationStatus(X509Certificate[] chain, X509Certificate anchor, String location, List<X509Certificate> caList, LazyRootStore lazyRootStore, boolean[] expired, String variant) throws CertificateException {
        try {
            return this.doRevocationCheck(chain, anchor, location, caList, lazyRootStore, expired, variant);
        }
        catch (KeyStoreException e) {
            Trace.printException(e);
            throw new CertificateException(e);
        }
        catch (NoSuchAlgorithmException e) {
            Trace.printException(e);
            throw new CertificateException(e);
        }
        catch (IOException e) {
            Trace.printException(e);
            throw new CertificateException(e);
        }
        catch (InvalidAlgorithmParameterException e) {
            Trace.printException(e);
            throw new CertificateException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doRevocationCheck(X509Certificate[] chain, X509Certificate anchor, String location, List<X509Certificate> matchedCAList, LazyRootStore lazyRootStore, boolean[] expired, String variant) throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        if (!this.ocspCheck && !this.crlCheck) {
            Trace.msgSecurityPrintln("Revocation check disabled");
            return false;
        }
        Object object = this.sessionStoreLock;
        synchronized (object) {
            if (!this.sessionStoreLoaded) {
                this.sessionStore.load();
                this.sessionStoreLoaded = true;
            }
            if (this.sessionStore.contains(chain[0], location, false)) {
                return false;
            }
        }
        HashSet<TrustAnchor> trustedAnchors = new HashSet<TrustAnchor>(matchedCAList.size());
        Iterator<X509Certificate> it = matchedCAList.iterator();
        while (it.hasNext()) {
            trustedAnchors.add(new TrustAnchor(it.next(), null));
        }
        PKIXParameters params = new PKIXParameters(trustedAnchors);
        params.setDate(new Date());
        boolean isRevocationStatusUnknown = this.doRevocationCheck(chain, anchor, params, expired, lazyRootStore, variant);
        if (!isRevocationStatusUnknown) {
            Object object2 = this.sessionStoreLock;
            synchronized (object2) {
                this.sessionStore.add(chain[0], location, false);
            }
        }
        return isRevocationStatusUnknown;
    }

    private boolean doRevocationCheck(X509Certificate[] chain, X509Certificate anchor, PKIXParameters params, boolean[] expired, LazyRootStore lazyRootStore, String variant) throws CertificateException {
        boolean isRevocationStatusUnknown = false;
        X509Certificate ocspCert = null;
        if (this.ocspCheck && this.ocspValidConfig) {
            try {
                lazyRootStore.containSubject(this.ocspSigner);
                ocspCert = lazyRootStore.getOCSPCert();
            }
            catch (Exception e) {
                Trace.ignored(e);
            }
        }
        boolean onlyServerCertificate = this.revType.equals("SERVER_CERTIFICATE_ONLY");
        RevocationChecker rc = new RevocationChecker(anchor, params, this.ocspCheck, this.crlCheck, this.ocspURL, ocspCert, onlyServerCertificate, this.crl509, null, this.timeout, this.clockSkew, variant);
        for (int i = chain.length - 1; i >= 0; --i) {
            X509Certificate cert = chain[i];
            try {
                rc.check(cert, expired[i]);
                continue;
            }
            catch (CertificateException ce) {
                if (ce instanceof RevocationChecker.StatusUnknownException && this.bestEffort) {
                    isRevocationStatusUnknown = true;
                    Trace.msgSecurityPrintln("Revocation Status Unknown");
                    Trace.ignored(ce);
                    continue;
                }
                throw ce;
            }
        }
        return isRevocationStatusUnknown;
    }
}

