/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.security;

import com.sun.deploy.security.BrowserKeystore;
import com.sun.deploy.security.MozillaJSSDSAPrivateKey;
import com.sun.deploy.security.MozillaJSSPrivateKey;
import com.sun.deploy.security.MozillaJSSRSAPrivateKey;
import com.sun.deploy.trace.Trace;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.Key;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.NoSuchAlgorithmException;
import java.security.SecurityPermission;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;

public final class MozillaMyKeyStore
extends KeyStoreSpi {
    private Collection<KeyEntry> keyEntries = new ArrayList<KeyEntry>();

    @Override
    public Key engineGetKey(String alias, char[] password) throws NoSuchAlgorithmException, UnrecoverableKeyException {
        if (password != null && password.length > 0) {
            throw new UnrecoverableKeyException("Password is not required for Mozilla MY keystore.");
        }
        if (!this.engineIsKeyEntry(alias)) {
            return null;
        }
        for (KeyEntry entry : this.keyEntries) {
            if (!alias.equals(entry.getAlias())) continue;
            return entry.getPrivateKey();
        }
        return null;
    }

    @Override
    public Certificate[] engineGetCertificateChain(String alias) {
        for (KeyEntry entry : this.keyEntries) {
            if (!alias.equals(entry.getAlias())) continue;
            X509Certificate[] certChain = entry.getCertificateChain();
            Certificate[] tmp = (X509Certificate[])certChain.clone();
            return tmp;
        }
        return null;
    }

    @Override
    public Certificate engineGetCertificate(String alias) {
        for (KeyEntry entry : this.keyEntries) {
            if (!alias.equals(entry.getAlias())) continue;
            X509Certificate[] certChain = entry.getCertificateChain();
            return certChain[0];
        }
        return null;
    }

    @Override
    public Date engineGetCreationDate(String alias) {
        return new Date();
    }

    @Override
    public void engineSetKeyEntry(String alias, Key key, char[] password, Certificate[] chain) throws KeyStoreException {
        throw new KeyStoreException("Cannot assign the given key to the given alias.");
    }

    @Override
    public void engineSetKeyEntry(String alias, byte[] key, Certificate[] chain) throws KeyStoreException {
        throw new KeyStoreException("Cannot assign the given key to the given alias.");
    }

    @Override
    public void engineSetCertificateEntry(String alias, Certificate cert) throws KeyStoreException {
        throw new KeyStoreException("Cannot assign the given certificate to the given alias.");
    }

    @Override
    public void engineDeleteEntry(String alias) throws KeyStoreException {
        throw new KeyStoreException("Mozilla does not support alias removal.");
    }

    @Override
    public Enumeration<String> engineAliases() {
        final Iterator<KeyEntry> iter = this.keyEntries.iterator();
        return new Enumeration<String>(){

            @Override
            public boolean hasMoreElements() {
                return iter.hasNext();
            }

            @Override
            public String nextElement() {
                KeyEntry entry = (KeyEntry)iter.next();
                return entry.getAlias();
            }
        };
    }

    @Override
    public boolean engineContainsAlias(String alias) {
        Enumeration<String> enumerator = this.engineAliases();
        while (enumerator.hasMoreElements()) {
            String a = enumerator.nextElement();
            if (!a.equals(alias)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int engineSize() {
        return this.keyEntries.size();
    }

    @Override
    public boolean engineIsKeyEntry(String alias) {
        return alias.startsWith("MozillaJSSRSAPrivateKey") || alias.startsWith("MozillaJSSDSAPrivateKey");
    }

    @Override
    public boolean engineIsCertificateEntry(String alias) {
        return false;
    }

    @Override
    public String engineGetCertificateAlias(Certificate cert) {
        for (KeyEntry entry : this.keyEntries) {
            if (entry.certChain == null || !entry.certChain[0].equals(cert)) continue;
            return entry.getAlias();
        }
        return null;
    }

    @Override
    public void engineStore(OutputStream stream, char[] password) throws IOException, NoSuchAlgorithmException, CertificateException {
        throw new IOException("Mozilla cert store cannot be stored into stream.");
    }

    @Override
    public void engineLoad(InputStream stream, char[] tokenpass) throws IOException, NoSuchAlgorithmException, CertificateException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new SecurityPermission("authProvider.SunDeploy-MozillaJSS"));
        }
        if (stream != null) {
            throw new IOException("Mozilla cert store cannot be loaded from stream.");
        }
        this.keyEntries.clear();
        try {
            Class<?> jsscm = Class.forName("org.mozilla.jss.CryptoManager", true, ClassLoader.getSystemClassLoader());
            Object cryptoManager = BrowserKeystore.getJSSCryptoManager();
            Method getInternalKeyStorageTokenMethod = jsscm.getMethod("getInternalKeyStorageToken", new Class[0]);
            Object internalKeyStorageToken = getInternalKeyStorageTokenMethod.invoke(cryptoManager, (Object[])null);
            this.generateKeyAndCertificateFromToken(cryptoManager, internalKeyStorageToken);
            Method getExternalTokenMethod = jsscm.getMethod("getExternalTokens", new Class[0]);
            Enumeration externalTokens = (Enumeration)getExternalTokenMethod.invoke(cryptoManager, (Object[])null);
            while (externalTokens.hasMoreElements()) {
                Object token = externalTokens.nextElement();
                this.generateKeyAndCertificateFromToken(cryptoManager, token);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private void generateKeyAndCertificateFromToken(Object cryptoManager, Object token) throws Throwable {
        Object[] certs;
        Class<?> jsscm = Class.forName("org.mozilla.jss.CryptoManager", true, ClassLoader.getSystemClassLoader());
        Class<?> jsstk = Class.forName("org.mozilla.jss.crypto.CryptoToken", true, ClassLoader.getSystemClassLoader());
        Method getCSMeth = jsstk.getMethod("getCryptoStore", new Class[0]);
        Object store = getCSMeth.invoke(token, (Object[])null);
        Class<?> jsscs = Class.forName("org.mozilla.jss.crypto.CryptoStore", true, ClassLoader.getSystemClassLoader());
        Method getCertsmeth = jsscs.getMethod("getCertificates", new Class[0]);
        for (Object cert : certs = (Object[])getCertsmeth.invoke(store, (Object[])null)) {
            Field sslcfield;
            Object[] alist;
            Class<?> jsscertusage;
            Class[] ptypes;
            Method isCertValidMeth;
            Boolean sslClient;
            Class<?> jsscertarr = Class.forName("org.mozilla.jss.crypto.X509Certificate", true, ClassLoader.getSystemClassLoader());
            Method getNickNameMeth = jsscertarr.getMethod("getNickname", new Class[0]);
            String nickName = (String)getNickNameMeth.invoke(cert, (Object[])null);
            if (nickName == null || !(sslClient = (Boolean)(isCertValidMeth = jsscm.getMethod("isCertValid", ptypes = new Class[]{String.class, Boolean.TYPE, jsscertusage = Class.forName("org.mozilla.jss.CryptoManager$CertUsage", true, ClassLoader.getSystemClassLoader())})).invoke(cryptoManager, alist = new Object[]{nickName, Boolean.FALSE, (sslcfield = jsscertusage.getField("SSLClient")).get(cert)})).booleanValue()) continue;
            try {
                Class[] partypes3 = new Class[]{jsscertarr};
                Method findPrivKeyMeth = jsscm.getMethod("findPrivKeyByCert", partypes3);
                Object[] arglist3 = new Object[]{cert};
                Object pk = findPrivKeyMeth.invoke(cryptoManager, arglist3);
                Class<?> jssprivkey = Class.forName("org.mozilla.jss.crypto.PrivateKey", true, ClassLoader.getSystemClassLoader());
                Method getTypeMeth = jssprivkey.getMethod("getType", new Class[0]);
                Object keytype = getTypeMeth.invoke(pk, (Object[])null);
                Class<?> jssprivkeytype = Class.forName("org.mozilla.jss.crypto.PrivateKey$Type", true, ClassLoader.getSystemClassLoader());
                Field rsaField = jssprivkeytype.getField("RSA");
                Field dsaField = jssprivkeytype.getField("DSA");
                Object rsaKeyType = rsaField.get(null);
                Object dsaKeyType = dsaField.get(null);
                if (!keytype.equals(rsaKeyType) && !keytype.equals(dsaKeyType)) continue;
                Class[] partypes4 = new Class[]{jsscertarr};
                Method buildCertChainMeth = jsscm.getMethod("buildCertificateChain", partypes4);
                Object[] arglist4 = new Object[]{cert};
                Object[] chain = (Object[])buildCertChainMeth.invoke(cryptoManager, arglist4);
                ArrayList<X509Certificate> certChain = new ArrayList<X509Certificate>();
                for (Object chain1 : chain) {
                    Method getEncodedMeth = jsscertarr.getMethod("getEncoded", new Class[0]);
                    Object certByte = getEncodedMeth.invoke(chain1, (Object[])null);
                    this.generateCertificate((byte[])certByte, certChain);
                }
                Method getStrengthMeth = jssprivkey.getMethod("getStrength", new Class[0]);
                Integer sizeKey = (Integer)getStrengthMeth.invoke(pk, (Object[])null);
                if (keytype.equals(rsaKeyType)) {
                    this.generateRSAKeyAndCertificateChain(pk, sizeKey, certChain, this.keyEntries);
                    continue;
                }
                this.generateDSAKeyAndCertificateChain(pk, sizeKey, certChain, this.keyEntries);
            }
            catch (Throwable e) {
                Trace.msgSecurityPrintln("mozillamykeystore.priv.notfound", new Object[]{nickName});
            }
        }
    }

    private void generateRSAKeyAndCertificateChain(Object key, int keyLength, Collection<X509Certificate> certCollection, Collection<KeyEntry> keyEntries) {
        try {
            X509Certificate[] certChain = new X509Certificate[certCollection.size()];
            int i = 0;
            Iterator<X509Certificate> iter = certCollection.iterator();
            while (iter.hasNext()) {
                certChain[i] = iter.next();
                ++i;
            }
            KeyEntry entry = new KeyEntry(new MozillaJSSRSAPrivateKey(key, keyLength), certChain);
            keyEntries.add(entry);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private void generateDSAKeyAndCertificateChain(Object key, int keyLength, Collection<X509Certificate> certCollection, Collection<KeyEntry> keyEntries) {
        try {
            X509Certificate[] certChain = new X509Certificate[certCollection.size()];
            int i = 0;
            Iterator<X509Certificate> iter = certCollection.iterator();
            while (iter.hasNext()) {
                certChain[i] = iter.next();
                ++i;
            }
            KeyEntry entry = new KeyEntry(new MozillaJSSDSAPrivateKey(key, keyLength), certChain);
            keyEntries.add(entry);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private void generateCertificate(byte[] data, Collection<X509Certificate> certCollection) {
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(data);
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            Collection<? extends Certificate> c = cf.generateCertificates(bis);
            for (X509Certificate x509Certificate : c) {
                certCollection.add(x509Certificate);
            }
        }
        catch (CertificateException e) {
            e.printStackTrace();
        }
        catch (Throwable te) {
            te.printStackTrace();
        }
    }

    protected String getName() {
        return "MY";
    }

    class KeyEntry {
        private MozillaJSSPrivateKey privateKey;
        private X509Certificate[] certChain;

        KeyEntry(MozillaJSSPrivateKey key, X509Certificate[] chain) {
            this.privateKey = key;
            this.certChain = chain;
        }

        String getAlias() {
            return this.privateKey.toString();
        }

        Key getPrivateKey() {
            return this.privateKey;
        }

        X509Certificate[] getCertificateChain() {
            return this.certChain;
        }
    }
}

