/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.security;

import com.sun.deploy.security.MozillaJSSDSASignature;
import com.sun.deploy.security.MozillaJSSNONEwithRSASignature;
import com.sun.deploy.security.MozillaMyKeyStore;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.InvalidParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.security.Provider;
import java.security.ProviderException;
import java.security.SecurityPermission;

public final class MozillaJSSProvider
extends Provider {
    private static final long serialVersionUID = 3884593006617837243L;
    private static final String info = "SunDeploy-MozillaJSS Provider (implements RSA)";
    private static final AccessControlContext ACC_INSTANCE;

    public MozillaJSSProvider() {
        super("SunDeploy-MozillaJSS", 1.5, info);
        final MozillaJSSProvider p = this;
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                MozillaJSSProvider.this.putService(new ProviderService(p, "Signature", "NONEwithRSA", "com.sun.deploy.security.MozillaJSSNONEwithRSASignature"));
                MozillaJSSProvider.this.putService(new ProviderService(p, "Signature", "DSA", "com.sun.deploy.security.MozillaJSSDSASignature$SHA1withDSA"));
                MozillaJSSProvider.this.putService(new ProviderService(p, "Signature", "RawDSA", "com.sun.deploy.security.MozillaJSSDSASignature$NONEwithDSA"));
                MozillaJSSProvider.this.putService(new ProviderService(p, "KeyStore", "MozillaMy", "com.sun.deploy.security.MozillaMyKeyStore"));
                return null;
            }
        }, ACC_INSTANCE);
    }

    static {
        Permissions perms = new Permissions();
        SecurityPermission perm = new SecurityPermission("putProviderProperty.SunDeploy-MozillaJSS");
        ((PermissionCollection)perms).add(perm);
        ACC_INSTANCE = new AccessControlContext(new ProtectionDomain[]{new ProtectionDomain(null, perms)});
    }

    private static final class ProviderService
    extends Provider.Service {
        ProviderService(Provider p, String type, String algo, String cn) {
            super(p, type, algo, cn, null, null);
        }

        @Override
        public Object newInstance(Object ctrParamObj) throws NoSuchAlgorithmException {
            String type = this.getType();
            if (ctrParamObj != null) {
                throw new InvalidParameterException("constructorParameter not used with " + type + " engines");
            }
            String algo = this.getAlgorithm();
            try {
                if (algo.equals("NONEwithRSA")) {
                    return new MozillaJSSNONEwithRSASignature();
                }
                if (algo.equals("DSA")) {
                    return new MozillaJSSDSASignature.SHA1withDSA();
                }
                if (algo.equals("RawDSA")) {
                    return new MozillaJSSDSASignature.NONEwithDSA();
                }
                if (algo.equals("MozillaMy")) {
                    return new MozillaMyKeyStore();
                }
            }
            catch (Exception ex) {
                throw new NoSuchAlgorithmException("Error constructing " + type + " for " + algo + " using SunDeploy-MozillaJSS", ex);
            }
            throw new ProviderException("No impl for " + algo + " " + type);
        }
    }
}

