/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.security;

import com.sun.deploy.security.MozillaJSSRSAPrivateKey;
import com.sun.deploy.trace.Trace;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.SignatureSpi;
import sun.security.rsa.RSACore;
import sun.security.rsa.RSAPadding;

public final class MozillaJSSNONEwithRSASignature
extends SignatureSpi {
    private byte[] buffer;
    private int bufOfs;
    private MozillaJSSRSAPrivateKey privateKey = null;

    @Override
    protected void engineInitVerify(PublicKey key) throws InvalidKeyException {
        throw new InvalidKeyException("Key not supported");
    }

    @Override
    protected void engineInitSign(PrivateKey key) throws InvalidKeyException {
        if (!(key instanceof MozillaJSSRSAPrivateKey)) {
            throw new InvalidKeyException("Key not supported");
        }
        this.privateKey = (MozillaJSSRSAPrivateKey)key;
        int keySize = this.privateKey.bitLength() + 7 >> 3;
        if (keySize < 64) {
            throw new InvalidKeyException("RSA keys should be at least 512 bits long");
        }
        this.bufOfs = 0;
        try {
            RSAPadding padding = RSAPadding.getInstance(1, keySize, this.appRandom);
            int maxDataSize = padding.getMaxDataSize();
            this.buffer = new byte[maxDataSize];
        }
        catch (InvalidAlgorithmParameterException exc) {
            Trace.securityPrintException(exc);
        }
    }

    private void update(byte[] in, int inOfs, int inLen) {
        if (inLen == 0 || in == null) {
            return;
        }
        if (this.bufOfs + inLen > this.buffer.length) {
            this.bufOfs = this.buffer.length + 1;
            return;
        }
        System.arraycopy(in, inOfs, this.buffer, this.bufOfs, inLen);
        this.bufOfs += inLen;
    }

    @Override
    protected void engineUpdate(byte b) throws SignatureException {
        byte[] buf = new byte[]{b};
        this.update(buf, 0, 1);
    }

    @Override
    protected void engineUpdate(byte[] b, int off, int len) throws SignatureException {
        this.update(b, off, len);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected byte[] engineSign() throws SignatureException {
        if (this.bufOfs > this.buffer.length) {
            throw new SignatureException("Data must not be longer than " + this.buffer.length + " bytes");
        }
        try {
            byte[] hash = RSACore.convert(this.buffer, 0, this.bufOfs);
            Object result = null;
            try {
                Object pk = this.privateKey.getJSSPrivateKey();
                Class<?> jssprivkey = Class.forName("org.mozilla.jss.crypto.PrivateKey", true, ClassLoader.getSystemClassLoader());
                Method getOwnTokenMeth = jssprivkey.getMethod("getOwningToken", new Class[0]);
                Object token = getOwnTokenMeth.invoke(pk, (Object[])null);
                Class<?> jsscryptotoken = Class.forName("org.mozilla.jss.crypto.CryptoToken", true, ClassLoader.getSystemClassLoader());
                Class<?> jsssigalgo = Class.forName("org.mozilla.jss.crypto.SignatureAlgorithm", true, ClassLoader.getSystemClassLoader());
                Class[] partypes = new Class[]{jsssigalgo};
                Method getSigConMeth = jsscryptotoken.getMethod("getSignatureContext", partypes);
                Field rsasigfield = jsssigalgo.getField("RSASignature");
                Object[] arglist = new Object[]{rsasigfield.get(this.privateKey)};
                Object sig = getSigConMeth.invoke(token, arglist);
                Class<?> jsssignature = Class.forName("org.mozilla.jss.crypto.Signature", true, ClassLoader.getSystemClassLoader());
                Class[] partypes2 = new Class[]{jssprivkey};
                Method initSignMeth = jsssignature.getMethod("initSign", partypes2);
                Object[] arglist2 = new Object[]{pk};
                Object siginit = initSignMeth.invoke(sig, arglist2);
                Class[] partypes3 = new Class[]{byte[].class};
                Method updateMeth = jsssignature.getMethod("update", partypes3);
                Object[] arglist3 = new Object[]{hash};
                Object sigupdate = updateMeth.invoke(sig, arglist3);
                Method signMeth = jsssignature.getMethod("sign", new Class[0]);
                result = signMeth.invoke(sig, (Object[])null);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            byte[] byArray = (byte[])result;
            return byArray;
        }
        finally {
            this.bufOfs = 0;
        }
    }

    @Override
    protected boolean engineVerify(byte[] sigBytes) throws SignatureException {
        throw new SignatureException("Signature verification not supported");
    }

    @Override
    @Deprecated
    protected void engineSetParameter(String param, Object value) throws InvalidParameterException {
        throw new InvalidParameterException("Parameter not supported");
    }

    @Override
    @Deprecated
    protected Object engineGetParameter(String param) throws InvalidParameterException {
        throw new InvalidParameterException("Parameter not supported");
    }
}

