/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.security;

import com.sun.deploy.model.Resource;
import com.sun.deploy.model.ResourceProvider;
import com.sun.deploy.security.ManifestException;
import com.sun.deploy.security.ruleset.DeploymentRuleSet;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.ui.AppInfo;
import com.sun.deploy.uitoolkit.ToolkitStore;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public class DeployManifestChecker {
    private static final String PERMISSIONS_ATTR = "Permissions";
    private static final String CODEBASE_ATTR = "Codebase";
    private static final String NAME_ATTR = "Application-Name";
    private static final String LIBRARY_CODEBASE_ATTR = "Application-Library-Allowable-Codebase";
    private static final String SANDBOX_VALUE = "sandbox";
    private static final String ALLPERMS_VALUE = "all-permissions";
    private static final String ENTRY_POINT = "Entry-Point";
    private static final String JARJNLP_SUFFIX = ".jarjnlp";
    private static final String JAR_SUFFIX = ".jar";

    private DeployManifestChecker() {
    }

    public static void verify(DeploymentRuleSet drs, URL jarLocation, boolean allPermissions, AppInfo ai) {
        String jarVersion = (String)ToolkitStore.get().getAppContext().get("deploy-" + jarLocation);
        Resource re = ResourceProvider.get().getCachedResource(jarLocation, jarVersion);
        if (re == null || !re.isJarFile()) {
            return;
        }
        JarFile jf = re.getJarFile();
        try {
            Manifest mf = jf.getManifest();
            if (mf == null) {
                throw new SecurityException("Manifest file is not found in " + jarLocation);
            }
            DeployManifestChecker.verify(drs, jarLocation, mf.getMainAttributes(), allPermissions, ai);
        }
        catch (IOException ioe) {
            Trace.ignored(ioe);
            throw new SecurityException("unexpected exception when trying to access manifest attributes");
        }
    }

    public static void verifyMainJar(DeploymentRuleSet drs, URL location, boolean allPermissions, AppInfo ai) {
        String jarVersion = (String)ToolkitStore.get().getAppContext().get("deploy-" + location);
        Resource re = ResourceProvider.get().getCachedResource(location, jarVersion);
        if (re == null || !re.isJarFile()) {
            return;
        }
        JarFile jf = re.getJarFile();
        try {
            DeployManifestChecker.verifyMainJar(drs, location, jf.getManifest().getMainAttributes(), allPermissions, ai);
        }
        catch (IOException ioe) {
            Trace.ignored(ioe);
            throw new SecurityException("unexpected exception when trying to access manifest attributes");
        }
    }

    static void verifyMainJar(DeploymentRuleSet drs, URL location, Attributes mainAttr, boolean allPermissions, AppInfo ai) {
        String value = mainAttr.getValue(PERMISSIONS_ATTR);
        if (value == null) {
            if (drs.isPermissionsManifestRequired()) {
                throw new ManifestException(4, "Missing required Permissions manifest attribute in main jar: " + location);
            }
            Trace.println("Missing Permissions manifest attribute in main jar: " + location);
        }
    }

    public static int getPermissionRequestType(URL jarLocation, String jarVersion) {
        Resource re = ResourceProvider.get().getCachedResource(jarLocation, jarVersion);
        if (re == null || !re.isJarFile()) {
            return 0;
        }
        JarFile jf = re.getJarFile();
        try {
            Attributes mainAttr = jf.getManifest().getMainAttributes();
            String value = mainAttr.getValue(PERMISSIONS_ATTR);
            if (value != null) {
                if (value.equals(SANDBOX_VALUE)) {
                    return 1;
                }
                if (value.equals(ALLPERMS_VALUE)) {
                    return 2;
                }
            }
        }
        catch (IOException ioe) {
            Trace.ignored(ioe);
        }
        return 0;
    }

    static void verify(DeploymentRuleSet drs, URL jarLocation, Attributes mainAttr, boolean allPermissions, AppInfo ai) {
        if (ai != null && !ai.hasSignedJNLP()) {
            String applicationName = mainAttr.getValue(NAME_ATTR);
            if (applicationName == null) {
                applicationName = mainAttr.getValue(Attributes.Name.MAIN_CLASS);
            }
            ai.setTitle(applicationName);
        }
        String value = mainAttr.getValue(PERMISSIONS_ATTR);
        if (ai != null) {
            ai.setPermissionAttr(value != null);
        }
        if (SANDBOX_VALUE.equals(value)) {
            if (allPermissions) {
                throw new ManifestException(2, "JAR manifest requested to run in sandbox only: " + jarLocation);
            }
        } else if (ALLPERMS_VALUE.equals(value)) {
            if (!allPermissions) {
                throw new ManifestException(3, "JAR manifest requested to run in all-permissions only: " + jarLocation);
            }
        } else if (value != null) {
            throw new ManifestException(1, "Invalid Permissions value: " + value);
        }
        if ((value = mainAttr.getValue(CODEBASE_ATTR)) == null) {
            Trace.println("Missing Codebase manifest attribute for: " + jarLocation, TraceLevel.SECURITY);
        } else if (!DeployManifestChecker.verifyCodebase(jarLocation, value, false)) {
            throw new ManifestException(5, "JAR manifest codebase mismatch for " + jarLocation);
        }
        value = mainAttr.getValue(LIBRARY_CODEBASE_ATTR);
        if (value == null) {
            Trace.println("Missing Application-Library-Allowable-Codebase manifest attribute for: " + jarLocation, TraceLevel.SECURITY);
        } else if (!DeployManifestChecker.verifyApplicationLibraryAllowableCodebase(jarLocation, ai)) {
            throw new ManifestException(6, "JAR manifest application-library-allowable-codebase  mismatch for " + jarLocation);
        }
    }

    public static String verifyMainClass(String mainClassName, Attributes mainAttr) {
        if (mainClassName == null) {
            mainClassName = mainAttr.getValue(Attributes.Name.MAIN_CLASS);
        }
        String entryPoint = mainAttr.getValue(ENTRY_POINT);
        String[] entryPointList = null;
        if (entryPoint == null) {
            return mainClassName;
        }
        entryPointList = entryPoint.split("\\s");
        HashMap<String, String> map = new HashMap<String, String>();
        for (String entryPointList1 : entryPointList) {
            map.put(entryPointList1.trim(), "true");
        }
        if (mainClassName != null && map.get(mainClassName) == null) {
            throw new ManifestException(7, mainClassName + " class is not mentioned in the Entry point list");
        }
        return mainClassName;
    }

    public static boolean verifyCodebase(URL resourceURL, String allowedCodebases, boolean enforceHTTPS) {
        int matchStatus = DeployManifestChecker.verifyCodebaseEx(resourceURL, allowedCodebases, enforceHTTPS);
        return matchStatus == 4 || matchStatus == 2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int verifyCodebaseEx(URL resourceURL, String allowedCodebases, boolean enforceHTTPS) {
        String actualHost = resourceURL.getHost();
        String actualProtocol = resourceURL.getProtocol();
        int actualPort = resourceURL.getPort();
        boolean wildCardMatch = false;
        String[] codebaseList = allowedCodebases.split("\\s");
        boolean protocolMatch = false;
        boolean hostMatch = false;
        boolean portMatch = false;
        int x = 0;
        while (x < codebaseList.length) {
            int port;
            String hostname = null;
            String protocol = null;
            URL u = null;
            try {
                u = new URL(codebaseList[x]);
                hostname = u.getHost();
                protocol = u.getProtocol();
                port = u.getPort();
            }
            catch (MalformedURLException mue) {
                hostname = codebaseList[x];
                int portIndex = hostname.indexOf(":");
                if (portIndex == -1) {
                    port = -1;
                }
                hostname = codebaseList[x].substring(0, portIndex);
                port = Integer.parseInt(codebaseList[x].substring(portIndex + 1));
            }
            if (port == -1) {
                portMatch = true;
            } else if (port == actualPort) {
                portMatch = true;
            }
            if (protocol != null) {
                if (protocol.equals(actualProtocol)) {
                    protocolMatch = true;
                }
            } else {
                protocolMatch = true;
            }
            if (hostname.equals("*")) {
                hostMatch = true;
                wildCardMatch = true;
            } else if (hostname.indexOf("*") != -1) {
                if (!hostname.startsWith("*.")) throw new ManifestException(5, "Invalid Codebase value: " + codebaseList[x]);
                String subdomain = hostname.substring(2);
                if (actualHost.endsWith(subdomain)) {
                    hostMatch = true;
                    if (subdomain.indexOf(46) == -1) {
                        wildCardMatch = true;
                    }
                }
            } else if (hostname.equals(actualHost)) {
                hostMatch = true;
            }
            if (protocolMatch && hostMatch && portMatch) {
                if (enforceHTTPS && "http".equals(resourceURL.getProtocol()) && !"http".equals(protocol)) {
                    Trace.println("Javascript from a non secure page is accessing privileged code. Consider using HTTPS protocol when using Javascript -> Java liveconnect calls.", TraceLevel.SECURITY);
                }
                if (!wildCardMatch) return 2;
                return 4;
            }
            hostMatch = false;
            protocolMatch = false;
            portMatch = false;
            ++x;
        }
        return 1;
    }

    public static boolean verifyApplicationLibraryAllowableCodebase(URL jarLocation, AppInfo ai) {
        if (jarLocation.toString().endsWith(JARJNLP_SUFFIX)) {
            String jarLocationString = jarLocation.toString();
            try {
                jarLocation = new URL(jarLocationString.substring(0, jarLocationString.length() - JARJNLP_SUFFIX.length()) + JAR_SUFFIX);
            }
            catch (MalformedURLException e) {
                Trace.ignored(e);
                return false;
            }
        }
        String jarVersion = (String)ToolkitStore.get().getAppContext().get("deploy-" + jarLocation);
        Resource re = ResourceProvider.get().getCachedResource(jarLocation, jarVersion);
        if (re == null || !re.isJarFile()) {
            return true;
        }
        JarFile jf = re.getJarFile();
        boolean result = false;
        try {
            String value = jf.getManifest().getMainAttributes().getValue(LIBRARY_CODEBASE_ATTR);
            if (value == null) {
                Trace.println("Missing Application-Library-Allowable-Codebase manifest attribute for: " + jarLocation, TraceLevel.SECURITY);
            }
            if (value != null && value.trim().length() > 0) {
                URL[] urls = ai.getMultiHostUrls();
                for (int i = 0; i < urls.length && (result = DeployManifestChecker.verifyCodebase(urls[i], value, false)); ++i) {
                }
            }
        }
        catch (IOException ioe) {
            Trace.ignored(ioe);
        }
        return result;
    }

    static void printWarningsIfRequired(URL jarLocation, AppInfo ai) {
        String jarVersion = (String)ToolkitStore.get().getAppContext().get("deploy-" + jarLocation);
        Resource re = ResourceProvider.get().getCachedResource(jarLocation, jarVersion);
        if (re == null || !re.isJarFile()) {
            return;
        }
        JarFile jf = re.getJarFile();
        if (ai != null && !ai.hasSignedJNLP()) {
            try {
                Attributes mainAttr = jf.getManifest().getMainAttributes();
                String applicationName = mainAttr.getValue(NAME_ATTR);
                if (applicationName == null) {
                    Trace.println("Missing Application-Name manifest attribute for: " + jarLocation);
                }
            }
            catch (IOException ioe) {
                Trace.ignored(ioe);
            }
        }
    }

    public final class CodebaseCheckState {
        public static final int NO_MATCH = 1;
        public static final int STRICT_MATCH = 2;
        public static final int MATCH_BY_WILDCARD = 4;
    }
}

