/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.security;

import com.sun.deploy.config.Config;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.security.CertUtils;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.ui.AppInfo;
import com.sun.deploy.uitoolkit.ToolkitStore;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashSet;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;

public final class CertificateHostnameVerifier
implements HostnameVerifier {
    private static final HashSet<Object[]> hashSet = new HashSet();

    @Override
    public boolean verify(String hostname, SSLSession session) {
        X509Certificate peerCert;
        String certHostname = ResourceManager.getString("https.dialog.unknown.host");
        try {
            int cn;
            Certificate[] cert = session.getPeerCertificates();
            if (!(cert[0] instanceof X509Certificate)) {
                throw new SSLPeerUnverifiedException("");
            }
            peerCert = (X509Certificate)cert[0];
            String certDN = peerCert.getSubjectDN().getName();
            if (certDN != null && (cn = certDN.toUpperCase().indexOf("CN=")) != -1) {
                int end = certDN.indexOf(",", cn);
                certHostname = end != -1 ? certDN.substring(cn + 3, end) : certDN.substring(cn + 3);
            }
        }
        catch (SSLPeerUnverifiedException e) {
            return false;
        }
        ArrayList<String> certHostnameList = CertUtils.getServername(peerCert);
        if (CertUtils.checkWildcardDomainList(hostname, certHostnameList)) {
            return true;
        }
        for (Object[] elements : hashSet) {
            if (!elements[0].toString().equalsIgnoreCase(hostname) || !elements[1].toString().equalsIgnoreCase(certHostname)) continue;
            return true;
        }
        return this.showHostnameMismatchDialog(hostname, certHostname);
    }

    private boolean showHostnameMismatchDialog(String hostname, String certHostname) {
        int result;
        String title = ResourceManager.getString("https.dialog.caption");
        String message = ResourceManager.getString("https.dialog.masthead");
        AppInfo info = new AppInfo(0, hostname, certHostname, null, null, null, null, false, false, null, null);
        String okString = ResourceManager.getString("security.dialog.signed.buttonContinue");
        String cancelString = ResourceManager.getString("security.dialog.signed.buttonCancel");
        String[] warning = new String[]{ResourceManager.getString("security.dialog.hostname.mismatch.sub", hostname, certHostname)};
        if (!Trace.isAutomationEnabled()) {
            result = Config.getBooleanProperty("deployment.security.jsse.hostmismatch.warning") ? ToolkitStore.getUI().showSecurityDialog(info, title, message, certHostname, null, false, false, okString, cancelString, warning, null, false, null, -1, -1, false) : 0;
        } else {
            Trace.msgSecurityPrintln("hostnameverifier.automation.ignoremismatch");
            result = 0;
        }
        if (result == 0) {
            Object[] elements = new Object[]{hostname, certHostname};
            hashSet.add(elements);
        }
        return result == 0;
    }

    public static void reset() {
        hashSet.clear();
    }
}

