/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.ref;

import com.sun.deploy.model.Resource;
import com.sun.deploy.model.ResourceProvider;
import com.sun.deploy.net.offline.DeployOfflineManager;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.util.SystemUtils;
import java.io.FilePermission;
import java.io.IOException;
import java.net.URL;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.CodeSigner;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.util.List;

public class CodeRef {
    private final URL jarLocation;
    private final String jarVersion;
    private final CodeSigner[] signers;
    private String checksum;
    private String checksumAlg;
    private final boolean isCodebase;
    private final boolean pack200Enabled;
    private static final AccessControlContext ACC_FILE_INSTANCE;

    public CodeRef(URL jarLocation, String jarVersion, boolean isCodebase, boolean pack200Enabled) {
        this.jarLocation = jarLocation;
        this.jarVersion = jarVersion;
        this.isCodebase = isCodebase;
        this.pack200Enabled = pack200Enabled;
        this.signers = null;
        this.checksum = null;
        this.checksumAlg = null;
    }

    public CodeRef(URL jarLocation, String jarVersion, CodeSigner[] signers, String checksum, String checksumAlg) {
        this.jarLocation = jarLocation;
        this.jarVersion = jarVersion;
        this.isCodebase = false;
        this.pack200Enabled = false;
        this.signers = this.cloneCodeSignerArray(signers);
        this.checksum = checksum;
        String string = this.checksumAlg = checksum == null ? null : "SHA-256";
        if (checksumAlg != null && !checksumAlg.equalsIgnoreCase("SHA-256")) {
            System.out.println("Warning: invalid checksum algorithm in CodeRef constructor: " + checksumAlg);
        }
    }

    public URL getJarLocation() {
        return this.jarLocation;
    }

    public String getJarVersion() {
        return this.jarVersion;
    }

    public boolean equals(Object other) {
        boolean locationMatch;
        if (!(other instanceof CodeRef)) {
            return false;
        }
        CodeRef codeRef = (CodeRef)other;
        boolean bl = this.jarLocation == null ? codeRef.jarLocation == null : (locationMatch = this.jarLocation.toExternalForm().equals(codeRef.jarLocation.toExternalForm()));
        boolean versionMatch = this.jarVersion == null ? codeRef.jarVersion == null : this.jarVersion.equals(codeRef.jarVersion);
        return locationMatch && versionMatch;
    }

    public int hashCode() {
        return (this.jarLocation == null ? 0 : this.jarLocation.toExternalForm().hashCode()) + (this.jarVersion == null ? 0 : this.jarVersion.hashCode());
    }

    public CodeSigner[] getCodeSigners() throws IOException {
        Resource res;
        if (this.signers == null && !this.isCodebase && (res = this.getResource()) != null) {
            return res.getCodeSigners();
        }
        return this.cloneCodeSignerArray(this.signers);
    }

    public Certificate[] getCerts(CodeSigner codeSigner) {
        List<? extends Certificate> certList = codeSigner.getSignerCertPath().getCertificates();
        return certList.toArray(new Certificate[0]);
    }

    private Resource getResource() throws IOException {
        boolean download = !DeployOfflineManager.isForcedOffline();
        int downloadTypes = this.pack200Enabled ? 4352 : 1;
        try {
            return ResourceProvider.get().getResource(this.jarLocation, this.jarVersion, download, downloadTypes, null);
        }
        catch (Exception e) {
            return ResourceProvider.get().getResource(this.jarLocation, this.jarVersion, false, downloadTypes, null);
        }
    }

    public String getChecksum(String algorithm) throws IOException {
        if (this.checksum == null && !this.isCodebase) {
            if (algorithm != null && !algorithm.equalsIgnoreCase("SHA-256")) {
                throw new IOException("Invalid checksum algorithm: " + algorithm);
            }
            final String[] results = new String[]{""};
            try {
                final Resource ce = this.getResource();
                if (ce != null) {
                    AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                        @Override
                        public Void run() throws IOException {
                            results[0] = SystemUtils.getFileChecksum(ce.getDataFile(), "SHA-256");
                            return null;
                        }
                    }, ACC_FILE_INSTANCE);
                }
            }
            catch (Exception e) {
                Trace.ignored(e);
            }
            this.checksum = results[0];
        }
        return this.checksum;
    }

    public String toString() {
        String codeRefString = this.isCodebase ? "\n        codebase: " + this.jarLocation : "\n        jar location: " + this.jarLocation + "\n        jar version: " + this.jarVersion;
        return codeRefString;
    }

    private CodeSigner[] cloneCodeSignerArray(CodeSigner[] signers) {
        if (signers == null) {
            return null;
        }
        CodeSigner[] result = new CodeSigner[signers.length];
        for (int i = 0; i < signers.length; ++i) {
            result[i] = new CodeSigner(signers[i].getSignerCertPath(), signers[i].getTimestamp());
        }
        return result;
    }

    static {
        Permissions perms = new Permissions();
        FilePermission perm = new FilePermission("<<ALL FILES>>", "read,write");
        ((PermissionCollection)perms).add(perm);
        ACC_FILE_INSTANCE = new AccessControlContext(new ProtectionDomain[]{new ProtectionDomain(null, perms)});
    }
}

