/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.net.proxy;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.StringTokenizer;

final class NSRegistry {
    private static final int magic = 1986282561;
    private RandomAccessFile in = null;
    private int rootOffset;
    private int majorVersion;
    private int minorVersion;

    NSRegistry() {
    }

    private Record readRecord(long offset) throws IOException {
        this.in.seek(offset);
        if ((long)this.readInt() != offset) {
            throw new IOException("invalid offset for record [" + offset + "]");
        }
        Record r = new Record();
        r.name = this.readInt();
        r.namelen = this.readUnsignedShort();
        r.type = this.readUnsignedShort();
        r.left = this.readInt();
        r.down = this.readInt();
        r.value = this.readInt();
        r.valuelen = this.readUnsignedInt();
        r.valuebuf = this.readUnsignedInt();
        return r;
    }

    private String readString(long offset, long nchars) throws IOException {
        this.in.seek(offset);
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while ((long)i < nchars) {
            sb.append((char)this.in.read());
            ++i;
        }
        return sb.toString();
    }

    private short readShort() throws IOException {
        int ch2;
        int ch1 = this.in.read();
        if ((ch1 | (ch2 = this.in.read())) < 0) {
            throw new EOFException();
        }
        return (short)((ch2 << 8) + (ch1 << 0));
    }

    private int readUnsignedShort() throws IOException {
        int ch2;
        int ch1 = this.in.read();
        if ((ch1 | (ch2 = this.in.read())) < 0) {
            throw new EOFException();
        }
        return (ch2 << 8) + (ch1 << 0);
    }

    private int readInt() throws IOException {
        int ch4;
        int ch3;
        int ch2;
        int ch1 = this.in.read();
        if ((ch1 | (ch2 = this.in.read()) | (ch3 = this.in.read()) | (ch4 = this.in.read())) < 0) {
            throw new EOFException();
        }
        return (ch4 << 24) + (ch3 << 16) + (ch2 << 8) + (ch1 << 0);
    }

    private long readUnsignedInt() throws IOException {
        int ch4;
        int ch3;
        int ch2;
        int ch1 = this.in.read();
        if ((ch1 | (ch2 = this.in.read()) | (ch3 = this.in.read()) | (ch4 = this.in.read())) < 0) {
            throw new EOFException();
        }
        return (ch4 << 24) + (ch3 << 16) + (ch2 << 8) + (ch1 << 0);
    }

    NSRegistry open(File regFile) {
        if (this.in != null) {
            return this;
        }
        try {
            this.in = new RandomAccessFile(regFile, "r");
            if (this.readInt() != 1986282561) {
                throw new IOException("not a valid Netscape Registry File");
            }
            this.majorVersion = this.readUnsignedShort();
            this.minorVersion = this.readUnsignedShort();
            this.in.skipBytes(4);
            this.rootOffset = this.readInt();
            return this;
        }
        catch (IOException e) {
            return null;
        }
    }

    void close() {
        if (this.in != null) {
            try {
                this.in.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.in = null;
        }
    }

    private String get(Record parent, StringTokenizer pathElts) throws IOException {
        String name = pathElts.nextToken();
        if (pathElts.hasMoreTokens()) {
            int childOffset = parent.down;
            while (childOffset != 0) {
                Record key = this.readRecord(childOffset);
                if (name.equals(this.readString(key.name, key.namelen - 1))) {
                    return this.get(key, pathElts);
                }
                childOffset = key.left;
            }
            return null;
        }
        int entryOffset = parent.value;
        while (entryOffset != 0) {
            Record entry = this.readRecord(entryOffset);
            if (name.equals(this.readString(entry.name, entry.namelen - 1))) {
                return this.readString(entry.value, entry.valuelen - 1L);
            }
            entryOffset = entry.left;
        }
        return null;
    }

    String get(String path) {
        StringTokenizer pathElts = new StringTokenizer(path, "/");
        try {
            return this.get(this.readRecord(this.rootOffset), pathElts);
        }
        catch (IOException e) {
            return null;
        }
    }

    private void dump(String indent, int parentOffset) throws IOException {
        Record key = this.readRecord(parentOffset);
        System.out.println(indent + this.readString(key.name, key.namelen - 1));
        int childOffset = key.down;
        while (childOffset != 0) {
            this.dump(indent + "    ", childOffset);
            childOffset = this.readRecord((long)((long)childOffset)).left;
        }
        int entryOffset = key.value;
        while (entryOffset != 0) {
            Record entry = this.readRecord(entryOffset);
            String name = this.readString(entry.name, entry.namelen - 1);
            String value = this.readString(entry.value, entry.valuelen - 1L);
            System.out.println(indent + "[" + name + " = " + value + "]");
            entryOffset = entry.left;
        }
    }

    void dump() {
        try {
            this.dump("", this.rootOffset);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String toString() {
        String s = this.getClass().getName() + "@" + Integer.toHexString(this.hashCode());
        s = this.in != null ? s + "[version " + this.majorVersion + "." + this.minorVersion + "]" : s + "[closed]";
        return s;
    }

    private static final class Record {
        int name;
        int namelen;
        int type;
        int left;
        int down;
        int value;
        long valuelen;
        long valuebuf;

        private Record() {
        }

        public boolean isKey() {
            return (this.type & 0x10) != 0;
        }

        public boolean isEntry() {
            return !this.isKey();
        }
    }
}

