/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.net.proxy;

import com.sun.deploy.net.proxy.BrowserProxyConfig;
import com.sun.deploy.net.proxy.BrowserProxyInfo;
import com.sun.deploy.net.proxy.MFirefoxProxyConfig;
import com.sun.deploy.net.proxy.MNetscape6ProxyConfig;
import com.sun.deploy.net.proxy.MSystemProxyHandler;

public class MDefaultBrowserProxyConfig
implements BrowserProxyConfig {
    private static String PROXY_PRO_HTTP = "http";
    private static String PROXY_PRO_FTP = "ftp";
    private static String PROXY_PRO_SOCKS = "socks";
    private static String PROXY_PRO_HTTPS = "https";
    private static String PROXY_EMPTY_URL = "";

    @Override
    public BrowserProxyInfo getBrowserProxyInfo() {
        BrowserProxyInfo info = null;
        MFirefoxProxyConfig firefoxProxyConfig = new MFirefoxProxyConfig();
        info = firefoxProxyConfig.getBrowserProxyInfo();
        if (info.getType() == -1) {
            MNetscape6ProxyConfig ns6ProxyConfig = new MNetscape6ProxyConfig();
            info = ns6ProxyConfig.getBrowserProxyInfo();
        }
        return info;
    }

    @Override
    public void getSystemProxy(BrowserProxyInfo info) {
        MSystemProxyHandler mph = new MSystemProxyHandler();
        if (MSystemProxyHandler.hasSystemProxies) {
            String p = mph.getSystemProxy(PROXY_PRO_HTTP, PROXY_EMPTY_URL);
            if (p != null) {
                info.setHttpHost(this.getHost(p));
                info.setHttpPort(this.getPort(p));
            }
            if ((p = mph.getSystemProxy(PROXY_PRO_FTP, PROXY_EMPTY_URL)) != null) {
                info.setFtpHost(this.getHost(p));
                info.setFtpPort(this.getPort(p));
            }
            if ((p = mph.getSystemProxy(PROXY_PRO_HTTPS, PROXY_EMPTY_URL)) != null) {
                info.setHttpsHost(this.getHost(p));
                info.setHttpsPort(this.getPort(p));
            }
            if ((p = mph.getSystemProxy(PROXY_PRO_SOCKS, PROXY_EMPTY_URL)) != null) {
                info.setSocksHost(this.getHost(p));
                info.setSocksPort(this.getPort(p));
            }
        }
    }

    private String getHost(String address) {
        return address.substring(0, address.indexOf(58));
    }

    private int getPort(String address) {
        String port = address.substring(address.lastIndexOf(58) + 1);
        return Integer.parseInt(port);
    }
}

