/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.net.proxy;

import com.sun.deploy.resources.ResourceManager;
import java.util.List;

public final class BrowserProxyInfo {
    private int type = 0;
    private String _httpHost;
    private int _httpPort = -1;
    private String _httpsHost;
    private int _httpsPort = -1;
    private String _ftpHost;
    private int _ftpPort = -1;
    private String _gopherHost;
    private int _gopherPort = -1;
    private String _socksHost;
    private int _socksPort = -1;
    private String[] _overrides = null;
    private String _autoConfigURL;
    private boolean _hintOnly;
    private boolean _isWPADEnabled;

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public String getHttpHost() {
        return this._httpHost;
    }

    public void setHttpHost(String httpHost) {
        this._httpHost = httpHost;
    }

    public int getHttpPort() {
        return this._httpPort;
    }

    public void setHttpPort(int httpPort) {
        this._httpPort = httpPort;
    }

    public String getHttpsHost() {
        return this._httpsHost;
    }

    public void setHttpsHost(String httpsHost) {
        this._httpsHost = httpsHost;
    }

    public int getHttpsPort() {
        return this._httpsPort;
    }

    public void setHttpsPort(int httpsPort) {
        this._httpsPort = httpsPort;
    }

    public String getFtpHost() {
        return this._ftpHost;
    }

    public void setFtpHost(String ftpHost) {
        this._ftpHost = ftpHost;
    }

    public int getFtpPort() {
        return this._ftpPort;
    }

    public void setFtpPort(int ftpPort) {
        this._ftpPort = ftpPort;
    }

    public String getGopherHost() {
        return this._gopherHost;
    }

    public void setGopherHost(String gopherHost) {
        this._gopherHost = gopherHost;
    }

    public int getGopherPort() {
        return this._gopherPort;
    }

    public void setGopherPort(int gopherPort) {
        this._gopherPort = gopherPort;
    }

    public String getSocksHost() {
        return this._socksHost;
    }

    public void setSocksHost(String socksHost) {
        this._socksHost = socksHost;
    }

    public int getSocksPort() {
        return this._socksPort;
    }

    public void setSocksPort(int socksPort) {
        this._socksPort = socksPort;
    }

    public String[] getOverrides() {
        return this._overrides != null ? (String[])this._overrides.clone() : null;
    }

    public String getOverridesString() {
        String noProxyProp = "";
        if (this._overrides != null && this._overrides.length > 0) {
            for (int idx = 0; idx < this._overrides.length; ++idx) {
                noProxyProp = idx != this._overrides.length - 1 ? noProxyProp.concat(this._overrides[idx] + "|") : noProxyProp.concat(this._overrides[idx]);
            }
        }
        return noProxyProp;
    }

    public void setOverrides(String[] overrides) {
        this._overrides = overrides != null ? (String[])overrides.clone() : null;
    }

    public void setOverrides(List<String> overrides) {
        this._overrides = overrides != null ? overrides.toArray(new String[overrides.size()]) : null;
    }

    public String getAutoConfigURL() {
        return this._autoConfigURL;
    }

    public void setAutoConfigURL(String autoConfigURL) {
        this._autoConfigURL = autoConfigURL;
    }

    public void setHintOnly(boolean hintOnly) {
        this._hintOnly = hintOnly;
    }

    public boolean isAutoProxyDetectionEnabled() {
        return this._isWPADEnabled;
    }

    public void setAutoProxyDetectionEnabled(boolean isEnabled) {
        this._isWPADEnabled = isEnabled;
    }

    public boolean isHintOnly() {
        return this._hintOnly;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(ResourceManager.getString("net.proxy.configuration.text"));
        switch (this.type) {
            case 3: {
                sb.append(ResourceManager.getString("net.proxy.type.browser"));
                break;
            }
            case 2: {
                sb.append(ResourceManager.getString("net.proxy.type.auto"));
                sb.append("\n");
                sb.append("     URL: " + this._autoConfigURL);
                break;
            }
            case 1: {
                sb.append(ResourceManager.getString("net.proxy.type.manual"));
                sb.append("\n");
                sb.append("     " + ResourceManager.getString("net.proxy.text"));
                if (this._httpHost != null) {
                    sb.append("http=" + this._httpHost);
                    if (this._httpPort != -1) {
                        sb.append(":" + this._httpPort);
                    }
                }
                if (this._httpsHost != null) {
                    sb.append(",https=" + this._httpsHost);
                    if (this._httpsPort != -1) {
                        sb.append(":" + this._httpsPort);
                    }
                }
                if (this._ftpHost != null) {
                    sb.append(",ftp=" + this._ftpHost);
                    if (this._ftpPort != -1) {
                        sb.append(":" + this._ftpPort);
                    }
                }
                if (this._gopherHost != null) {
                    sb.append(",gopher=" + this._gopherHost);
                    if (this._gopherPort != -1) {
                        sb.append(":" + this._gopherPort);
                    }
                }
                if (this._socksHost != null) {
                    sb.append(",socks=" + this._socksHost);
                    if (this._socksPort != -1) {
                        sb.append(":" + this._socksPort);
                    }
                }
                sb.append("\n");
                sb.append("     " + ResourceManager.getString("net.proxy.override.text"));
                if (this._overrides == null) break;
                boolean first = true;
                for (int idx = 0; idx < this._overrides.length; ++idx) {
                    if (idx != 0) {
                        sb.append(",");
                    }
                    sb.append(this._overrides[idx]);
                }
                break;
            }
            case 0: {
                sb.append(ResourceManager.getString("net.proxy.type.none"));
                break;
            }
            case 4: {
                sb.append(ResourceManager.getString("net.proxy.type.system"));
                break;
            }
            default: {
                sb.append("<Unrecognized Proxy Type>");
            }
        }
        return sb.toString();
    }
}

