/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.net.proxy;

import com.sun.deploy.net.proxy.BrowserProxyInfo;
import com.sun.deploy.net.proxy.ProxyConfigException;
import com.sun.deploy.net.proxy.ProxyHandler;
import com.sun.deploy.net.proxy.ProxyInfo;
import com.sun.deploy.net.proxy.ProxyUnavailableException;
import com.sun.deploy.net.proxy.RemoveCommentReader;
import com.sun.deploy.trace.Trace;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.util.StringTokenizer;

public abstract class AbstractAutoProxyHandler
implements ProxyHandler {
    private BrowserProxyInfo bpi = null;
    protected StringBuffer autoProxyScript = null;
    protected String jsPacScript = null;

    @Override
    public final boolean isSupported(int proxyType) {
        return proxyType == 2;
    }

    @Override
    public final boolean isProxyCacheSupported() {
        return true;
    }

    protected abstract String getBrowserSpecificAutoProxy();

    @Override
    public void init(BrowserProxyInfo info) throws ProxyConfigException {
        Trace.msgNetPrintln("net.proxy.loading.auto");
        if (!this.isSupported(info.getType())) {
            throw new ProxyConfigException("Unable to support proxy type: " + info.getType());
        }
        this.bpi = info;
        this.constructLegacyPACScript_16();
        Trace.msgNetPrintln("net.proxy.loading.done");
    }

    private void constructLegacyPACScript_16() throws ProxyConfigException {
        this.autoProxyScript = new StringBuffer();
        this.autoProxyScript.append("var _mon = new Array('JAN', 'FEB', 'MAR', 'APR', 'MAY', 'JUN', 'JUL', 'AUG', 'SEP', 'OCT', 'NOV', 'DEC');\nvar _day = new Array('SUN', 'MON', 'TUE', 'WED', 'THU', 'FRI', 'SAT');\nfunction _isGmt(i) {\n return typeof i == 'string' && i == 'GMT'; }");
        this.autoProxyScript.append("function _dateRange(day1, month1, year1, day2, month2, year2, gmt){\nif (typeof day1 != 'number' || day1 <= 0 || typeof month1 != 'string' || typeof year1 != 'number' || year1 <= 0\n || typeof day2 != 'number' || day2 <= 0 || typeof month2 != 'string' || typeof year2 != 'number' || year2 <= 0\n || typeof gmt != 'boolean') return false; \nvar m1 = -1, m2 = -1;\nfor (var i=0; i < _mon.length; i++){\nif (_mon[i] == month1)\nm1 = i;\nif (_mon[i] == month2)\nm2 = i;\n}\nvar cur = new Date();\nvar d1 = new Date(year1, m1, day1, 0, 0, 0);\nvar d2 = new Date(year2, m2, day2, 23, 59, 59);\nif (gmt == true)\ncur = new Date(cur.getTime() - cur.getTimezoneOffset() * 60 * 1000);\nreturn ((d1.getTime() <= cur.getTime()) && (cur.getTime() <= d2.getTime()));\n}\nfunction dateRange(p1, p2, p3, p4, p5, p6, p7){\nvar cur = new Date();\nif (typeof p1 == 'undefined')\nreturn false;\nelse if (typeof p2 == 'undefined' || _isGmt(p2))\n{\nif ((typeof p1) == 'string')\nreturn _dateRange(1, p1, cur.getFullYear(), 31, p1, cur.getFullYear(), _isGmt(p2));\nelse if (typeof p1 == 'number' && p1 > 31)\nreturn _dateRange(1, 'JAN', p1, 31, 'DEC', p1, _isGmt(p2));\nelse {\nfor (var i=0; i < _mon.length; i++)\nif (_dateRange(p1, _mon[i], cur.getFullYear(), p1, _mon[i], cur.getFullYear(), _isGmt(p2)))\n return true;\nreturn false;\n}\n}\nelse if (typeof p3 == 'undefined' || _isGmt(p3))\n{\nif ((typeof p1) == 'string')\nreturn _dateRange(1, p1, cur.getFullYear(), 31, p2, cur.getFullYear(), _isGmt(p3));\nelse if (typeof p1 == 'number' && typeof p2 == 'number' && (p1 > 31 || p2 > 31))\nreturn _dateRange(1, 'JAN', p1, 31, 'DEC', p2, _isGmt(p3));\nelse \n{\nif ((typeof p2) == 'string')\n{\nreturn _dateRange(p1, p2, cur.getFullYear(), p1, p2, cur.getFullYear(), _isGmt(p3));\n}\nelse \n{\nfor (var i=0; i < _mon.length; i++)\nif (_dateRange(p1, _mon[i], cur.getFullYear(), p2, _mon[i], cur.getFullYear(), _isGmt(p3)))\nreturn true;\nreturn false;\n}\n}\n}\nelse if (typeof p4 == 'undefined' || _isGmt(p4))\nreturn _dateRange(p1, p2, p3, p1, p2, p3, _isGmt(p4));\nelse if (typeof p5 == 'undefined' || _isGmt(p5))\n{\nif (typeof p2 == 'number')\nreturn _dateRange(1, p1, p2, 31, p3, p4, _isGmt(p5));\nelse \nreturn _dateRange(p1, p2, cur.getFullYear(), p3, p4, cur.getFullYear(), _isGmt(p5))\n}\nelse if (typeof p6 == 'undefined')\nreturn false;\nelse \nreturn _dateRange(p1, p2, p3, p4, p5, p6, _isGmt(p7));\n}");
        this.autoProxyScript.append("function timeRange(p1, p2, p3, p4, p5, p6, p7) {\nif (typeof p1 == 'undefined')\nreturn false;\nelse if (typeof p2 == 'undefined' || _isGmt(p2))\nreturn _timeRange(p1, 0, 0, p1, 59, 59, _isGmt(p2));\nelse if (typeof p3 == 'undefined' || _isGmt(p3))\nreturn _timeRange(p1, 0, 0, p2, 0, 0, _isGmt(p3));\nelse if (typeof p4 == 'undefined')\nreturn false;\nelse if (typeof p5 == 'undefined' || _isGmt(p5))\nreturn _timeRange(p1, p2, 0, p3, p4, 0, _isGmt(p5));\nelse if (typeof p6 == 'undefined')\nreturn false;\nelse \nreturn _timeRange(p1, p2, p3, p4, p5, p6, _isGmt(p7));\n}\nfunction _timeRange(hour1, min1, sec1, hour2, min2, sec2, gmt) {\nif (typeof hour1 != 'number' || typeof min1 != 'number' || typeof sec1 != 'number' \n|| hour1 < 0 || min1 < 0 || sec1 < 0 \n|| typeof hour2 != 'number' || typeof min2 != 'number' || typeof sec2 != 'number' \n|| hour2 < 0 || min2 < 0 || sec2 < 0 \n|| typeof gmt != 'boolean')  return false; \nvar cur = new Date();\nvar d1 = new Date();\nvar d2 = new Date();\nd1.setHours(hour1);\nd1.setMinutes(min1);\nd1.setSeconds(sec1);\nd2.setHours(hour2);\nd2.setMinutes(min2);\nd2.setSeconds(sec2);\nif (gmt == true)\ncur = new Date(cur.getTime() - cur.getTimezoneOffset() * 60 * 1000);\nreturn ((d1.getTime() <= cur.getTime()) && (cur.getTime() <= d2.getTime()));\n}");
        this.autoProxyScript.append("function weekdayRange(wd1, wd2, gmt){\nif (typeof wd1 == 'undefined') \nreturn false;\nelse if (typeof wd2 == 'undefined' || _isGmt(wd2)) \nreturn _weekdayRange(wd1, wd1, _isGmt(wd2)); \nelse \nreturn _weekdayRange(wd1, wd2, _isGmt(gmt)); }\nfunction _weekdayRange(wd1, wd2, gmt) {\nif (typeof wd1 != 'string' || typeof wd2 != 'string' || typeof gmt != 'boolean') return false; \nvar w1 = -1, w2 = -1;\nfor (var i=0; i < _day.length; i++) {\nif (_day[i] == wd1)\nw1 = i;\nif (_day[i] == wd2)\nw2 = i; }\nvar cur = new Date();\nif (gmt == true)\ncur = new Date(cur.getTime() - cur.getTimezoneOffset() * 60 * 1000);\nvar w3 = cur.getDay();\nif (w1 > w2)\nw2 = w2 + 7;\nif (w1 > w3)\nw3 = w3 + 7;\nreturn (w1 <= w3 && w3 <= w2); }");
        this.autoProxyScript.append("function convert_addr(ipchars) {\n    var bytes = ipchars.split('.');\n    var result = ((bytes[0] & 0xff) << 24) |\n                 ((bytes[1] & 0xff) << 16) |\n                 ((bytes[2] & 0xff) <<  8) |\n                  (bytes[3] & 0xff);\n    return result;\n}\n");
        this.autoProxyScript.append("function isInNet(ipaddr, pattern, maskstr) {\n    if (ipaddr == '') return false;\n    var ipPattern = /^(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})$/;\n    var test = ipaddr.match(ipPattern);\n    if (test == null) {\n        ipaddr = dnsResolve(ipaddr);\n        if (ipaddr == '')\n            return false;\n    } else if ((test[1] > 255) || (test[2] > 255) || \n               (test[3] > 255) || (test[4] > 255) ) {\n        return false;\n    }\n    var host = convert_addr(ipaddr);\n    var pat  = convert_addr(pattern);\n    var mask = convert_addr(maskstr);\n    return ((host & mask) == (pat & mask));\n    \n}\n");
        this.autoProxyScript.append(" function alert() {} ");
        this.autoProxyScript.append(this.getBrowserSpecificAutoProxy());
        this.retrieveContentOfPACFile();
        this.autoProxyScript.append(this.jsPacScript);
    }

    private void retrieveContentOfPACFile() throws ProxyConfigException {
        URL autoConfigURL = null;
        try {
            autoConfigURL = new URL(this.bpi.getAutoConfigURL());
        }
        catch (MalformedURLException e) {
            throw new ProxyConfigException("Auto config URL is malformed");
        }
        URLConnection connection = this.getDirectURLConnection(autoConfigURL);
        if (connection != null) {
            if (AbstractAutoProxyHandler.isSupportedINSFile(connection)) {
                URL url = this.getAutoConfigURLFromINS(connection);
                connection = this.getDirectURLConnection(url);
            }
            this.jsPacScript = this.getJSFileFromURL(connection);
        }
    }

    private static boolean isSupportedINSFile(URLConnection connection) {
        boolean result = false;
        String filename = connection.getURL().getFile();
        if (filename != null && filename.toLowerCase().endsWith(".ins")) {
            result = true;
        } else if (connection != null) {
            String mimeType = connection.getContentType();
            result = "application/x-internet-signup".equalsIgnoreCase(mimeType);
        }
        return result;
    }

    @Override
    public abstract ProxyInfo[] getProxyInfo(URL var1) throws ProxyUnavailableException;

    private URLConnection getDirectURLConnection(URL url) throws ProxyConfigException {
        URLConnection conn = null;
        if (url == null) {
            return null;
        }
        try {
            String protocol = url.getProtocol();
            if (protocol.equals("file")) {
                String urlStr = url.toExternalForm();
                int i = urlStr.indexOf(47);
                if (i == -1) {
                    throw new ProxyConfigException("Malformed URL specified:" + url);
                }
                while (urlStr.charAt(++i) == '/') {
                }
                URL canonicalizedURL = new URL("file:/" + urlStr.substring(i));
                conn = canonicalizedURL.openConnection();
            } else {
                try {
                    conn = url.openConnection(Proxy.NO_PROXY);
                }
                catch (NoClassDefFoundError e) {
                    conn = url.openConnection();
                }
            }
        }
        catch (IOException e) {
            throw new ProxyConfigException("Unable to obtain a connection from " + url, e);
        }
        return conn;
    }

    private URL getAutoConfigURLFromINS(URLConnection connection) throws ProxyConfigException {
        URL result = null;
        Trace.msgNetPrintln("net.proxy.auto.download.ins", new Object[]{connection.getURL()});
        String autoConfigURL = null;
        try {
            INIFile insFile = new INIFile(connection.getInputStream());
            autoConfigURL = insFile.readString("URL", "AutoConfigJSURL");
            if (autoConfigURL == null) {
                throw new ProxyConfigException("Unable to locate 'AutoConfigJSURL' in INS file");
            }
            result = new URL(autoConfigURL);
        }
        catch (ProxyConfigException e0) {
            throw e0;
        }
        catch (MalformedURLException e1) {
            throw new ProxyConfigException("Malformed URL specified in INS file: " + autoConfigURL, e1);
        }
        catch (Throwable e2) {
            throw new ProxyConfigException("Unable to obtain INS file from " + connection.getURL(), e2);
        }
        return result;
    }

    private String getJSFileFromURL(URLConnection connection) throws ProxyConfigException {
        Trace.msgNetPrintln("net.proxy.auto.download.js", new Object[]{connection.getURL()});
        try {
            int numchars;
            RemoveCommentReader rin = new RemoveCommentReader(new InputStreamReader(connection.getInputStream()));
            BufferedReader br = new BufferedReader(rin);
            StringWriter sw = new StringWriter();
            char[] buffer = new char[4096];
            while ((numchars = br.read(buffer)) != -1) {
                sw.write(buffer, 0, numchars);
            }
            br.close();
            ((Reader)rin).close();
            sw.close();
            return sw.toString();
        }
        catch (Throwable e) {
            throw new ProxyConfigException("Unable to obtain auto proxy file from " + connection.getURL(), e);
        }
    }

    protected final ProxyInfo[] extractAutoProxySetting(String value) {
        if (value != null) {
            StringTokenizer st = new StringTokenizer(value, ";", false);
            ProxyInfo[] proxyInfoArray = new ProxyInfo[st.countTokens()];
            int index = 0;
            while (st.hasMoreTokens()) {
                String pattern = st.nextToken();
                int i = pattern.indexOf("PROXY");
                if (i != -1) {
                    proxyInfoArray[index++] = new ProxyInfo(pattern.substring(i + 6));
                    continue;
                }
                i = pattern.indexOf("SOCKS");
                if (i != -1) {
                    proxyInfoArray[index++] = new ProxyInfo(null, pattern.substring(i + 6));
                    continue;
                }
                proxyInfoArray[index++] = new ProxyInfo(null, -1);
            }
            return proxyInfoArray;
        }
        return new ProxyInfo[]{new ProxyInfo(null)};
    }

    private static final class INIFile {
        private InputStream _inputStream;

        public INIFile(InputStream inputStream) {
            this._inputStream = inputStream;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String readString(String section, String name) throws IOException {
            String result = null;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(this._inputStream));){
                boolean found = false;
                String buffer = null;
                section = "[" + (String)section + "]";
                name = (String)name + "=";
                do {
                    if ((buffer = reader.readLine()) == null) continue;
                    if (found) {
                        if (buffer.indexOf("[") == 0 && buffer.indexOf("]") > 0) {
                            found = false;
                        } else {
                            if (buffer.indexOf((String)name) != 0) continue;
                            result = buffer.substring(((String)name).length());
                        }
                        break;
                    }
                    if (buffer.indexOf((String)section) != 0) continue;
                    found = true;
                } while (buffer != null);
            }
            return result;
        }
    }
}

