/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.net.cookie;

import com.sun.deploy.config.Config;
import com.sun.deploy.net.cookie.CookieHandler;
import com.sun.deploy.net.cookie.CookieStore;
import com.sun.deploy.net.cookie.CookieUnavailableException;
import com.sun.deploy.net.cookie.HttpCookie;
import com.sun.deploy.net.cookie.NetscapeCookieStore;
import com.sun.deploy.net.cookie.SessionCookieStore;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;

public class GenericCookieHandler
implements CookieHandler {
    private CookieStore sessionCookieStore = new SessionCookieStore();
    private CookieStore persistCookieStore;
    private static GenericCookieHandler instance = null;

    public static synchronized GenericCookieHandler getInstance() {
        if (instance == null) {
            instance = new GenericCookieHandler();
        }
        return instance;
    }

    private GenericCookieHandler() {
        File cookieFile = new File(Config.getUserCookieFile());
        this.persistCookieStore = new NetscapeCookieStore(cookieFile);
    }

    @Override
    public synchronized String getCookieInfo(URL url) throws CookieUnavailableException {
        try {
            if (url.getPath() == null || url.getPath().equals("")) {
                url = new URL(url, "/");
            }
        }
        catch (MalformedURLException e) {
            throw new CookieUnavailableException(e.getMessage(), e);
        }
        return this.getRelevantCookies(url);
    }

    @Override
    public synchronized void setCookieInfo(URL url, String value) throws CookieUnavailableException {
        this.recordCookie(url, value);
    }

    private void recordCookie(URL url, String cookieValue) {
        HttpCookie cookie = HttpCookie.create(url, cookieValue);
        if (cookie == null) {
            return;
        }
        String[] twodot = new String[]{"com", "edu", "net", "org", "gov", "mil", "int"};
        String domain = cookie.getDomain();
        if (domain == null) {
            return;
        }
        domain = domain.toLowerCase();
        String host = url.getHost();
        boolean domainOK = (host = host.toLowerCase()).equals(domain);
        if (!domainOK && host.endsWith(domain)) {
            int dotsNeeded = 2;
            for (int i = 0; i < twodot.length; ++i) {
                if (!domain.endsWith(twodot[i])) continue;
                dotsNeeded = 1;
            }
            int lastChar = domain.length();
            while (lastChar > 0 && dotsNeeded > 0) {
                lastChar = domain.lastIndexOf(46, lastChar - 1);
                --dotsNeeded;
            }
            if (lastChar > 0) {
                domainOK = true;
            }
        }
        if (domainOK) {
            this.recordCookie(cookie);
        }
    }

    private void recordCookie(HttpCookie cookie) {
        if (!this.sessionCookieStore.shouldRejectCookie(cookie)) {
            this.sessionCookieStore.recordCookie(cookie);
        }
        if (!this.persistCookieStore.shouldRejectCookie(cookie)) {
            this.persistCookieStore.recordCookie(cookie);
        }
    }

    private String getRelevantCookies(URL url) {
        String sessionCookie = this.sessionCookieStore.getRelevantCookies(url);
        String persistCookie = this.persistCookieStore.getRelevantCookies(url);
        if (sessionCookie == null) {
            return persistCookie;
        }
        if (persistCookie == null) {
            return sessionCookie;
        }
        return sessionCookie + "; " + persistCookie;
    }

    public static void main(String[] s) {
        try {
            GenericCookieHandler gch = new GenericCookieHandler();
            URL url0 = new URL("http://oracle.com/bar/index.html");
            URL url1 = new URL("http://oracle.com");
            URL url2 = new URL("http://oracle.com/xyz/bar/index.html");
            URL url3 = new URL("https://oracle.com");
            URL url4 = new URL("https://oracle.com/foo/xyz/index.html");
            URL url5 = new URL("https://oracle.com/foobar/xyz/index.html");
            URL url6 = new URL("https://oracle.com/xyz/foo/index.html");
            URL url10 = new URL("http://xyz.sun.com/");
            URL url11 = new URL("http://xyz.sun.com/ammo/index.html");
            System.out.println("Client --> " + url0);
            System.out.println("Cookie    : " + gch.getCookieInfo(url0));
            System.out.println("");
            System.out.println("Server --> " + url0);
            System.out.println("Set-Cookie: CUSTOMER_EXPIRED=WILE_E_COYOTE_EXPIRED; path=/; expires=Wednesday, 09-Nov-99 23:12:40 GMT");
            System.out.println("Set-Cookie: CUSTOMER_NOT_EXPIRED=WILE_E_COYOTE_NOT_EXPIRED; path=/; expires=Wednesday, 09-Nov-03 23:12:40 GMT");
            System.out.println("Set-Cookie: CUSTOMER_SECURE=WILE_E_COYOTE_SECURE; path=/; secure");
            System.out.println("");
            gch.setCookieInfo(url0, "CUSTOMER_EXPIRED=WILE_E_COYOTE_EXPIRED; path=/; expires=Wednesday, 09-Nov-99 23:12:40 GMT");
            gch.setCookieInfo(url0, "CUSTOMER_NOT_EXPIRED=WILE_E_COYOTE_NOT_EXPIRED; path=/; expires=Wednesday, 09-Nov-03 23:12:40 GMT");
            gch.setCookieInfo(url0, "CUSTOMER_SECURE=WILE_E_COYOTE_SECURE; path=/; secure");
            System.out.println("Client --> " + url1);
            System.out.println("Cookie    : " + gch.getCookieInfo(url1));
            System.out.println("");
            System.out.println("Server --> " + url2);
            System.out.println("Set-Cookie: PART_NUMBER=ROCKET_LAUNCHER_0001; path=/");
            System.out.println("");
            gch.setCookieInfo(url2, "PART_NUMBER=ROCKET_LAUNCHER_0001; path=/");
            System.out.println("Client --> " + url1);
            System.out.println("Cookie    : " + gch.getCookieInfo(url1));
            System.out.println("");
            System.out.println("Server --> " + url0);
            System.out.println("Set-Cookie: SHIPPING=FEDEX; path=/foo");
            System.out.println("Set-Cookie: SHIPPING_SECURE=UPS; path=/foo; secure");
            System.out.println("");
            gch.setCookieInfo(url0, "SHIPPING=FEDEX; path=/foo");
            gch.setCookieInfo(url0, "SHIPPING_SECURE=UPS; path=/foo; secure");
            System.out.println("Client --> " + url1);
            System.out.println("Cookie    : " + gch.getCookieInfo(url1));
            System.out.println("");
            System.out.println("Client --> " + url0);
            System.out.println("Cookie    : " + gch.getCookieInfo(url0));
            System.out.println("");
            System.out.println("Client --> " + url3);
            System.out.println("Cookie    : " + gch.getCookieInfo(url3));
            System.out.println("");
            System.out.println("Client --> " + url4);
            System.out.println("Cookie    : " + gch.getCookieInfo(url4));
            System.out.println("");
            System.out.println("Client --> " + url5);
            System.out.println("Cookie    : " + gch.getCookieInfo(url5));
            System.out.println("");
            System.out.println("Client --> " + url6);
            System.out.println("Cookie    : " + gch.getCookieInfo(url6));
            System.out.println("");
            System.out.println("Client --> " + url10);
            System.out.println("Cookie    : " + gch.getCookieInfo(url10));
            System.out.println("");
            System.out.println("Server --> " + url10);
            System.out.println("Set-Cookie: PART_NUMBER=ROCKET_LAUNCHER_0001; path=/");
            System.out.println("");
            gch.setCookieInfo(url10, "PART_NUMBER=ROCKET_LAUNCHER_0001; path=/");
            System.out.println("Client --> " + url10);
            System.out.println("Cookie    : " + gch.getCookieInfo(url10));
            System.out.println("");
            System.out.println("Server --> " + url10);
            System.out.println("Set-Cookie: PART_NUMBER=RIDING_ROCKET_0023; path=/ammo");
            System.out.println("");
            gch.setCookieInfo(url10, "PART_NUMBER=RIDING_ROCKET_0023; path=/ammo");
            System.out.println("Client --> " + url11);
            System.out.println("Cookie    : " + gch.getCookieInfo(url11));
            System.out.println("");
            System.out.println("Client --> " + url10);
            System.out.println("Cookie    : " + gch.getCookieInfo(url10));
            System.out.println("");
            System.out.println(gch.sessionCookieStore.toString());
            System.out.println("");
            System.out.println(gch.persistCookieStore.toString());
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }
}

