/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.net;

import com.sun.applet2.preloader.CancelException;
import com.sun.deploy.Environment;
import com.sun.deploy.cache.Cache;
import com.sun.deploy.cache.CacheEntry;
import com.sun.deploy.cache.JarSigningData;
import com.sun.deploy.cache.MemoryCache;
import com.sun.deploy.config.Config;
import com.sun.deploy.config.Platform;
import com.sun.deploy.jardiff.JarDiffPatcher;
import com.sun.deploy.jardiff.Patcher;
import com.sun.deploy.model.DownloadDelegate;
import com.sun.deploy.model.Resource;
import com.sun.deploy.net.BasicHttpRequest;
import com.sun.deploy.net.CanceledDownloadException;
import com.sun.deploy.net.FailedDownloadException;
import com.sun.deploy.net.HttpDownload;
import com.sun.deploy.net.HttpDownloadHelper;
import com.sun.deploy.net.HttpDownloadListener;
import com.sun.deploy.net.HttpRequest;
import com.sun.deploy.net.HttpResponse;
import com.sun.deploy.net.HttpUtils;
import com.sun.deploy.net.JARSigningException;
import com.sun.deploy.net.MessageHeader;
import com.sun.deploy.net.URLEncoder;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.security.JarVerifier;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.util.SystemUtils;
import com.sun.deploy.util.URLUtil;
import com.sun.deploy.util.VersionID;
import com.sun.deploy.util.VersionString;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.CodeSigner;
import java.security.PrivilegedAction;
import java.security.cert.Certificate;
import java.util.Collections;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.jar.JarFile;

public class DownloadEngine {
    private static final String ARG_ARCH = "arch";
    private static final String ARG_OS = "os";
    private static final String ARG_LOCALE = "locale";
    private static final String ARG_VERSION_ID = "version-id";
    private static final String ARG_JFX_VERSION_ID = "jfx-version-id";
    public static final String ARG_CURRENT_VERSION_ID = "current-version-id";
    private static final String ARG_PLATFORM_VERSION_ID = "platform-version-id";
    private static final String ARG_KNOWN_PLATFORMS = "known-platforms";
    private static final String REPLY_JNLP_VERSION = "x-java-jnlp-version-id";
    private static final String ERROR_MIME_TYPE = "application/x-java-jnlp-error";
    private static final String JARDIFF_MIME_TYPE = "application/x-java-archive-diff";
    private static final String JNLP_MIME_TYPE = "application/x-java-jnlp-file";
    private static final int BASIC_DOWNLOAD_PROTOCOL = 1;
    private static final int VERSION_DOWNLOAD_PROTOCOL = 2;
    private static final int EXTENSION_DOWNLOAD_PROTOCOL = 3;
    private static int BUF_SIZE = 8192;
    private static final String defaultLocaleString = Locale.getDefault().toString();
    private static HttpRequest _httpRequestImpl;
    private static HttpDownload _httpDownloadImpl;
    private static InheritableThreadLocal<Boolean> backgroundUpdateThreadLocal;
    private static ThreadLocal<Boolean> processingState;
    private static final ThreadLocal<Integer> internalUse;
    private static Hashtable<String, URL> redirectURLs;
    private static Hashtable<String, String> knownRedirectHostTable;

    public static boolean haveDownloadInProgress() {
        return processingState.get() != null;
    }

    private static void setDownloadInProgress(boolean state) {
        if (state) {
            processingState.set(Boolean.TRUE);
        } else {
            processingState.set(null);
        }
    }

    public static boolean isBackgroundUpdateRequest() {
        return (Boolean)backgroundUpdateThreadLocal.get();
    }

    public static void _setBackgroundUpdateRequest(boolean background) {
        backgroundUpdateThreadLocal.set(background);
    }

    public static int _incrementInternalUse() {
        int level = DownloadEngine.getInternalUseLevel() + 1;
        SystemUtils.setThreadLocalInt(internalUse, level);
        return level;
    }

    public static void _decrementInternalUse(int myLevel) {
        int level = DownloadEngine.getInternalUseLevel();
        if (level != myLevel) {
            if (Trace.isEnabled(TraceLevel.NETWORK)) {
                Trace.ignored(new Exception("WARNING: unbalanced internalUse level: expect=" + myLevel + " : got=" + level));
            }
            level = myLevel;
        }
        --level;
        if (level < 0) {
            level = 0;
        }
        SystemUtils.setThreadLocalInt(internalUse, level);
    }

    public static boolean isInternalUse() {
        return DownloadEngine.getInternalUseLevel() > 0;
    }

    private static int getInternalUseLevel() {
        return SystemUtils.getThreadLocalInt(internalUse);
    }

    public static boolean isNativeContentType(int type) {
        return DownloadEngine.hasBit(type, 16);
    }

    public static boolean isJarContentType(int type) {
        return DownloadEngine.hasBit(type, 256);
    }

    public static boolean isPackContentType(int type) {
        return DownloadEngine.hasBit(type, 4096);
    }

    private static boolean isVersionContentType(int type) {
        return DownloadEngine.hasBit(type, 65536);
    }

    private static boolean hasBit(int value, int bitMask) {
        return (value & bitMask) == bitMask;
    }

    static boolean isZipFile(String filename) {
        return filename.toLowerCase().endsWith(".zip");
    }

    public static boolean isAlwaysCached(String filename) {
        String name = filename.toLowerCase();
        return name.endsWith(".jar") || name.endsWith(".jarjar") || name.endsWith(".zip");
    }

    static void createRedirectURLEntry(String resourceURLstr, URL redirectURL) {
        redirectURLs.put(resourceURLstr, redirectURL);
    }

    public static URL getRedirectURL(URL resourceURL) {
        return redirectURLs.get(resourceURL.toString());
    }

    public static void addKnownRedirectHost(String origHost, String redirectHost) {
        knownRedirectHostTable.put(origHost, redirectHost);
    }

    public static boolean isKnownRedirectedHost(String origHost, String redirectHost) {
        String knownRedirectHost = knownRedirectHostTable.get(origHost);
        return redirectHost.equals(knownRedirectHost);
    }

    public static URL getKnownRedirectFinalURL(URL resourceURL) {
        URL res = null;
        Object o = MemoryCache.getLoadedResource(resourceURL.toString());
        if (o instanceof Resource) {
            try {
                res = new URL(((Resource)o).getURL());
            }
            catch (MalformedURLException ex) {
                Trace.ignored(ex);
            }
        }
        if (res == null) {
            res = resourceURL;
        }
        return res;
    }

    public static void clearRedirectURLs() {
        redirectURLs.clear();
    }

    private static Resource downloadResourceToTempDir(URL url, String version, URL requestURL, HttpResponse response, HttpDownloadListener hdl, int downloadTypes, DownloadDelegate dd) throws IOException {
        boolean isJar = DownloadEngine.isJarContentType(downloadTypes);
        String tmp = isJar ? "jar_cache" : "tmp_cache";
        File tmpFile = File.createTempFile(tmp, null);
        tmpFile.deleteOnExit();
        String encoding = response.getContentEncoding();
        if (DownloadEngine.isPackContentType(downloadTypes)) {
            encoding = "pack200-gzip";
        }
        boolean uncompress = DownloadEngine.isInternalUse();
        try {
            BufferedInputStream in = response.getInputStream();
            MessageHeader headers = DownloadEngine.getHttpDownloadImpl().download(response.getContentLength(), response.getRequest(), in, encoding, tmpFile, hdl, downloadTypes, uncompress);
            headers = MessageHeader.merge(response.getHeaders(), headers);
            if (!isJar) {
                isJar = HttpUtils.isJarFile(url.toString(), headers.getHeaders());
            }
            Resource resource = DownloadEngine.createTemporaryResource(url, version, requestURL, isJar, response, tmpFile, headers, dd);
            return resource;
        }
        catch (CanceledDownloadException ex) {
            throw new IOException(ex.getLocalizedMessage());
        }
        finally {
            response.disconnect();
        }
    }

    private static Resource createTemporaryResource(final URL url, final String version, URL requestURL, final boolean isJar, final HttpResponse response, final File tmpFile, MessageHeader messageHeader, DownloadDelegate dd) throws IOException {
        if (url == null || tmpFile == null) {
            return null;
        }
        final Map<Object, Object> headers = messageHeader != null ? messageHeader.getHeaders() : Collections.emptyMap();
        final JarFile jarFile = isJar ? JarVerifier.getValidatedJarFile(tmpFile, url, requestURL, version, dd) : null;
        final long timestamp = System.currentTimeMillis();
        return new Resource(){
            JarSigningData jarSigningData = null;

            @Override
            public String getURL() {
                return url.toString();
            }

            @Override
            public String getVersion() {
                return version;
            }

            @Override
            public long getLastModified() {
                return response == null ? 0L : response.getLastModified();
            }

            @Override
            public long getExpirationDate() {
                return response == null ? 0L : response.getExpiration();
            }

            @Override
            public int getContentLength() {
                return response == null ? 0 : response.getContentLength();
            }

            @Override
            public Map<String, List<String>> getHeaders() {
                return headers;
            }

            @Override
            public long getSize() {
                Long v = AccessController.doPrivileged(new PrivilegedAction<Long>(){

                    @Override
                    public Long run() {
                        return tmpFile.length();
                    }
                });
                return v;
            }

            @Override
            public File getDataFile() {
                return tmpFile;
            }

            @Override
            public int getState() {
                return 1;
            }

            @Override
            public JarFile getJarFile() {
                return jarFile;
            }

            public long getValidationTimestamp() {
                return timestamp;
            }

            @Override
            public String getResourceFilename() {
                return tmpFile.getPath();
            }

            @Override
            public boolean isJNLPFile() {
                return false;
            }

            @Override
            public boolean isJarFile() {
                return isJar;
            }

            @Override
            public CodeSigner[] getCodeSigners() {
                JarSigningData jds = this.getJarSigningData();
                if (jds != null) {
                    return jds.getCodeSigners();
                }
                return new CodeSigner[0];
            }

            @Override
            public Certificate[] getCertificates() {
                JarSigningData jds = this.getJarSigningData();
                if (jds != null) {
                    return jds.getCertificates();
                }
                return new Certificate[0];
            }

            private JarSigningData getJarSigningData() {
                JarVerifier jv;
                if (this.jarSigningData == null && (jv = JarVerifier.create(url, version, tmpFile, null)) != null) {
                    try {
                        jv.validate(null);
                        this.jarSigningData = JarSigningData.create(jv);
                    }
                    catch (Exception e) {
                        Trace.ignored(e);
                    }
                }
                return this.jarSigningData;
            }
        };
    }

    public static HttpRequest getHttpRequestImpl() {
        return _httpRequestImpl;
    }

    public static HttpDownload getHttpDownloadImpl() {
        return _httpDownloadImpl;
    }

    public static File applyPatch(File baseFile, File jardiffFile, final URL location, final String newVersion, final DownloadDelegate delegate, String resultFilename) throws FailedDownloadException {
        JarDiffPatcher differ = new JarDiffPatcher();
        File result = new File(resultFilename);
        OutputStream out = null;
        boolean done = false;
        try {
            out = Platform.get().getNativeSandboxBroker().getOutputStream(result, true);
            Patcher.PatchDelegate pd = null;
            if (delegate != null) {
                delegate.patching(location, newVersion, 0);
                pd = new Patcher.PatchDelegate(){

                    @Override
                    public void patching(int percentDone) throws CancelException {
                        delegate.patching(location, newVersion, percentDone);
                    }
                };
            }
            try {
                differ.applyPatch(pd, baseFile.getPath(), jardiffFile.getPath(), out);
            }
            catch (IOException ioe) {
                throw new FailedDownloadException(location, newVersion, ioe);
            }
            done = true;
        }
        catch (IOException ioe) {
            throw new FailedDownloadException(location, newVersion, ioe);
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException ioe) {
                Trace.ignoredException(ioe);
            }
            if (!done) {
                Platform.get().getNativeSandboxBroker().deleteFile(result);
            }
            Platform.get().getNativeSandboxBroker().deleteFile(jardiffFile);
            if (delegate != null && !done) {
                try {
                    delegate.downloadFailed(location, newVersion);
                }
                catch (CancelException ce) {
                    throw new FailedDownloadException(location, newVersion, ce);
                }
            }
        }
        return result;
    }

    public static boolean isJnlpURL(URL url) {
        try {
            HttpResponse response = DownloadEngine.getHttpRequestImpl().doHeadRequest(url);
            return JNLP_MIME_TYPE.equals(response.getContentType());
        }
        catch (IOException ioe) {
            return false;
        }
    }

    static Resource actionDownload(Resource currentCE, final URL href, URL requestURL, String versionString, final DownloadDelegate dd, int contentType, boolean isPlatformRequest, boolean enable) throws IOException {
        boolean retry = false;
        int retryContentType = -1;
        String currentVersion = null;
        if (currentCE != null && versionString != null) {
            long expiration;
            if (currentCE.getVersion() != null && new VersionString(versionString).contains(new VersionID(currentCE.getVersion()))) {
                return currentCE;
            }
            if (Environment.isJavaPlugin() && (expiration = currentCE.getExpirationDate()) != 0L && new Date().after(new Date(expiration))) {
                currentCE = null;
            }
        }
        if (currentCE != null) {
            currentVersion = currentCE.getVersion();
        }
        try {
            int downloadTypes;
            HttpDownloadListener hdl;
            boolean applyJarDiff;
            Date httpLastModifiedDate;
            DownloadEngine.setDownloadInProgress(true);
            HttpRequest httpreq = DownloadEngine.getHttpRequestImpl();
            HttpResponse response = null;
            long cacheEntryLastModified = 0L;
            if (currentCE != null) {
                cacheEntryLastModified = currentCE.getLastModified();
            }
            URL realRequestURL = requestURL;
            if (DownloadEngine.isVersionContentType(contentType)) {
                realRequestURL = URLUtil.getEmbeddedVersionURL(realRequestURL, versionString);
            }
            if (DownloadEngine.isPackContentType(contentType)) {
                realRequestURL = URLUtil.getPack200URL(realRequestURL, false);
            }
            try {
                try {
                    response = httpreq.doGetRequestEX(realRequestURL, cacheEntryLastModified);
                }
                catch (FileNotFoundException fnfe) {
                    if (requestURL.toString().equals(realRequestURL.toString())) {
                        throw fnfe;
                    }
                    response = httpreq.doGetRequestEX(requestURL, cacheEntryLastModified);
                    retry = true;
                    retryContentType = contentType;
                    if (DownloadEngine.isPackContentType(contentType) && (DownloadEngine.isNativeContentType(contentType) || DownloadEngine.isJarContentType(contentType))) {
                        retryContentType &= 0xFFFFEFFF;
                    }
                    if (DownloadEngine.isVersionContentType(contentType)) {
                        retryContentType &= 0xFFFEFFFF;
                    }
                }
            }
            catch (FailedDownloadException fde) {
                throw fde;
            }
            catch (FileNotFoundException fnfe) {
                throw fnfe;
            }
            catch (IOException ioe) {
                Trace.ignoredException(ioe);
                response = httpreq.doGetRequest(requestURL, false);
            }
            int statusCode = response.getStatusCode();
            if (statusCode == 404) {
                throw new FailedDownloadException(href, versionString, new IOException("HTTP response 404"));
            }
            if (statusCode == 304) {
                response.disconnect();
                Resource resource = currentCE;
                return resource;
            }
            int length = response.getContentLength();
            long lastModified = response.getLastModified();
            long expiration = response.getExpiration();
            boolean isJnlp = HttpUtils.isJNLPFile(href.toString(), response.getHeaders());
            if (!isJnlp && Environment.isImportMode() && Environment.getImportModeExpiration() != null && expiration != 0L) {
                Date httpExpirationDate = new Date(expiration);
                if (httpExpirationDate.before(Environment.getImportModeExpiration())) {
                    response.disconnect();
                    Resource resource = null;
                    return resource;
                }
            } else if (!isJnlp && Environment.isImportMode() && Environment.getImportModeTimestamp() != null && lastModified != 0L && (httpLastModifiedDate = new Date(lastModified)).before(Environment.getImportModeTimestamp())) {
                response.disconnect();
                Resource resource = null;
                return resource;
            }
            String downloadVersion = response.getResponseHeader(REPLY_JNLP_VERSION);
            if (versionString != null && downloadVersion == null && Environment.getImportModeCodebaseOverride() != null && new VersionID(versionString).isSimpleVersion()) {
                downloadVersion = versionString;
            }
            if (currentCE != null) {
                if (downloadVersion != null && new VersionString(downloadVersion).contains(currentVersion)) {
                    response.disconnect();
                    Resource resource = currentCE;
                    return resource;
                }
                if (length == currentCE.getContentLength() && lastModified == cacheEntryLastModified && currentVersion == null) {
                    response.disconnect();
                    Resource resource = currentCE;
                    return resource;
                }
            }
            if (dd != null) {
                dd.setTotalSize(length);
            }
            if (downloadVersion == null && (Environment.isJavaPlugin() || DownloadEngine.isVersionContentType(retry ? retryContentType : contentType))) {
                downloadVersion = versionString;
            }
            final String responseVersion = downloadVersion;
            String mimeType = response.getContentType();
            boolean bl = applyJarDiff = mimeType != null && mimeType.equalsIgnoreCase(JARDIFF_MIME_TYPE);
            if (Trace.isEnabled(TraceLevel.NETWORK)) {
                Trace.println(ResourceManager.getString("downloadEngine.serverResponse", String.valueOf(length), new Date(lastModified).toString(), downloadVersion, mimeType), TraceLevel.NETWORK);
            }
            if (mimeType != null && mimeType.equalsIgnoreCase(ERROR_MIME_TYPE)) {
                BufferedInputStream is = response.getInputStream();
                BufferedReader br = new BufferedReader(new InputStreamReader(is));
                String errline = br.readLine();
                br.close();
                throw new FailedDownloadException(requestURL, versionString, new IOException("Error returned: " + errline));
            }
            if (downloadVersion == null && versionString != null && !DownloadEngine.isVersionContentType(retry ? retryContentType : contentType)) {
                throw new FailedDownloadException(href, versionString, new IOException("missing version response from server"));
            }
            if (downloadVersion != null && versionString != null && !isPlatformRequest) {
                if (!new VersionString(versionString).contains(downloadVersion)) {
                    throw new FailedDownloadException(href, versionString, new IOException("bad version response from server:" + downloadVersion));
                }
                VersionID downloadVersionId = new VersionID(downloadVersion);
                if (!downloadVersionId.isSimpleVersion()) {
                    throw new FailedDownloadException(href, versionString, new IOException("bad version response from server:" + downloadVersion));
                }
            }
            HttpDownloadListener httpDownloadListener = hdl = dd == null ? null : new HttpDownloadListener(){

                @Override
                public boolean downloadProgress(int read, int total) throws CancelException {
                    dd.downloading(href, responseVersion, read, total, false);
                    return true;
                }
            };
            if (isJnlp && !Cache.isCacheEnabled()) {
                enable = false;
            }
            int n = downloadTypes = retry ? retryContentType : contentType;
            if (enable) {
                if (HttpUtils.isResourceCacheable(requestURL.toString(), response.getHeaders(), false)) {
                    CacheEntry errline = Cache.downloadResourceToCache(href, downloadVersion, response, hdl, dd, requestURL, applyJarDiff, downloadTypes);
                    return errline;
                }
                Resource errline = DownloadEngine.downloadResourceToTempDir(href, downloadVersion, requestURL, response, hdl, downloadTypes, dd);
                return errline;
            }
            CacheEntry tce = Cache.downloadResourceToTempFile(href, downloadVersion, response, hdl, dd, requestURL, applyJarDiff, retry ? retryContentType : contentType);
            tce.setBusy(1);
            tce.setIncomplete(1);
            tce.updateIndexHeaderOnDisk();
            CacheEntry cacheEntry = tce;
            return cacheEntry;
        }
        catch (Exception e) {
            if (e instanceof JARSigningException) {
                throw (JARSigningException)e;
            }
            if (e instanceof FailedDownloadException) {
                throw (FailedDownloadException)e;
            }
            Trace.ignored(e);
            throw new FailedDownloadException(requestURL, versionString, e);
        }
        finally {
            DownloadEngine.setDownloadInProgress(false);
        }
    }

    private static void addURLArgument(StringBuffer sb, String key, String value) {
        try {
            sb.append(URLEncoder.encode(key, "UTF-8"));
            sb.append('=');
            sb.append(URLEncoder.encode(value, "UTF-8"));
            sb.append('&');
        }
        catch (UnsupportedEncodingException uee) {
            Trace.ignoredException(uee);
        }
    }

    public static URL getRequestURL(URL href, String version, String currentVersion, boolean isPlatformRequest, String knownPlatforms) {
        int kind = version == null ? 1 : 2;
        return DownloadEngine.getRequestURL(href, version, currentVersion, isPlatformRequest, knownPlatforms, kind);
    }

    private static URL getRequestURL(URL href, String versionString, String currentVersion, boolean isPlatformRequest, String knownPlatforms, int kind, String jfxVerRequest) {
        StringBuffer args = new StringBuffer();
        if (currentVersion == null && versionString != null) {
            currentVersion = Cache.getCacheEntryVersion(href);
        }
        if (versionString != null && kind == 2) {
            DownloadEngine.addURLArgument(args, ARG_VERSION_ID, versionString);
            if (currentVersion != null) {
                DownloadEngine.addURLArgument(args, ARG_CURRENT_VERSION_ID, currentVersion);
            }
        }
        if (versionString != null && kind == 3) {
            if (isPlatformRequest) {
                DownloadEngine.addURLArgument(args, ARG_PLATFORM_VERSION_ID, versionString);
            } else {
                DownloadEngine.addURLArgument(args, ARG_VERSION_ID, versionString);
            }
            DownloadEngine.addURLArgument(args, ARG_ARCH, Config.getOSArch());
            DownloadEngine.addURLArgument(args, ARG_OS, Config.getOSName());
            DownloadEngine.addURLArgument(args, ARG_LOCALE, defaultLocaleString);
            if (knownPlatforms != null) {
                DownloadEngine.addURLArgument(args, ARG_KNOWN_PLATFORMS, knownPlatforms);
            }
            if (jfxVerRequest != null) {
                DownloadEngine.addURLArgument(args, ARG_JFX_VERSION_ID, jfxVerRequest);
            }
        }
        if (args.length() > 0) {
            args.setLength(args.length() - 1);
        }
        if (args.length() > 0) {
            args.insert(0, '?');
        }
        try {
            return new URL(href.getProtocol(), href.getHost(), href.getPort(), href.getFile() + args);
        }
        catch (MalformedURLException mue) {
            Trace.ignoredException(mue);
            return null;
        }
    }

    public static URL getRequestURL(URL href, String versionString, String currentVersion, boolean isPlatformRequest, String knownPlatforms, int kind) {
        return DownloadEngine.getRequestURL(href, versionString, currentVersion, isPlatformRequest, knownPlatforms, kind, null);
    }

    public static Resource downloadResource(Resource ce, URL resourceURL, String versionString, DownloadDelegate dd, boolean isPlatformRequest, String knownPlatforms, int contentType, boolean enable) throws IOException {
        int type = 1;
        if (knownPlatforms != null) {
            type = 3;
        } else if (versionString != null) {
            type = 2;
        }
        URL requestURL = DownloadEngine.getRequestURL(resourceURL, versionString, null, isPlatformRequest, knownPlatforms, type);
        return DownloadEngine.actionDownload(ce, resourceURL, requestURL, versionString, dd, contentType, isPlatformRequest, enable);
    }

    public static String getAvailableVersion(URL url, String requestVersion, boolean isPlatform, String platforms) {
        return DownloadEngine.getAvailableVersion(url, requestVersion, isPlatform, platforms, null);
    }

    public static String getAvailableVersion(URL url, String requestVersion, boolean isPlatform, String platforms, String reqestJfxVersion) {
        int type = platforms != null ? 3 : 2;
        URL requestURL = DownloadEngine.getRequestURL(url, requestVersion, null, isPlatform, platforms, type, reqestJfxVersion);
        HttpRequest httpreq = DownloadEngine.getHttpRequestImpl();
        String replyVersion = null;
        try {
            HttpResponse response = httpreq.doGetRequest(requestURL);
            if (response != null) {
                replyVersion = response.getResponseHeader(REPLY_JNLP_VERSION);
                response.disconnect();
            }
        }
        catch (Throwable t) {
            Trace.ignored(t);
        }
        return replyVersion;
    }

    static boolean isJarHeaderValid(byte[] buf) {
        return DownloadEngine.get32(buf, 0) == 67324752L;
    }

    private static int get16(byte[] b, int off) {
        return b[off] & 0xFF | (b[off + 1] & 0xFF) << 8;
    }

    private static long get32(byte[] b, int off) {
        return (long)DownloadEngine.get16(b, off) | (long)DownloadEngine.get16(b, off + 2) << 16;
    }

    static {
        backgroundUpdateThreadLocal = new InheritableThreadLocal<Boolean>(){

            @Override
            protected Boolean initialValue() {
                return Boolean.FALSE;
            }
        };
        processingState = new ThreadLocal();
        internalUse = new ThreadLocal();
        redirectURLs = new Hashtable();
        knownRedirectHostTable = new Hashtable();
        _httpRequestImpl = new BasicHttpRequest();
        _httpDownloadImpl = new HttpDownloadHelper(_httpRequestImpl);
    }
}

