/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.config;

import com.sun.deploy.Environment;
import com.sun.deploy.config.Config;
import com.sun.deploy.config.DefaultConfig;
import com.sun.deploy.config.JREInfo;
import com.sun.deploy.config.Platform;
import com.sun.deploy.net.proxy.NSPreferences;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.util.SearchPath;
import com.sun.deploy.util.SystemPropertyUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class UnixPlatform
extends Platform {
    private String _userHome;
    private String _systemHome;
    private String _osHome;
    private static final int[] DEFAULT_SIZES = new int[]{32, 16, 48, 64};
    private UnixWebJavaSwitch javaSwitch = new UnixWebJavaSwitch();
    private static final int ARGS_LIST_CAPACITY = 32;
    private static final int ARG_CAPACITY = 64;
    private static final char BACKSLASH = '\\';
    private static final char SINGLE_QUOTE = '\'';
    private static final char DOUBLE_QUOTE = '\"';
    private static final char TAB = '\t';
    private static final char LINEFEED = '\n';
    private static final char RETURN = '\r';
    private static final char SPACE = ' ';

    public UnixPlatform() {
        this.loadDeployNativeLib();
    }

    @Override
    public void loadDeployNativeLib() {
        try {
            System.load(Environment.getDeploymentHome() + File.separator + this.getNativeLibPath());
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            // empty catch block
        }
    }

    @Override
    public String getNativeLibPath() {
        return "lib" + File.separator + "libdeploy.so";
    }

    public String escapeBackslashAndQuoteString(String in) {
        return in;
    }

    @Override
    public String getUserHome() {
        if (this._userHome == null) {
            String profile = SystemPropertyUtil.getProperty("javaplugin.user.profile");
            if (profile == null || profile.trim().equals("")) {
                profile = SystemPropertyUtil.getProperty("user.home");
            }
            this._userHome = profile + (profile.endsWith(File.separator) ? "" : File.separator) + ".java" + File.separator + "deployment";
        }
        return this._userHome;
    }

    @Override
    public String getSystemHome() {
        if (this._systemHome == null) {
            this._systemHome = File.separator + "etc" + File.separator + ".java" + File.separator + "deployment";
        }
        return this._systemHome;
    }

    @Override
    public String getOSHome() {
        if (this._osHome == null) {
            this._osHome = File.separator + "etc";
        }
        return this._osHome;
    }

    @Override
    public boolean isBrowserFireFox() {
        return false;
    }

    @Override
    public boolean isNativeModalDialogUp() {
        return false;
    }

    @Override
    public String getRoamingUserHome() {
        return null;
    }

    @Override
    public String getPlatformExtension() {
        return "";
    }

    @Override
    public String getLibraryPrefix() {
        return "lib";
    }

    @Override
    public String getLibrarySufix() {
        return ".so";
    }

    @Override
    public int installShortcut(String path, String appName, String description, String appPath, String args, String directory, String iconPath) {
        return 0;
    }

    @Override
    public int updateShortcut(String path, String target) {
        return 0;
    }

    @Override
    public String getShortcutJnlpName(String shortcutPath) {
        Properties props = new Properties();
        File shortcutFile = new File(shortcutPath);
        if (shortcutFile.exists()) {
            try {
                props.load(new FileInputStream(shortcutFile));
            }
            catch (IOException iOException) {
                // empty catch block
            }
            String cmd_key = "Exec";
            String cmd_args = (String)props.get("Exec");
            if (cmd_args == null) {
                return null;
            }
            int pos = cmd_args.lastIndexOf(47);
            if (pos != -1 && cmd_args.length() - ++pos > 0) {
                String jnlpName = cmd_args.substring(pos);
                return jnlpName;
            }
        }
        return null;
    }

    @Override
    public boolean useAltFileSystemView() {
        return false;
    }

    @Override
    public boolean isLocalInstallSupported() {
        return this.getEnv("GNOME_DESKTOP_SESSION_ID") != null || new File("/usr/share/gnome").exists() || this.getEnv("DBUS_SESSION_BUS_ADDRESS") != null || this.getEnv("_DBUS_SESSION_BUS_ADDRESS") != null;
    }

    @Override
    public boolean systemLookAndFeelDefault() {
        return this.getEnv("GNOME_DESKTOP_SESSION_ID") != null || new File("/usr/share/gnome").exists() || this.getEnv("DBUS_SESSION_BUS_ADDRESS") != null || this.getEnv("_DBUS_SESSION_BUS_ADDRESS") != null;
    }

    @Override
    public String getSessionSpecificString() {
        String sessionString = this.getEnv("DISPLAY");
        if (sessionString != null) {
            return sessionString;
        }
        return "";
    }

    @Override
    public String getPlatformSpecificJavaName() {
        return "java";
    }

    public native String getEnv(String var1);

    @Override
    public String getBrowserPath() {
        File browserPath;
        File browser;
        String path = Config.getStringProperty("deployment.browser.path");
        if (path != null && path.length() > 0 && !(browser = new File(path)).exists()) {
            path = null;
        }
        if ((path == null || path.length() == 0) && (browserPath = SearchPath.findBrowser(this.getEnv("PATH"))) != null) {
            path = browserPath.getAbsolutePath();
        }
        return path;
    }

    @Override
    public String getFireFoxUserProfileDirectory() {
        return this.getMozillaUserProfileDirectory();
    }

    @Override
    public String getMozillaUserProfileDirectory() {
        String mozillaUserProfileDir = null;
        try {
            String homeDir = System.getProperty("user.home");
            File regFile = new File(homeDir + "/.mozilla/appreg");
            if (regFile.exists()) {
                mozillaUserProfileDir = NSPreferences.getNS6UserProfileDirectory(regFile);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return mozillaUserProfileDir;
    }

    private String getJControlCommand() {
        Object cmd = Environment.getJavaHome();
        if (!((String)cmd).endsWith(File.separator)) {
            cmd = (String)cmd + File.separator;
        }
        cmd = (String)cmd + "bin" + File.separator + "jcontrol";
        return cmd;
    }

    @Override
    public void openControlPanel(String[] args) {
        try {
            ArrayList<String> list = new ArrayList<String>();
            String path = this.getJControlCommand();
            list.add(path);
            for (String arg : args) {
                list.add(arg);
            }
            ProcessBuilder pb = new ProcessBuilder(list);
            Process p = pb.start();
            Trace.println("launching jcontrol", TraceLevel.BASIC);
            p.waitFor();
        }
        catch (IOException ioe) {
            Trace.ignoredException(ioe);
        }
        catch (InterruptedException ie) {
            Trace.ignoredException(ie);
        }
    }

    private File findOpenUtility(String path) {
        ArrayList<String> PREFERRED_UTILITIES = new ArrayList<String>();
        String curDesktop = this.getEnv("XDG_CURRENT_DESKTOP");
        if (curDesktop != null) {
            if (curDesktop.toLowerCase().contains("gnome")) {
                PREFERRED_UTILITIES.add("gnome-open");
            } else if (curDesktop.toLowerCase().contains("kde")) {
                PREFERRED_UTILITIES.add("kde-open");
            }
        }
        PREFERRED_UTILITIES.add("xdg-open");
        return SearchPath.findOne(path, PREFERRED_UTILITIES);
    }

    private boolean executeProcess(String[] cmd) {
        boolean result = false;
        if (cmd == null) {
            return false;
        }
        try {
            Trace.println("Invoking process with: \n     " + this.argsFromArray(cmd), TraceLevel.BASIC);
            Process process = Runtime.getRuntime().exec(cmd);
            result = process != null;
        }
        catch (IOException ioe) {
            Trace.ignoredException(ioe);
        }
        return result;
    }

    public String argsFromArray(String[] args) {
        StringBuffer result = new StringBuffer(2048);
        for (int i = 0; i < args.length; ++i) {
            result.append(args[i]).append(' ');
        }
        return result.toString().trim();
    }

    public String[] argsFromString(String args) {
        ArrayList<String> list = new ArrayList<String>(32);
        StringBuffer token = new StringBuffer(64);
        boolean matchDouble = false;
        boolean matchSingle = false;
        int length = 0;
        String[] result = new String[]{};
        if (args != null) {
            length = args.length();
        }
        block6: for (int i = 0; i < length; ++i) {
            char ch = args.charAt(i);
            switch (ch) {
                case '\\': {
                    if (++i >= length) continue block6;
                    token.append(args.charAt(i));
                    continue block6;
                }
                case '\'': {
                    if (matchDouble) {
                        token.append(ch);
                    }
                    matchSingle = !matchSingle;
                    continue block6;
                }
                case '\"': {
                    if (matchSingle) {
                        token.append(ch);
                    }
                    matchDouble = !matchDouble;
                    continue block6;
                }
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    if (matchSingle || matchDouble) {
                        token.append(ch);
                        continue block6;
                    }
                    if (token.length() <= 0) continue block6;
                    list.add(token.toString());
                    token.delete(0, token.length());
                    continue block6;
                }
                default: {
                    token.append(ch);
                }
            }
        }
        if (token.length() > 0) {
            list.add(token.toString());
        }
        return list.toArray(result);
    }

    private String[] getBasicBrowserArgs(File browser, String url) {
        String[] result = new String[]{browser.getAbsolutePath(), url};
        return result;
    }

    private String[] getExtendedBrowserArgs(File browser, String url) {
        boolean replaced = false;
        String[] args = this.argsFromString(Config.getStringProperty("deployment.browser.args"));
        String[] result = null;
        for (int i = 0; i < args.length; ++i) {
            int start = 0;
            int index = -1;
            index = args[i].indexOf("%u", start);
            while (index >= 0) {
                args[i] = args[i].substring(start, index) + url + args[i].substring(index + 2);
                start = index + 2;
                index = args[i].indexOf("%u", start);
                replaced = true;
            }
        }
        if (replaced) {
            result = new String[args.length + 1];
            System.arraycopy(args, 0, result, 1, args.length);
            result[0] = browser.getAbsolutePath();
        }
        return result;
    }

    @Override
    public String getDebugJavaPath(String path) {
        return path;
    }

    @Override
    public boolean isPlatformIconType(String name) {
        return this.isLocalInstallSupported() && (name.toLowerCase().endsWith(".png") || name.toLowerCase().endsWith(".ico"));
    }

    @Override
    public List<JREInfo> getInstalledJREList() {
        return this.getPublicJres();
    }

    @Override
    public String getBrowserHomePath() {
        return Environment.getenv("MOZILLA_HOME");
    }

    @Override
    public String getUserHomeOverride() {
        return null;
    }

    @Override
    public void setUserHomeOverride(String userHome) {
    }

    public void init() {
    }

    @Override
    public void onSave(Object info) {
    }

    @Override
    public void onLoad(Object info) {
    }

    @Override
    public void resetJavaHome() {
    }

    @Override
    public String getSecureLauncherName() {
        return "jweblauncher";
    }

    @Override
    void setDefaultConfigProperties(DefaultConfig inConfig) {
        inConfig.setProperty("deployment.browser.path", "");
        inConfig.setProperty("deployment.browser.args", "-remote openURL(%u,new-window)");
    }

    public List<JREInfo> getPublicJres() {
        String version = System.getProperty("java.version");
        int versionIdx = version.lastIndexOf("-");
        ArrayList<JREInfo> jreList = new ArrayList<JREInfo>();
        if (versionIdx != -1) {
            version = version.substring(0, versionIdx);
        }
        JREInfo jre = new JREInfo(null, version, null, Environment.getJavaHome(), "", Config.getOSName(), Config.getOSArch(), true, true);
        jreList.add(jre);
        return jreList;
    }

    @Override
    public String getLongPathName(String path) {
        return path;
    }

    @Override
    public boolean samePaths(String path1, String path2) {
        try {
            return new File(path1).getCanonicalPath().equals(new File(path2).getCanonicalPath());
        }
        catch (Throwable t) {
            return false;
        }
    }

    @Override
    public boolean canBecomeAdmin() {
        return this.hasAdminPrivileges();
    }

    @Override
    public boolean hasAdminPrivileges() {
        return false;
    }

    @Override
    public void handleUserResponse(int response) {
    }

    @Override
    public boolean shouldPromptForAutoCheck() {
        return false;
    }

    @Override
    public String toExecArg(String path) {
        return path;
    }

    public boolean showURL(String url) {
        return false;
    }

    @Override
    public int[] getIconSizes() {
        return (int[])DEFAULT_SIZES.clone();
    }

    @Override
    public int getSystemShortcutIconSize(boolean isDesktop) {
        return isDesktop ? 32 : 16;
    }

    @Override
    public String getSystemJavawsPath() {
        return Environment.getJavawsCommand();
    }

    @Override
    public long getNativePID() {
        return this.getPlatformPID();
    }

    @Override
    public String getDefaultSystemCache() {
        return null;
    }

    @Override
    public boolean canAutoDownloadJRE() {
        return true;
    }

    @Override
    public void addRemoveProgramsAdd(String jnlpURL, String title, String icon, String vendor, String description, String homepage, boolean sysCache) {
    }

    @Override
    public void addRemoveProgramsRemove(String title, boolean sysCache) {
    }

    @Override
    public void cacheSecurityBaseline(String familyVersion, String securityBaseline) {
    }

    @Override
    public void cacheCurrentConfig(Properties p) {
        try {
            File home = new File(System.getProperty("user.home"));
            File outdir = new File(home, ".java/deployment");
            File outfile = new File(outdir, "config.cache");
            outdir.mkdirs();
            outfile.delete();
            PrintStream ps = new PrintStream(outfile, "UTF-8");
            ps.println("#This file is autogenerated. Do not edit it manually.");
            ps.println("#To update Java deployment configuration use jcontrol utility");
            ps.println("# or update deployment.properties.");
            for (String string : p.keySet()) {
                ps.println(string + "=" + p.getProperty(string));
            }
            ps.close();
        }
        catch (Exception ex) {
            Trace.ignored(ex);
        }
    }

    @Override
    public Platform.WebJavaSwitch getWebJavaSwitch() {
        return this.javaSwitch;
    }

    @Override
    public native int getPlatformMaxCommandLineLength();

    protected native long getPlatformPID();

    @Override
    public String getLoadedNativeLibPath(String lib) {
        throw new UnsupportedOperationException("Not yet supported on Unix platform.");
    }

    @Override
    public native boolean isGTKAvailable(int var1, int var2, int var3);

    public static final class UnixWebJavaSwitch
    extends Platform.WebJavaSwitch {
        private UnixWebJavaSwitch() {
        }

        @Override
        protected boolean isSystemWebJavaEnabled() {
            return true;
        }

        @Override
        protected void setSystemWebJavaEnabled(boolean enabled) {
        }
    }
}

