/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.config;

import com.sun.deploy.Environment;
import com.sun.deploy.config.AutoUpdater;
import com.sun.deploy.config.Config;
import com.sun.deploy.config.DefaultConfig;
import com.sun.deploy.config.JREInfo;
import com.sun.deploy.config.OSType;
import com.sun.deploy.config.PlatformFactory;
import com.sun.deploy.nativesandbox.NativeSandboxBroker;
import com.sun.deploy.nativesandbox.NativeSandboxJNLPService;
import com.sun.deploy.nativesandbox.NoSandboxBroker;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.util.IcoEncoder;
import com.sun.deploy.util.IconEncoder;
import com.sun.deploy.util.SecurityBaseline;
import java.awt.AWTPermission;
import java.awt.Desktop;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.BasicPermission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.PropertyPermission;

public abstract class Platform {
    protected static final boolean DEBUG = Config.getDebug();
    private static Platform _platform;
    private static final AccessControlContext ACC_SHOW_INSTANCE;
    private static final AccessControlContext ACC_FILEPROP_INSTANCE;
    private static final AccessControlContext ACC_FILE_INSTANCE;
    protected static final String UPGRADE_FILENAME = "CacheUpgrade.properties";
    protected AutoUpdater auInstance;
    protected IconEncoder ieInstance;
    protected NativeSandboxBroker sandboxBroker;

    public static void setInstance(Platform platform) {
        _platform = platform;
    }

    public static Platform get() {
        if (_platform == null) {
            Platform.setInstance(PlatformFactory.newInstance());
        }
        return _platform;
    }

    public abstract void addRemoveProgramsAdd(String var1, String var2, String var3, String var4, String var5, String var6, boolean var7);

    public abstract void cacheSecurityBaseline(String var1, String var2);

    public abstract String getNativeLibPath();

    public abstract void addRemoveProgramsRemove(String var1, boolean var2);

    public abstract boolean canAutoDownloadJRE();

    public boolean canUseAlternateJREs() {
        return true;
    }

    public abstract String getBrowserPath();

    public abstract String getBrowserHomePath();

    public abstract String getDefaultSystemCache();

    public abstract String getFireFoxUserProfileDirectory();

    public abstract boolean canBecomeAdmin();

    public abstract boolean hasAdminPrivileges();

    public abstract List<JREInfo> getInstalledJREList();

    public abstract String getLibrarySufix();

    public abstract String getLibraryPrefix();

    public abstract String getMozillaUserProfileDirectory();

    public abstract long getNativePID();

    public abstract String getSessionSpecificString();

    public abstract String getSystemJavawsPath();

    public abstract int[] getIconSizes();

    public abstract int getSystemShortcutIconSize(boolean var1);

    public abstract int installShortcut(String var1, String var2, String var3, String var4, String var5, String var6, String var7);

    public abstract int updateShortcut(String var1, String var2);

    public abstract String getShortcutJnlpName(String var1);

    public boolean isAutoUpdateAvailable() {
        return false;
    }

    public abstract boolean isBrowserFireFox();

    public abstract boolean isLocalInstallSupported();

    public abstract boolean isNativeModalDialogUp();

    public abstract boolean isPlatformIconType(String var1);

    public abstract void loadDeployNativeLib();

    public abstract void setUserHomeOverride(String var1);

    public boolean updateJava(String updateURL) {
        return this.showDocument(updateURL);
    }

    public boolean showDocument(URL url) {
        if (url == null) {
            return false;
        }
        return this.showDocument(url.toExternalForm());
    }

    public boolean showDocument(final String url) {
        for (int i = 0; i < url.length(); ++i) {
            char c = url.charAt(i);
            if (' ' >= c || c >= '~') {
                return false;
            }
            if (c != '\\' && c != '\"') continue;
            return false;
        }
        try {
            return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

                @Override
                public Boolean run() {
                    try {
                        Desktop.getDesktop().browse(new URL(url).toURI());
                        return Boolean.TRUE;
                    }
                    catch (Exception ioe) {
                        Trace.ignoredException(ioe);
                        return Boolean.FALSE;
                    }
                }
            }, ACC_SHOW_INSTANCE);
        }
        catch (Exception ioe) {
            Trace.ignoredException(ioe);
            return false;
        }
    }

    public abstract void openControlPanel(String[] var1);

    public boolean getSponsorOffersDisabledSettings() {
        return false;
    }

    public void enableSponsorOffering(boolean enable) {
    }

    public void enableRoamingProfile(boolean enable) {
    }

    public abstract boolean systemLookAndFeelDefault();

    public abstract String getUserHome();

    public String getLocalStorageDir() {
        return this.getUserHome();
    }

    public abstract String getRoamingUserHome();

    public abstract void cacheCurrentConfig(Properties var1);

    public abstract String getUserHomeOverride();

    public abstract String getOSHome();

    public abstract String getSystemHome();

    public abstract String getPlatformSpecificJavaName();

    public abstract String getPlatformExtension();

    public abstract String getDebugJavaPath(String var1);

    public abstract String getLongPathName(String var1);

    public abstract boolean samePaths(String var1, String var2);

    public abstract int getPlatformMaxCommandLineLength();

    public abstract boolean useAltFileSystemView();

    public abstract String toExecArg(String var1);

    public abstract void onLoad(Object var1);

    public abstract void onSave(Object var1);

    public abstract boolean shouldPromptForAutoCheck();

    public abstract void handleUserResponse(int var1);

    public abstract void resetJavaHome();

    public abstract String getSecureLauncherName();

    public String findSecureLauncher(File targetHome) {
        String launcherName = this.getSecureLauncherName();
        Object path = targetHome == null ? Environment.getDeploymentHomePath() : targetHome.toString();
        if (!((String)path).endsWith(File.separator)) {
            path = (String)path + File.separator;
        }
        if (new File((String)(path = (String)path + "bin" + File.separator + launcherName)).exists()) {
            return path;
        }
        return null;
    }

    void setDefaultConfigProperties(DefaultConfig aThis) {
    }

    public String getJucheckPath() {
        return null;
    }

    public String getPlatformNativeEncoding() {
        return "UTF-8";
    }

    public void storeCacheUpgradeInfo(final Properties info) {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Void run() throws IOException {
                    if (info == null) {
                        File statusFile = new File(Platform.this.getUserHome(), Platform.UPGRADE_FILENAME);
                        if (statusFile.exists()) {
                            statusFile.delete();
                        }
                        return null;
                    }
                    try (OutputStream os = null;){
                        Properties p = Platform.this.getCacheUpgradeProperties();
                        p.putAll((Map<?, ?>)info);
                        File statusFile = new File(Platform.this.getUserHome(), Platform.UPGRADE_FILENAME);
                        if (!statusFile.exists()) {
                            statusFile.createNewFile();
                        }
                        os = new FileOutputStream(statusFile);
                        p.store(os, "");
                    }
                    return null;
                }
            }, ACC_FILEPROP_INSTANCE);
        }
        catch (PrivilegedActionException e) {
            Trace.ignored(e, true);
        }
        catch (Exception ex) {
            Trace.ignored(ex);
        }
    }

    public Properties getCacheUpgradeInfo(String[] names) {
        Properties all = this.getCacheUpgradeProperties();
        Properties ret = new Properties();
        for (int i = 0; i < names.length; ++i) {
            String v = all.getProperty(names[i]);
            if (v == null) continue;
            ret.put(names[i], v);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Properties getCacheUpgradeProperties() {
        Properties p = new Properties();
        InputStream is = null;
        try {
            final File statsFile = new File(this.getUserHome(), UPGRADE_FILENAME);
            is = AccessController.doPrivileged(new PrivilegedExceptionAction<InputStream>(){

                @Override
                public InputStream run() throws IOException {
                    if (statsFile.isFile()) {
                        return new FileInputStream(statsFile);
                    }
                    return null;
                }
            }, ACC_FILE_INSTANCE);
            if (is != null) {
                p.load(is);
            }
        }
        catch (PrivilegedActionException e) {
            Trace.ignored(e, true);
        }
        catch (Exception ioe) {
            Trace.ignored(ioe);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception e) {
                    Trace.ignored(e);
                }
            }
        }
        return p;
    }

    public abstract String getLoadedNativeLibPath(String var1);

    public synchronized AutoUpdater getAutoUpdater() {
        if (this.auInstance == null) {
            this.auInstance = new AutoUpdater();
        }
        return this.auInstance;
    }

    public synchronized IconEncoder getIconEncoder() {
        if (this.ieInstance == null) {
            this.ieInstance = new IcoEncoder();
        }
        return this.ieInstance;
    }

    public String getPlatformIconType() {
        return "ico";
    }

    public boolean isGTKAvailable(int major, int minor, int micro) {
        return false;
    }

    public String getDefaultIconPath() {
        return null;
    }

    public Properties getPendingConfigProperties() {
        return null;
    }

    public static void validateProcessBuilder(List<String> commands) {
        int maxLength = Config.getMaxCommandLineLength();
        if (maxLength > 0) {
            int count = commands.size() * 3;
            for (String args : commands) {
                count += args.length();
            }
            if (count >= Config.getMaxCommandLineLength()) {
                String msg = ResourceManager.getString("launch.error.cmd.max.len", count, maxLength, null);
                Trace.println("Error: " + msg, TraceLevel.BASIC);
                throw new RuntimeException(msg);
            }
        }
    }

    public Process startProcessBuilder(ProcessBuilder builder) throws IOException {
        Platform.validateProcessBuilder(builder.command());
        return builder.start();
    }

    public void verifyPermissionsForFileSystem() {
    }

    public void setRunInNativeSandbox(boolean runInNativeSandbox) {
    }

    public boolean getRunInNativeSandbox() {
        return false;
    }

    public void checkAndUpdateSandboxWindow(boolean force) {
    }

    public boolean isNativeSandbox() {
        return false;
    }

    public boolean getUseNativeSandboxWindow() {
        return false;
    }

    public long createNativeWindowSandboxHandle(long handle) {
        return 0L;
    }

    public void setNativeSandboxWindowSize(long handle, int width, int height) {
    }

    private synchronized boolean initNativeSandboxBroker() {
        if (this.sandboxBroker == null) {
            this.sandboxBroker = new NoSandboxBroker();
        }
        return true;
    }

    public NativeSandboxBroker getNativeSandboxBroker() {
        if (this.initNativeSandboxBroker()) {
            return this.sandboxBroker;
        }
        return null;
    }

    public void setNativeSandboxJNLPService(NativeSandboxJNLPService service) {
    }

    public void addParentWindow(int appletID, long parentNativeWindow) {
    }

    public void waitForNativeSandboxProcess() {
    }

    public boolean isScreenLocked() {
        return false;
    }

    long getUserDeploymentPropCacheTimestamp() {
        return -1L;
    }

    long getSysDeploymentPropCacheTimestamp() {
        return -1L;
    }

    public abstract WebJavaSwitch getWebJavaSwitch();

    public boolean isCompatibleArch(String arch1, String arch2) {
        return arch1.equals(arch2);
    }

    static {
        Permissions perms = new Permissions();
        BasicPermission perm1 = new AWTPermission("showWindowWithoutWarningBanner");
        ((PermissionCollection)perms).add(perm1);
        FilePermission perm2 = new FilePermission("<<ALL FILES>>", "execute");
        ((PermissionCollection)perms).add(perm2);
        PropertyPermission perm3 = new PropertyPermission("os.version", "read");
        ((PermissionCollection)perms).add(perm3);
        ACC_SHOW_INSTANCE = new AccessControlContext(new ProtectionDomain[]{new ProtectionDomain(null, perms)});
        perms = new Permissions();
        perm1 = new PropertyPermission("*", "read,write");
        ((PermissionCollection)perms).add(perm1);
        perm2 = new FilePermission("<<ALL FILES>>", "read,write,delete");
        ((PermissionCollection)perms).add(perm2);
        ACC_FILEPROP_INSTANCE = new AccessControlContext(new ProtectionDomain[]{new ProtectionDomain(null, perms)});
        perms = new Permissions();
        FilePermission perm = new FilePermission("<<ALL FILES>>", "read,write,delete");
        ((PermissionCollection)perms).add(perm);
        ACC_FILE_INSTANCE = new AccessControlContext(new ProtectionDomain[]{new ProtectionDomain(null, perms)});
    }

    public static abstract class WebJavaSwitch {
        protected abstract void setSystemWebJavaEnabled(boolean var1);

        protected abstract boolean isSystemWebJavaEnabled();

        public WebJavaState queryWebJavaState() {
            if (!this.isSystemWebJavaEnabled()) {
                return WebJavaState.DISABLED;
            }
            if (!this.isUserWebJavaEnabled()) {
                return WebJavaState.USER_DISABLED;
            }
            return WebJavaState.ENABLED;
        }

        public void setWebJavaEnabled(boolean enable) {
            try {
                this.setUserWebJavaEnabled(enable);
            }
            finally {
                this.setSystemWebJavaEnabled(enable);
            }
        }

        private void setUserWebJavaEnabled(boolean enabled) {
            String decision = "undefined";
            if (OSType.isUnix() && !Platform.get().isGTKAvailable(2, 14, 0)) {
                decision = enabled ? "later" : "block";
            }
            Config.setStringProperty("deployment.expiration.decision." + SecurityBaseline.getDeployVersion(), decision);
            Config.setBooleanProperty("deployment.webjava.enabled", enabled);
            Config.get().storeIfNeeded();
        }

        private boolean isUserWebJavaEnabled() {
            boolean systemEnabled;
            String ekey = "deployment.expiration.decision." + SecurityBaseline.getDeployVersion();
            boolean blockedExpired = "block".equals(Config.getStringProperty(ekey));
            boolean userEnabled = Config.getBooleanProperty("deployment.webjava.enabled");
            if (userEnabled != (systemEnabled = this.isSystemWebJavaEnabled())) {
                long userLastModified = Platform.get().getUserDeploymentPropCacheTimestamp();
                long sysLastModified = Platform.get().getSysDeploymentPropCacheTimestamp();
                if (userLastModified != -1L && sysLastModified != -1L && sysLastModified >= userLastModified) {
                    this.setUserWebJavaEnabled(systemEnabled);
                    userEnabled = systemEnabled;
                }
            }
            return userEnabled && !blockedExpired;
        }

        public boolean isWebJavaEnabled() {
            return this.queryWebJavaState() == WebJavaState.ENABLED;
        }

        public static final class WebJavaState {
            public static final WebJavaState ENABLED = new WebJavaState();
            public static final WebJavaState DISABLED = new WebJavaState();
            public static final WebJavaState USER_DISABLED = new WebJavaState();

            private WebJavaState() {
            }
        }
    }
}

