/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.config;

import com.sun.deploy.trace.Trace;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

class ConfigTrustManager
implements X509TrustManager {
    private static SSLSocketFactory ssf = null;
    private X509TrustManager defaultTM = null;
    private X509TrustManager nativeTM = null;

    public ConfigTrustManager() throws KeyStoreException, NoSuchAlgorithmException, NoSuchProviderException, CertificateException {
        TrustManager[] defaultTMArray = this.generateTrustManager(false);
        TrustManager[] nativeTMArray = this.generateTrustManager(true);
        if (defaultTMArray.length > 0) {
            this.defaultTM = (X509TrustManager)defaultTMArray[0];
        }
        if (nativeTMArray.length > 0) {
            this.nativeTM = (X509TrustManager)nativeTMArray[0];
        }
    }

    public static void resetHttpsFactory(HttpsURLConnection https) {
        try {
            if (ssf == null) {
                ConfigTrustManager tm = new ConfigTrustManager();
                TrustManager[] trustManagerArray = new TrustManager[]{tm};
                SSLContext ctx = SSLContext.getInstance("TLS");
                ctx.init(null, trustManagerArray, null);
                ssf = ctx.getSocketFactory();
            }
            if (ssf != null) {
                Trace.securityPrintln("Reset SSLSocketFactory using Config TrustManager");
                https.setSSLSocketFactory(ssf);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        X509Certificate[] defaultTMIssuers = this.defaultTM.getAcceptedIssuers();
        X509Certificate[] nativeTMIssuers = this.nativeTM.getAcceptedIssuers();
        X509Certificate[] allTMIssuers = new X509Certificate[defaultTMIssuers.length + nativeTMIssuers.length];
        System.arraycopy(defaultTMIssuers, 0, allTMIssuers, 0, defaultTMIssuers.length);
        System.arraycopy(nativeTMIssuers, 0, allTMIssuers, defaultTMIssuers.length, nativeTMIssuers.length);
        return allTMIssuers;
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        boolean fallback = false;
        if (this.defaultTM == null && this.nativeTM == null) {
            throw new CertificateException("Both TrustManager are null");
        }
        if (this.defaultTM != null) {
            try {
                this.defaultTM.checkServerTrusted(chain, authType);
                return;
            }
            catch (CertificateException ce) {
                Trace.securityPrintln("Default TrustManager check failed");
                if (this.nativeTM == null) {
                    Trace.securityPrintln("No native TrustManager available");
                    throw ce;
                }
                fallback = true;
            }
        }
        if (this.nativeTM != null && (fallback || this.defaultTM == null)) {
            try {
                Trace.securityPrintln("Using native TrustManager");
                this.nativeTM.checkServerTrusted(chain, authType);
            }
            catch (CertificateException ce) {
                Trace.securityPrintln("Native(IE browser) TrustManager check failed");
                throw ce;
            }
        }
    }

    private TrustManager[] generateTrustManager(boolean nativeFlag) {
        String defaultPasswd = "";
        try {
            String algorithm = TrustManagerFactory.getDefaultAlgorithm();
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(algorithm);
            if (nativeFlag) {
                KeyStore ks = KeyStore.getInstance("Windows-ROOT");
                ks.load(null, defaultPasswd.toCharArray());
                tmf.init(ks);
            } else {
                tmf.init((KeyStore)null);
            }
            return tmf.getTrustManagers();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

