/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.cache;

import com.sun.deploy.security.JarVerifier;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.util.JarUtil;
import java.net.URL;
import java.security.CodeSigner;
import java.security.CodeSource;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class JarSigningData {
    private CodeSigner[] signers;
    private Map<String, int[]> signerMap;
    private JarVerifier.CodeSourceCache codeSourceCache;
    private Certificate[] certificates;
    private Map<String, int[]> signerMapCert;
    private JarVerifier.CodeSourceCache codeSourceCertCache;
    private final boolean hasOnlySignedEntries;
    private final boolean hasSingleCodeSource;
    private final boolean hasMissingSignedEntries;
    private static int[] emptySignerIndices = new int[0];

    JarSigningData(boolean onlySignedEntries, boolean singleCodeSource, boolean missingSignedEntries) {
        this.hasOnlySignedEntries = onlySignedEntries;
        this.hasSingleCodeSource = singleCodeSource;
        this.hasMissingSignedEntries = missingSignedEntries;
    }

    public static JarSigningData create(JarVerifier jv) {
        List<CodeSigner> signersCS;
        JarSigningData jsd = new JarSigningData(jv.hasOnlySignedEntries(), jv.hasSingleCodeSource(), jv.hasMissingSignedEntries());
        List<Certificate> signerCerts = jv.getSignerCerts();
        if (!signerCerts.isEmpty()) {
            jsd.certificates = signerCerts.toArray(new Certificate[signerCerts.size()]);
            jsd.signerMapCert = jv.getSignerMapCert();
            jsd.codeSourceCertCache = jv.getCodeSourceCertCache();
        }
        if (!(signersCS = jv.getSignersCS()).isEmpty()) {
            CodeSigner[] signers = new CodeSigner[signersCS.size()];
            jsd.signers = signersCS.toArray(signers);
            jsd.signerMap = jv.getSignerMap();
            jsd.codeSourceCache = jv.getCodeSourceCache();
        }
        Trace.println("Create from verifier: " + jsd, TraceLevel.CACHE);
        return jsd;
    }

    void updateSignerInfo(CodeSigner[] signers, Map<String, int[]> signerMap, JarVerifier.CodeSourceCache codeSourceCache) {
        this.signers = signers;
        this.signerMap = signerMap;
        this.codeSourceCache = codeSourceCache;
    }

    boolean hasStrictSingleSigning() {
        return this.hasOnlySignedEntries && this.hasSingleCodeSource && !this.hasMissingSignedEntries;
    }

    synchronized Map<String, int[]> getCertificateMap() {
        return this.signerMapCert;
    }

    synchronized Map<String, int[]> getSignerMap() {
        return this.signerMap;
    }

    synchronized JarVerifier.CodeSourceCache getCodeSourceCache() {
        return this.codeSourceCache;
    }

    synchronized boolean matchStrictSingleSigning(CodeSource[] cs) {
        if (!this.hasStrictSingleSigning()) {
            return false;
        }
        if (cs == null || cs.length != 1 || cs[0] == null) {
            return false;
        }
        CodeSource s1 = cs[0];
        Map<String, int[]> sMap = this.getSignerMap();
        int[] idx = sMap != null ? sMap.get(null) : null;
        JarVerifier.CodeSourceCache csCache = this.getCodeSourceCache();
        CodeSource s2 = csCache != null ? csCache.get(idx) : null;
        return s1.equals(s2);
    }

    synchronized JarVerifier.CodeSourceCache getCodeSourceCertCache() {
        return this.codeSourceCertCache;
    }

    public synchronized CodeSigner[] getCodeSigners() {
        return this.signers;
    }

    public synchronized Certificate[] getCertificates() {
        return this.certificates;
    }

    synchronized CodeSource[] getCodeSources(URL url) {
        CodeSource[] ret;
        Collection<CodeSource> codeSources;
        JarVerifier.CodeSourceCache csCache = this.getCodeSourceCache();
        Collection<CodeSource> collection = codeSources = csCache != null ? csCache.getCodeSources() : null;
        if (codeSources != null) {
            int size = codeSources.size();
            if (this.hasOnlySignedEntries) {
                ret = codeSources.toArray(new CodeSource[size]);
            } else {
                ret = codeSources.toArray(new CodeSource[size + 1]);
                ret[size] = JarSigningData.getUnsignedCS(url);
            }
        } else {
            ret = new CodeSource[]{JarSigningData.getUnsignedCS(url)};
        }
        return ret;
    }

    synchronized CodeSource getCodeSource(URL url, String name) {
        JarVerifier.CodeSourceCache cache;
        int[] signerIndices = this.getSignerIndices(name);
        if (signerIndices != null && (cache = this.getCodeSourceCache()) != null) {
            return cache.get(signerIndices);
        }
        return JarSigningData.getUnsignedCS(url);
    }

    private int[] findMatchingSignerIndices(CodeSource cs) {
        JarVerifier.CodeSourceCache cache = this.getCodeSourceCache();
        if (cache == null) {
            return emptySignerIndices;
        }
        int[] result = cache.findMatchingIndices(cs);
        if (result == null && cs.getCodeSigners() == null) {
            return emptySignerIndices;
        }
        return result;
    }

    private int[] getSignerIndices(String name) {
        if (this.signerMap == null || this.signerMap.isEmpty()) {
            return null;
        }
        if (this.hasStrictSingleSigning()) {
            if (!JarUtil.isSigningRelated(name) && !name.endsWith("/")) {
                return this.signerMap.get(null);
            }
            return null;
        }
        return this.signerMap.get(name);
    }

    synchronized CodeSigner[] getCodeSigners(String name) {
        int[] signerIndices = this.getSignerIndices(name);
        CodeSigner[] result = null;
        if (this.signers != null && signerIndices != null) {
            result = new CodeSigner[signerIndices.length];
            for (int i = 0; i < signerIndices.length; ++i) {
                if (this.signers == null) continue;
                result[i] = this.signers[signerIndices[i]];
            }
        }
        return result;
    }

    synchronized Certificate[] getCertificates(String name) {
        int[] signerIndices = this.getSignerIndices(name);
        if (this.signers != null && signerIndices != null) {
            ArrayList<? extends Certificate> certChains = new ArrayList<Certificate>();
            for (int i = 0; i < signerIndices.length; ++i) {
                certChains.addAll(this.signers[signerIndices[i]].getSignerCertPath().getCertificates());
            }
            return certChains.toArray(new Certificate[certChains.size()]);
        }
        return null;
    }

    synchronized Certificate[] getCertificates14(String name) {
        int[] certIndices = this.getCertIndices(name);
        Certificate[] certs = null;
        if (this.certificates != null && certIndices != null) {
            certs = new Certificate[this.certificates.length];
            for (int i = 0; i < this.certificates.length; ++i) {
                certs[i] = this.certificates[certIndices[i]];
            }
        }
        return certs;
    }

    private synchronized int[] getCertIndices(String name) {
        Map<String, int[]> signerMap = this.getCertificateMap();
        if (signerMap == null || signerMap.isEmpty()) {
            return null;
        }
        if (this.hasStrictSingleSigning()) {
            if (!JarUtil.isSigningRelated(name) && !name.endsWith("/")) {
                return signerMap.get(null);
            }
            return null;
        }
        return signerMap.get(name);
    }

    synchronized boolean collectEntryNamesBySigners(CodeSource[] cs, List<String> result) {
        boolean matchUnsigned = false;
        ArrayList<int[]> req = new ArrayList<int[]>(cs.length);
        for (int i = 0; i < cs.length; ++i) {
            int[] match = this.findMatchingSignerIndices(cs[i]);
            if (match == null) continue;
            if (match.length > 0) {
                req.add(match);
                continue;
            }
            matchUnsigned = true;
        }
        if (this.signerMap != null) {
            for (String name : this.signerMap.keySet()) {
                if (JarSigningData.containsArrayElement(req, this.signerMap.get(name))) {
                    result.add(name);
                    continue;
                }
                Trace.println("collectEntryNamesBySigners: unmatched entry " + name, TraceLevel.CACHE);
            }
        }
        return matchUnsigned;
    }

    private static boolean containsArrayElement(List<int[]> list, int[] element) {
        for (int[] e : list) {
            if (!Arrays.equals(e, element)) continue;
            return true;
        }
        return false;
    }

    private static CodeSource getUnsignedCS(URL url) {
        return new CodeSource(url, (Certificate[])null);
    }

    public String toString() {
        return "JarSigningData{hasOnlySignedEntries=" + this.hasOnlySignedEntries + ", hasSingleCodeSource=" + this.hasSingleCodeSource + ", hasMissingSignedEntries=" + this.hasMissingSignedEntries + "}";
    }
}

