/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.association.utility;

import com.sun.deploy.association.Action;
import com.sun.deploy.association.utility.GnomeVfsWrapper;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class GnomeAssociationUtil {
    public static final String GNOME_VFS_MIME_KEY_DESCRIPTION = "description";
    public static final String GNOME_VFS_MIME_KEY_ICON_FILENAME = "icon_filename";

    private GnomeAssociationUtil() {
    }

    public static String getMimeTypeByFileExt(String fileExt) {
        String resultMimeType = null;
        String[] allMimeTypes = GnomeVfsWrapper.gnome_vfs_get_registered_mime_types();
        if (allMimeTypes == null) {
            return null;
        }
        for (int i = 0; i < allMimeTypes.length; ++i) {
            String curMimeType = allMimeTypes[i];
            String[] fileExtensions = GnomeVfsWrapper.gnome_vfs_mime_get_extensions_list(curMimeType);
            if (fileExtensions != null) {
                for (int j = 0; j < fileExtensions.length; ++j) {
                    if (!fileExtensions[j].equals(fileExt)) continue;
                    resultMimeType = allMimeTypes[i];
                    break;
                }
            }
            if (resultMimeType != null) break;
        }
        return resultMimeType;
    }

    public static List getFileExtListByMimeType(String mimeType) {
        String[] fileExtensions = GnomeVfsWrapper.gnome_vfs_mime_get_extensions_list(mimeType);
        if (fileExtensions == null) {
            return null;
        }
        ArrayList<String> fileExtList = new ArrayList<String>();
        for (int index = 0; index < fileExtensions.length; ++index) {
            fileExtList.add(fileExtensions[index]);
        }
        return fileExtList;
    }

    public static String getIconFileNameByMimeType(String mimeType) {
        return GnomeVfsWrapper.gnome_vfs_mime_get_icon(mimeType);
    }

    public static String getDescriptionByMimeType(String mimeType) {
        return GnomeVfsWrapper.gnome_vfs_mime_get_description(mimeType);
    }

    public static List getActionListByMimeType(String mimeType) {
        String defaultCmd;
        ArrayList<Action> actionList = new ArrayList<Action>();
        Action oneAction = null;
        String[] keys = GnomeVfsWrapper.gnome_vfs_mime_get_key_list(mimeType);
        if (keys != null) {
            String command = null;
            for (int i = 0; i < keys.length; ++i) {
                command = GnomeVfsWrapper.gnome_vfs_mime_get_value(mimeType, keys[i]);
                if (command == null) continue;
                oneAction = new Action(keys[i], command);
                actionList.add(oneAction);
            }
        }
        if ((defaultCmd = GnomeVfsWrapper.gnome_vfs_mime_get_default_application_command(mimeType)) != null) {
            actionList.add(new Action("open", defaultCmd));
        }
        if (actionList.isEmpty()) {
            return null;
        }
        return actionList;
    }

    public static String getMimeTypeByURL(URL url) {
        return GnomeVfsWrapper.gnome_vfs_get_mime_type(url.toString());
    }

    public static boolean isMimeTypeExist(String mimeType) {
        boolean isMimeTypeExist = false;
        String[] allMimeTypes = GnomeVfsWrapper.gnome_vfs_get_registered_mime_types();
        if (allMimeTypes == null) {
            return false;
        }
        for (int i = 0; i < allMimeTypes.length; ++i) {
            if (!mimeType.equals(allMimeTypes[i])) continue;
            isMimeTypeExist = true;
            break;
        }
        return isMimeTypeExist;
    }

    public static boolean isFileExtExist(String fileExt) {
        return GnomeAssociationUtil.getMimeTypeByFileExt(fileExt) != null;
    }

    public static String getEnv(String envName) {
        return GnomeVfsWrapper.getEnv(envName);
    }

    public static boolean supportsCurrentPlatform() {
        String version = GnomeVfsWrapper.getVersion();
        return version != null && GnomeAssociationUtil.compareVersion(version, "2.6") <= 0;
    }

    public static boolean isAssociationSupported() {
        String version = GnomeVfsWrapper.getVersion();
        return version != null && GnomeAssociationUtil.compareVersion(version, "2.8") < 0;
    }

    public static int compareVersion(String s1, String s2) {
        StringTokenizer st1 = new StringTokenizer(s1, ".");
        StringTokenizer st2 = new StringTokenizer(s2, ".");
        int result = 0;
        while (st1.hasMoreTokens() && result == 0) {
            if (st2.hasMoreTokens()) {
                result = Integer.parseInt(st1.nextToken()) - Integer.parseInt(st2.nextToken());
                continue;
            }
            result = Integer.parseInt(st1.nextToken());
        }
        while (result == 0 && st2.hasMoreTokens()) {
            result = 0 - Integer.parseInt(st2.nextToken());
        }
        return result;
    }

    public static boolean isGnome26OrLater() {
        String version = GnomeVfsWrapper.getVersion();
        return version != null && GnomeAssociationUtil.compareVersion(version, "2.6") < 0;
    }
}

