/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.association.utility;

import com.sun.deploy.trace.Trace;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Properties;

public class DesktopEntry {
    public static final String DEFAULT_GROUP = "Desktop Entry";
    private String group = null;
    private Properties entries = null;
    private static String[] DESKTOP_ENTRY_KEYS = new String[]{"Type", "Version", "Encoding", "Name", "GenericName", "NoDisplay", "Comment", "Icon", "Hidden", "FilePattern", "TryExec", "Exec", "Path", "Terminal", "SwallowTitle", "SwallowExec", "Actions", "MimeType", "SortOrder", "Dev", "FSType", "MountPoint", "ReadOnly", "UnmountIcon", "URL", "Categories ", "OnlyShowIn", "NotShowIn", "StartupNotify", "StartupWMClass"};

    public DesktopEntry() {
        this(DEFAULT_GROUP);
    }

    public DesktopEntry(String group) {
        this.group = group;
        this.entries = new Properties();
        this.set("Version", "1.0");
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public String getType() {
        return this.get("Type");
    }

    public void setType(String type) {
        this.set("Type", type);
    }

    public void setEncoding(String encoding) {
        this.set("Encoding", encoding);
    }

    public String getEncoding() {
        return this.get("Encoding");
    }

    public void setName(String name) {
        this.set("Name", name);
    }

    public String getName() {
        return this.get("Name");
    }

    public String getGenericName() {
        return this.get("GenericName");
    }

    public void setGenericName(String genericName) {
        this.set("GenericName", genericName);
    }

    public String getExec() {
        return this.get("Exec");
    }

    public void setExec(String program) {
        this.set("Exec", program);
    }

    public String getIcon() {
        return this.get("Icon");
    }

    public void setIcon(String icon) {
        this.set("Icon", icon);
    }

    public boolean getTerminal() {
        return Boolean.parseBoolean(this.get("Terminal"));
    }

    public void setTerminal(boolean terminal) {
        this.set("Terminal", String.valueOf(terminal));
    }

    public String getCategories() {
        return this.get("Categories");
    }

    public void setCategories(String categories) {
        this.set("Categories", categories);
    }

    public String getComment() {
        return this.get("Comment");
    }

    public void setComment(String comment) {
        this.set("Comment", comment);
    }

    public String getPath() {
        return this.get("Path");
    }

    public void setPath(String path) {
        this.set("Path", path);
    }

    public void set(String key, String value) {
        if (value == null) {
            this.entries.remove(key);
        } else {
            this.entries.setProperty(key, value);
        }
    }

    public void set(String key, String locale, String value) {
        this.set(key + "[" + locale + "]", value);
    }

    public String get(String key, String locale) {
        return this.get(key + "[" + locale + "]");
    }

    public String get(String key) {
        return this.entries.getProperty(key);
    }

    public void load(String content) {
        try {
            this.entries.load(new ByteArrayInputStream(content.getBytes()));
        }
        catch (IOException ioe) {
            Trace.ignoredException(ioe);
        }
    }

    public static DesktopEntry create(String content) {
        return DesktopEntry.create(DEFAULT_GROUP, content);
    }

    public static DesktopEntry create(String group, String content) {
        if (null == group || group.trim().equals("")) {
            group = DEFAULT_GROUP;
        }
        DesktopEntry entry = new DesktopEntry(group);
        entry.load(content);
        return entry;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (null == this.group) {
            sb.append("[Desktop Entry]\n");
        } else {
            sb.append("[" + this.group + "]\n");
        }
        for (String string : this.entries.keySet()) {
            sb.append(string);
            sb.append("=");
            sb.append(this.entries.getProperty(string));
            sb.append("\n");
        }
        return sb.toString();
    }
}

