/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.encoder;

import java.nio.CharBuffer;
import java.nio.charset.CoderResult;
import org.owasp.encoder.Encoder;
import org.owasp.encoder.Unicode;

class XMLEncoder
extends Encoder {
    private static final long BASE_VALID_MASK = 9728L;
    static final int MAX_ENCODED_CHAR_LENGTH = 5;
    static final int AMP_LENGTH = 5;
    static final int LT_LENGTH = 4;
    static final int GT_LENGTH = 4;
    static final int APOS_LENGTH = 5;
    static final int QUOT_LENGTH = 5;
    static final char INVALID_CHARACTER_REPLACEMENT = ' ';
    private final long _validMask;
    private final Mode _mode;

    XMLEncoder() {
        this(Mode.ALL);
    }

    XMLEncoder(Mode mode) {
        this._mode = mode;
        this._validMask = mode.validMask();
    }

    @Override
    public int maxEncodedLength(int n) {
        return n * 5;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int firstEncodedOffset(String input, int off, int len) {
        int n = off + len;
        int i = off;
        while (i < n) {
            char ch = input.charAt(i);
            if (ch < '\u007f') {
                if (ch <= '>' && (this._validMask & 1L << ch) == 0L) {
                    return i;
                }
            } else if (ch < '\ud800') {
                if (ch <= '\u009f' && ch != '\u0085') {
                    return i;
                }
            } else if (ch <= '\udbff') {
                if (i + 1 >= n || !Character.isLowSurrogate(input.charAt(i + 1))) return i;
                int cp = Character.toCodePoint(ch, input.charAt(i + 1));
                if (Unicode.isNonCharacter(cp)) {
                    return i;
                }
                ++i;
            } else if (ch <= '\udfff' || ch > '\ufffd' || '\ufdd0' <= ch && ch <= '\ufdef') {
                return i;
            }
            ++i;
        }
        return n;
    }

    @Override
    protected CoderResult encodeArrays(CharBuffer input, CharBuffer output, boolean endOfInput) {
        char[] in = input.array();
        char[] out = output.array();
        int i = input.arrayOffset() + input.position();
        int n = input.arrayOffset() + input.limit();
        int j = output.arrayOffset() + output.position();
        int m = output.arrayOffset() + output.limit();
        while (i < n) {
            int ch = in[i];
            if (ch < 127) {
                if (ch > 62 || (this._validMask & 1L << ch) != 0L) {
                    if (j >= m) {
                        return XMLEncoder.overflow(input, i, output, j);
                    }
                    out[j++] = ch;
                } else {
                    switch (ch) {
                        case 38: {
                            if (j + 5 > m) {
                                return XMLEncoder.overflow(input, i, output, j);
                            }
                            out[j++] = 38;
                            out[j++] = 97;
                            out[j++] = 109;
                            out[j++] = 112;
                            out[j++] = 59;
                            break;
                        }
                        case 60: {
                            if (j + 4 > m) {
                                return XMLEncoder.overflow(input, i, output, j);
                            }
                            out[j++] = 38;
                            out[j++] = 108;
                            out[j++] = 116;
                            out[j++] = 59;
                            break;
                        }
                        case 62: {
                            if (j + 4 > m) {
                                return XMLEncoder.overflow(input, i, output, j);
                            }
                            out[j++] = 38;
                            out[j++] = 103;
                            out[j++] = 116;
                            out[j++] = 59;
                            break;
                        }
                        case 39: {
                            if (j + 5 > m) {
                                return XMLEncoder.overflow(input, i, output, j);
                            }
                            out[j++] = 38;
                            out[j++] = 35;
                            out[j++] = 51;
                            out[j++] = 57;
                            out[j++] = 59;
                            break;
                        }
                        case 34: {
                            if (j + 5 > m) {
                                return XMLEncoder.overflow(input, i, output, j);
                            }
                            out[j++] = 38;
                            out[j++] = 35;
                            out[j++] = 51;
                            out[j++] = 52;
                            out[j++] = 59;
                            break;
                        }
                        default: {
                            if (j >= m) {
                                return XMLEncoder.overflow(input, i, output, j);
                            }
                            out[j++] = 32;
                            break;
                        }
                    }
                }
            } else if (ch < 55296) {
                if (j >= m) {
                    return XMLEncoder.overflow(input, i, output, j);
                }
                out[j++] = ch > 159 || ch == 133 ? ch : 32;
            } else if (ch <= 56319) {
                if (i + 1 < n) {
                    if (Character.isLowSurrogate(in[i + 1])) {
                        int cp = Character.toCodePoint((char)ch, in[i + 1]);
                        if (Unicode.isNonCharacter(cp)) {
                            if (j >= m) {
                                return XMLEncoder.overflow(input, i, output, j);
                            }
                            out[j++] = 32;
                            ++i;
                        } else {
                            if (j + 1 >= m) {
                                return XMLEncoder.overflow(input, i, output, j);
                            }
                            out[j++] = ch;
                            out[j++] = in[++i];
                        }
                    } else {
                        if (j >= m) {
                            return XMLEncoder.overflow(input, i, output, j);
                        }
                        out[j++] = 32;
                    }
                } else {
                    if (!endOfInput) break;
                    if (j >= m) {
                        return XMLEncoder.overflow(input, i, output, j);
                    }
                    out[j++] = 32;
                }
            } else if (ch <= 57343 || ch > 65533 || 64976 <= ch && ch <= 65007) {
                if (j >= m) {
                    return XMLEncoder.overflow(input, i, output, j);
                }
                out[j++] = 32;
            } else {
                if (j >= m) {
                    return XMLEncoder.overflow(input, i, output, j);
                }
                out[j++] = ch;
            }
            ++i;
        }
        return XMLEncoder.underflow(input, i, output, j);
    }

    public String toString() {
        return "XMLEncoder(" + (Object)((Object)this._mode) + ")";
    }

    static enum Mode {
        ALL("&<>'\""),
        CONTENT("&<>"),
        ATTRIBUTE("&<'\""),
        SINGLE_QUOTED_ATTRIBUTE("&<'"),
        DOUBLE_QUOTED_ATTRIBUTE("&<\"");

        private final long _validMask;

        private Mode(String encodedChars) {
            long encodeMask = 0L;
            int i = 0;
            int n2 = encodedChars.length();
            while (i < n2) {
                encodeMask |= 1L << encodedChars.charAt(i);
                ++i;
            }
            this._validMask = 0x2600L | 0xFFFFFFFF00000000L & (encodeMask ^ 0xFFFFFFFFFFFFFFFFL);
        }

        long validMask() {
            return this._validMask;
        }
    }
}

