/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.encoder;

import java.nio.CharBuffer;
import java.nio.charset.CoderResult;
import org.owasp.encoder.Encoder;
import org.owasp.encoder.Unicode;

class XMLCommentEncoder
extends Encoder {
    static final char HYPHEN_REPLACEMENT = '~';

    XMLCommentEncoder() {
    }

    @Override
    protected int maxEncodedLength(int n) {
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected int firstEncodedOffset(String input, int off, int len) {
        int n = off + len;
        int i = off;
        while (i < n) {
            char ch = input.charAt(i);
            if (ch <= '~') {
                if (ch == '-') {
                    if (i + 1 >= n) return i;
                    if (input.charAt(i + 1) == '-') {
                        return i;
                    }
                } else if (ch < ' ' && ch != '\n' && ch != '\r' && ch != '\t') {
                    return i;
                }
            } else if (ch < '\ud800') {
                if (ch <= '\u009f' && ch != '\u0085') {
                    return i;
                }
            } else if (ch <= '\udbff') {
                if (i + 1 >= n || !Character.isLowSurrogate(input.charAt(i + 1))) return i;
                int cp = Character.toCodePoint(ch, input.charAt(i + 1));
                if (Unicode.isNonCharacter(cp)) {
                    return i;
                }
                ++i;
            } else if (ch <= '\udfff' || ch > '\ufffd' || '\ufdd0' <= ch && ch <= '\ufdef') {
                return i;
            }
            ++i;
        }
        return n;
    }

    @Override
    protected CoderResult encodeArrays(CharBuffer input, CharBuffer output, boolean endOfInput) {
        char[] in = input.array();
        char[] out = output.array();
        int i = input.arrayOffset() + input.position();
        int n = input.arrayOffset() + input.limit();
        int j = output.arrayOffset() + output.position();
        int m = output.arrayOffset() + output.limit();
        while (i < n) {
            int ch = in[i];
            if (ch <= 126) {
                if (ch == 45) {
                    if (i + 1 < n) {
                        if (in[i + 1] == '-') {
                            if (j + 1 >= m) {
                                return XMLCommentEncoder.overflow(input, i, output, j);
                            }
                            out[j++] = 45;
                            out[j++] = 126;
                            ++i;
                        } else {
                            if (j >= m) {
                                return XMLCommentEncoder.overflow(input, i, output, j);
                            }
                            out[j++] = 45;
                        }
                    } else {
                        if (!endOfInput) break;
                        if (j >= m) {
                            return XMLCommentEncoder.overflow(input, i, output, j);
                        }
                        out[j++] = 126;
                    }
                } else if (ch > 32 || ch == 10 || ch == 13 || ch == 9) {
                    if (j >= m) {
                        return XMLCommentEncoder.overflow(input, i, output, j);
                    }
                    out[j++] = ch;
                } else {
                    if (j >= m) {
                        return XMLCommentEncoder.overflow(input, i, output, j);
                    }
                    out[j++] = 32;
                }
            } else if (ch < 55296) {
                if (j >= m) {
                    return XMLCommentEncoder.overflow(input, i, output, j);
                }
                out[j++] = ch > 159 || ch == 133 ? ch : 32;
            } else if (ch <= 56319) {
                if (i + 1 < n) {
                    if (Character.isLowSurrogate(in[i + 1])) {
                        int cp = Character.toCodePoint((char)ch, in[i + 1]);
                        if (Unicode.isNonCharacter(cp)) {
                            if (j >= m) {
                                return XMLCommentEncoder.overflow(input, i, output, j);
                            }
                            out[j++] = 32;
                            ++i;
                        } else {
                            if (j + 1 >= m) {
                                return XMLCommentEncoder.overflow(input, i, output, j);
                            }
                            out[j++] = ch;
                            out[j++] = in[++i];
                        }
                    } else {
                        if (j >= m) {
                            return XMLCommentEncoder.overflow(input, i, output, j);
                        }
                        out[j++] = 32;
                    }
                } else {
                    if (!endOfInput) break;
                    if (j >= m) {
                        return XMLCommentEncoder.overflow(input, i, output, j);
                    }
                    out[j++] = 32;
                }
            } else if (ch <= 57343 || ch > 65533 || 64976 <= ch && ch <= 65007) {
                if (j >= m) {
                    return XMLCommentEncoder.overflow(input, i, output, j);
                }
                out[j++] = 32;
            } else {
                if (j >= m) {
                    return XMLCommentEncoder.overflow(input, i, output, j);
                }
                out[j++] = ch;
            }
            ++i;
        }
        return XMLCommentEncoder.underflow(input, i, output, j);
    }

    public String toString() {
        return "XMLCommentEncoder";
    }
}

