/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.encoder;

import java.nio.CharBuffer;
import java.nio.charset.CoderResult;
import org.owasp.encoder.Encoder;

class JavaScriptEncoder
extends Encoder {
    private final Mode _mode;
    private final boolean _hexEncodeQuotes;
    private final int[] _validMasks;
    private final boolean _asciiOnly;

    JavaScriptEncoder(Mode mode, boolean asciiOnly) {
        this._mode = mode;
        int[] nArray = new int[4];
        nArray[1] = -133;
        nArray[2] = -268435457;
        nArray[3] = asciiOnly ? Integer.MAX_VALUE : -1;
        this._validMasks = nArray;
        if (mode == Mode.BLOCK || mode == Mode.HTML) {
            this._validMasks[1] = this._validMasks[1] & 0xFFFF5FFF;
        }
        if (mode != Mode.SOURCE) {
            this._validMasks[1] = this._validMasks[1] & 0xFFFFFFBF;
        }
        this._asciiOnly = asciiOnly;
        this._hexEncodeQuotes = mode == Mode.ATTRIBUTE || mode == Mode.HTML;
    }

    @Override
    int maxEncodedLength(int n) {
        return n * 6;
    }

    @Override
    int firstEncodedOffset(String input, int off, int len) {
        int n = off + len;
        int[] validMasks = this._validMasks;
        int i = off;
        while (i < n) {
            char ch = input.charAt(i);
            if (ch < '\u0080' ? (validMasks[ch >>> 5] & '\u0001' << ch) == 0 : this._asciiOnly || ch == '\u2028' || ch == '\u2029') {
                return i;
            }
            ++i;
        }
        return n;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected CoderResult encodeArrays(CharBuffer input, CharBuffer output, boolean endOfInput) {
        in = input.array();
        out = output.array();
        i = input.arrayOffset() + input.position();
        n = input.arrayOffset() + input.limit();
        j = output.arrayOffset() + output.position();
        m = output.arrayOffset() + output.limit();
        validMasks = this._validMasks;
        while (i < n) {
            block22: {
                block21: {
                    block20: {
                        block19: {
                            ch = in[i];
                            if (ch >= '\u0080') break block19;
                            if ((validMasks[ch >>> 5] & '\u0001' << ch) != 0) break block20;
                            break block21;
                        }
                        if (!this._asciiOnly && ch != '\u2028' && ch != '\u2029') break block20;
                        if (ch <= '\u00ff') ** GOTO lbl-1000
                        if (j + 6 > m) {
                            return JavaScriptEncoder.overflow(input, i, output, j);
                        }
                        out[j++] = 92;
                        out[j++] = 117;
                        out[j++] = JavaScriptEncoder.HEX[ch >>> 12];
                        out[j++] = JavaScriptEncoder.HEX[ch >>> 8 & 15];
                        out[j++] = JavaScriptEncoder.HEX[ch >>> 4 & 15];
                        out[j++] = JavaScriptEncoder.HEX[ch & 15];
                        break block22;
                    }
                    if (j >= m) {
                        return JavaScriptEncoder.overflow(input, i, output, j);
                    }
                    out[j++] = ch;
                    break block22;
                }
                switch (ch) {
                    case '\b': {
                        if (j + 2 > m) {
                            return JavaScriptEncoder.overflow(input, i, output, j);
                        }
                        out[j++] = 92;
                        out[j++] = 98;
                        break;
                    }
                    case '\t': {
                        if (j + 2 > m) {
                            return JavaScriptEncoder.overflow(input, i, output, j);
                        }
                        out[j++] = 92;
                        out[j++] = 116;
                        break;
                    }
                    case '\n': {
                        if (j + 2 > m) {
                            return JavaScriptEncoder.overflow(input, i, output, j);
                        }
                        out[j++] = 92;
                        out[j++] = 110;
                        break;
                    }
                    case '\f': {
                        if (j + 2 > m) {
                            return JavaScriptEncoder.overflow(input, i, output, j);
                        }
                        out[j++] = 92;
                        out[j++] = 102;
                        break;
                    }
                    case '\r': {
                        if (j + 2 > m) {
                            return JavaScriptEncoder.overflow(input, i, output, j);
                        }
                        out[j++] = 92;
                        out[j++] = 114;
                        break;
                    }
                    case '\"': 
                    case '\'': {
                        if (this._hexEncodeQuotes) ** GOTO lbl70
                    }
                    case '-': 
                    case '/': 
                    case '\\': {
                        if (j + 2 > m) {
                            return JavaScriptEncoder.overflow(input, i, output, j);
                        }
                        out[j++] = 92;
                        out[j++] = ch;
                        break;
                    }
lbl70:
                    // 2 sources

                    default: lbl-1000:
                    // 2 sources

                    {
                        if (j + 4 > m) {
                            return JavaScriptEncoder.overflow(input, i, output, j);
                        }
                        out[j++] = 92;
                        out[j++] = 120;
                        out[j++] = JavaScriptEncoder.HEX[ch >>> 4];
                        out[j++] = JavaScriptEncoder.HEX[ch & 15];
                    }
                }
            }
            ++i;
        }
        return JavaScriptEncoder.underflow(input, i, output, j);
    }

    public String toString() {
        return "JavaScriptEncoder(mode=" + (Object)((Object)this._mode) + "," + (this._asciiOnly ? "ASCII" : "UNICODE") + ")";
    }

    static enum Mode {
        SOURCE,
        ATTRIBUTE,
        BLOCK,
        HTML;

    }
}

