/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.encoder;

import java.nio.CharBuffer;
import java.nio.charset.CoderResult;
import org.owasp.encoder.ASCIIBits;
import org.owasp.encoder.Encoder;

class CSSEncoder
extends Encoder {
    static final int LONG_BITS = 64;
    static final int HEX_ENCODED_LENGTH = 4;
    static final char INVALID_REPLACEMENT_CHARACTER = '_';
    final long _lowMask;
    final long _highMask;
    final Mode _mode;

    public CSSEncoder(Mode mode) {
        this._mode = mode;
        this._lowMask = mode.lowMask();
        this._highMask = mode.highMask();
    }

    @Override
    protected int maxEncodedLength(int n) {
        return 4 * n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected int firstEncodedOffset(String input, int off, int len) {
        int n = off + len;
        int i = off;
        while (i < n) {
            char ch = input.charAt(i);
            if (ch < '\u0080') {
                if ((ch < '@' ? this._lowMask & 1L << ch : this._highMask & 1L << ch - 64) == 0L) return i;
            } else {
                if ((ch <= '\u009f' || ch >= '\u2028') && ch <= '\u2029') return i;
                if (ch >= '\ud800' && ch <= '\udfff') {
                    if (ch > '\udbff') return i;
                    if (i + 1 >= n) return i;
                    if (!Character.isLowSurrogate(input.charAt(i + 1))) return i;
                    ++i;
                }
            }
            ++i;
        }
        return n;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected CoderResult encodeArrays(CharBuffer input, CharBuffer output, boolean endOfInput) {
        char[] in = input.array();
        char[] out = output.array();
        int i = input.arrayOffset() + input.position();
        int n = input.arrayOffset() + input.limit();
        int j = output.arrayOffset() + output.position();
        int m = output.arrayOffset() + output.limit();
        while (i < n) {
            block20: {
                int ch;
                block22: {
                    block24: {
                        block23: {
                            block21: {
                                ch = in[i];
                                if (ch >= 128) break block21;
                                if ((ch < 64 ? this._lowMask & 1L << ch : this._highMask & 1L << ch - 64) == 0L) break block22;
                                if (j >= m) {
                                    return CSSEncoder.overflow(input, i, output, j);
                                }
                                out[j++] = ch;
                                break block20;
                            }
                            if ((ch <= 159 || ch >= 8232) && ch <= 8233) break block22;
                            if (ch >= 55296 && ch <= 57343) break block23;
                            if (j >= m) {
                                return CSSEncoder.overflow(input, i, output, j);
                            }
                            out[j++] = ch;
                            break block20;
                        }
                        if (ch > 56319) break block24;
                        if (i + 1 < n) {
                            if (Character.isLowSurrogate(in[i + 1])) {
                                if (j + 1 >= m) {
                                    return CSSEncoder.overflow(input, i, output, j);
                                }
                                out[j++] = ch;
                                out[j++] = in[++i];
                                break block20;
                            } else {
                                if (j >= m) {
                                    return CSSEncoder.overflow(input, i, output, j);
                                }
                                out[j++] = 95;
                            }
                            break block20;
                        } else {
                            if (!endOfInput) return CSSEncoder.underflow(input, i, output, j);
                            if (j >= m) {
                                return CSSEncoder.overflow(input, i, output, j);
                            }
                            out[j++] = 95;
                        }
                        break block20;
                    }
                    if (j >= m) {
                        return CSSEncoder.overflow(input, i, output, j);
                    }
                    out[j++] = 95;
                    break block20;
                }
                int k = j + 1;
                int tmp = ch;
                do {
                    ++k;
                } while ((tmp >>>= 4) != 0);
                boolean needsSpace = false;
                if (i + 1 < n) {
                    char la = in[i + 1];
                    if ('0' <= la && la <= '9' || 'a' <= la && la <= 'f' || 'A' <= la && la <= 'F' || la == ' ' || la == '\n' || la == '\r' || la == '\t' || la == '\f') {
                        needsSpace = true;
                        ++k;
                    }
                } else if (!endOfInput) {
                    return CSSEncoder.underflow(input, i, output, j);
                }
                if (k > m) {
                    return CSSEncoder.overflow(input, i, output, j);
                }
                out[j] = 92;
                j = k--;
                if (needsSpace) {
                    out[k] = 32;
                }
                tmp = ch;
                do {
                    out[--k] = HEX[tmp & 0xF];
                } while ((tmp >>>= 4) != 0);
                assert (out[k - 1] == '\\');
            }
            ++i;
        }
        return CSSEncoder.underflow(input, i, output, j);
    }

    public String toString() {
        return "CSSEncoder(mode=" + (Object)((Object)this._mode) + ")";
    }

    static enum Mode {
        STRING(new ASCIIBits().set(32, 126).clear("\"'<&/\\>")),
        URL(new ASCIIBits().set("!#$%").set(42, 91).set(93, 126).clear("/<>"));

        private final long _lowMask;
        private final long _highMask;

        private Mode(ASCIIBits bits) {
            this._lowMask = bits._lowerMask;
            this._highMask = bits._upperMask;
        }

        long lowMask() {
            return this._lowMask;
        }

        long highMask() {
            return this._highMask;
        }
    }
}

