/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.encoder;

import java.nio.CharBuffer;
import java.nio.charset.CoderResult;
import org.owasp.encoder.Encoder;
import org.owasp.encoder.Unicode;

class CDATAEncoder
extends Encoder {
    private static final char[] CDATA_END_ENCODED = "]]>]]<![CDATA[>".toCharArray();
    private static final int CDATA_END_ENCODED_LENGTH = 15;
    private static final int CDATA_END_LENGTH = 3;

    CDATAEncoder() {
    }

    @Override
    protected int maxEncodedLength(int n) {
        int worstCase = n / 3;
        int remainder = n % 3;
        return worstCase * 15 + remainder;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected int firstEncodedOffset(String input, int off, int len) {
        int n = off + len;
        int i = off;
        while (i < n) {
            char ch = input.charAt(i);
            if (ch <= '~') {
                if (ch != ']') {
                    if (ch < ' ' && ch != '\n' && ch != '\r' && ch != '\t') {
                        return i;
                    }
                } else {
                    if (i + 1 >= n) return n;
                    if (input.charAt(i + 1) == ']') {
                        while (i + 2 < n && input.charAt(i + 2) == ']') {
                            ++i;
                        }
                        if (i + 2 >= n) return n;
                        if (input.charAt(i + 2) == '>') {
                            return i;
                        }
                    }
                }
            } else if (ch < '\ud800') {
                if (ch <= '\u009f' && ch != '\u0085') {
                    return i;
                }
            } else if (ch <= '\udbff') {
                if (i + 1 >= n) return i;
                if (!Character.isLowSurrogate(input.charAt(i + 1))) return i;
                int cp = Character.toCodePoint(ch, input.charAt(i + 1));
                if (Unicode.isNonCharacter(cp)) {
                    return i;
                }
                ++i;
            } else if (ch <= '\udfff' || ch > '\ufffd' || '\ufdd0' <= ch && ch <= '\ufdef') {
                return i;
            }
            ++i;
        }
        return n;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected CoderResult encodeArrays(CharBuffer input, CharBuffer output, boolean endOfInput) {
        in = input.array();
        out = output.array();
        i = input.arrayOffset() + input.position();
        n = input.arrayOffset() + input.limit();
        j = output.arrayOffset() + output.position();
        m = output.arrayOffset() + output.limit();
        while (i < n) {
            block36: {
                block35: {
                    ch = in[i];
                    if (ch > 126) ** GOTO lbl52
                    if (ch == 93) break block35;
                    if (j >= m) {
                        return CDATAEncoder.overflow(input, i, output, j);
                    }
                    out[j++] = ch >= 32 || ch == 10 || ch == 13 || ch == 9 ? ch : 32;
                    break block36;
                }
                if (i + 1 >= n) ** GOTO lbl46
                if (in[i + 1] == ']') ** GOTO lbl26
                if (j >= m) {
                    return CDATAEncoder.overflow(input, i, output, j);
                }
                out[j++] = 93;
                break block36;
lbl-1000:
                // 1 sources

                {
                    if (j >= m) {
                        return CDATAEncoder.overflow(input, i, output, j);
                    }
                    out[j++] = 93;
                    ++i;
lbl26:
                    // 2 sources

                    ** while (i + 2 < n && in[i + 2] == ']')
                }
lbl27:
                // 1 sources

                if (i + 2 < n) {
                    if (in[i + 2] == '>') {
                        if (j + 15 > m) {
                            return CDATAEncoder.overflow(input, i, output, j);
                        }
                        System.arraycopy(CDATAEncoder.CDATA_END_ENCODED, 0, out, j, 15);
                        j += 15;
                        i += 2;
                    } else {
                        if (j >= m) {
                            return CDATAEncoder.overflow(input, i, output, j);
                        }
                        out[j++] = 93;
                    }
                } else {
                    if (!endOfInput) break;
                    if (j + 2 > m) {
                        return CDATAEncoder.overflow(input, i, output, j);
                    }
                    out[j++] = 93;
                    out[j++] = 93;
                    i = n;
                    break;
lbl46:
                    // 1 sources

                    if (!endOfInput) break;
                    if (j >= m) {
                        return CDATAEncoder.overflow(input, i, output, j);
                    }
                    out[j++] = 93;
                    ++i;
                    break;
lbl52:
                    // 1 sources

                    if (ch < 55296) {
                        if (ch > 159 || ch == 133) {
                            if (j >= m) {
                                return CDATAEncoder.overflow(input, i, output, j);
                            }
                            out[j++] = ch;
                        } else {
                            if (j >= m) {
                                return CDATAEncoder.overflow(input, i, output, j);
                            }
                            out[j++] = 32;
                        }
                    } else if (ch <= 56319) {
                        if (i + 1 < n) {
                            if (Character.isLowSurrogate(in[i + 1])) {
                                cp = Character.toCodePoint((char)ch, in[i + 1]);
                                if (Unicode.isNonCharacter(cp)) {
                                    if (j >= m) {
                                        return CDATAEncoder.overflow(input, i, output, j);
                                    }
                                    out[j++] = 32;
                                    ++i;
                                } else {
                                    if (j + 1 >= m) {
                                        return CDATAEncoder.overflow(input, i, output, j);
                                    }
                                    out[j++] = ch;
                                    out[j++] = in[++i];
                                }
                            } else {
                                if (j >= m) {
                                    return CDATAEncoder.overflow(input, i, output, j);
                                }
                                out[j++] = 32;
                            }
                        } else {
                            if (!endOfInput) break;
                            if (j >= m) {
                                return CDATAEncoder.overflow(input, i, output, j);
                            }
                            out[j++] = 32;
                        }
                    } else if (ch <= 57343 || ch > 65533 || 64976 <= ch && ch <= 65007) {
                        if (j >= m) {
                            return CDATAEncoder.overflow(input, i, output, j);
                        }
                        out[j++] = 32;
                    } else {
                        if (j >= m) {
                            return CDATAEncoder.overflow(input, i, output, j);
                        }
                        out[j++] = ch;
                    }
                }
            }
            ++i;
        }
        return CDATAEncoder.underflow(input, i, output, j);
    }

    public String toString() {
        return "CDATAEncoder";
    }
}

