/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.flightrecorder.rules.jdk.memory;

import com.oracle.jmc.common.item.IItemCollection;
import com.oracle.jmc.common.unit.IQuantity;
import com.oracle.jmc.common.unit.UnitLookup;
import com.oracle.jmc.common.util.IPreferenceValueProvider;
import com.oracle.jmc.common.util.TypedPreference;
import com.oracle.jmc.flightrecorder.jdk.JdkAggregators;
import com.oracle.jmc.flightrecorder.rules.IRule;
import com.oracle.jmc.flightrecorder.rules.Result;
import com.oracle.jmc.flightrecorder.rules.jdk.messages.internal.Messages;
import com.oracle.jmc.flightrecorder.rules.util.RulesToolkit;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;

public class TlabAllocationRatioRule
implements IRule {
    private static final String RESULT_ID = "TlabAllocationRatio";

    private Result getResult(IItemCollection items, IPreferenceValueProvider valueProvider) {
        RulesToolkit.EventAvailability eventAvailability = RulesToolkit.getEventAvailability((IItemCollection)items, (String[])new String[]{"com.oracle.jdk.ObjectAllocationInNewTLAB", "com.oracle.jdk.ObjectAllocationOutsideTLAB"});
        if (eventAvailability == RulesToolkit.EventAvailability.DISABLED || eventAvailability == RulesToolkit.EventAvailability.UNAVAILABLE) {
            return RulesToolkit.getEventAvailabilityResult((IRule)this, (IItemCollection)items, (RulesToolkit.EventAvailability)eventAvailability, (String[])new String[]{"com.oracle.jdk.ObjectAllocationInNewTLAB", "com.oracle.jdk.ObjectAllocationOutsideTLAB"});
        }
        IQuantity insideSum = (IQuantity)items.getAggregate(JdkAggregators.ALLOC_INSIDE_TLAB_SUM);
        IQuantity outsideSum = (IQuantity)items.getAggregate(JdkAggregators.ALLOC_OUTSIDE_TLAB_SUM);
        if (outsideSum == null) {
            return new Result((IRule)this, 0.0, Messages.getString("TlabAllocationRatioRuleFactory_TEXT_OK"));
        }
        if (insideSum == null) {
            return new Result((IRule)this, 100.0, Messages.getString("TlabAllocationRatioRuleFactory_TEXT_INFO_ONLY_OUTSIDE"));
        }
        IQuantity totalSum = insideSum.add(outsideSum);
        double rawRatio = outsideSum.ratioTo(totalSum);
        double score = RulesToolkit.mapExp74((double)rawRatio, (double)0.2);
        String message = MessageFormat.format(Messages.getString("TlabAllocationRatioRuleFactory_TEXT_INFO"), UnitLookup.PERCENT_UNITY.quantity(rawRatio).displayUsing("auto"));
        return new Result((IRule)this, score, message, score < 25.0 ? null : Messages.getString("TlabAllocationRatioRuleFactory_TEXT_INFO_LONG"));
    }

    public RunnableFuture<Result> evaluate(final IItemCollection items, final IPreferenceValueProvider valueProvider) {
        FutureTask<Result> evaluationTask = new FutureTask<Result>(new Callable<Result>(){

            @Override
            public Result call() throws Exception {
                return TlabAllocationRatioRule.this.getResult(items, valueProvider);
            }
        });
        return evaluationTask;
    }

    public Collection<TypedPreference<?>> getConfigurationAttributes() {
        return Collections.emptyList();
    }

    public String getId() {
        return RESULT_ID;
    }

    public String getName() {
        return Messages.getString("TlabAllocationRatioRuleFactory_RULE_NAME");
    }

    public String getTopic() {
        return "tlab";
    }
}

