/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.flightrecorder.rules.jdk.memory;

import com.oracle.jmc.common.item.IItemCollection;
import com.oracle.jmc.common.unit.IPersister;
import com.oracle.jmc.common.unit.IQuantity;
import com.oracle.jmc.common.unit.UnitLookup;
import com.oracle.jmc.common.util.IPreferenceValueProvider;
import com.oracle.jmc.common.util.TypedPreference;
import com.oracle.jmc.flightrecorder.jdk.JdkQueries;
import com.oracle.jmc.flightrecorder.rules.IRule;
import com.oracle.jmc.flightrecorder.rules.Result;
import com.oracle.jmc.flightrecorder.rules.jdk.memory.GarbageCollectionsInfo;
import com.oracle.jmc.flightrecorder.rules.jdk.messages.internal.Messages;
import com.oracle.jmc.flightrecorder.rules.util.RulesToolkit;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;

public class SystemGcRule
implements IRule {
    private static final String SYSTEM_GC_RESULT_ID = "SystemGc";
    public static final TypedPreference<IQuantity> SYSTEM_GC_RATIO_LIMIT = new TypedPreference("systemgc.ratio.limit", Messages.getString("SystemGcRule_CONFIG_WARNING_LIMIT"), Messages.getString("SystemGcRule_CONFIG_WARNING_LIMIT_LONG"), (IPersister)UnitLookup.NUMBER, (Object)UnitLookup.NUMBER_UNITY.quantity(0.5));
    private static final List<TypedPreference<?>> CONFIG_ATTRIBUTES = Arrays.asList(SYSTEM_GC_RATIO_LIMIT);

    public RunnableFuture<Result> evaluate(final IItemCollection items, final IPreferenceValueProvider valueProvider) {
        FutureTask<Result> evaluationTask = new FutureTask<Result>(new Callable<Result>(){

            @Override
            public Result call() throws Exception {
                RulesToolkit.EventAvailability eventAvailability = RulesToolkit.getEventAvailability((IItemCollection)items, (String[])new String[]{"com.oracle.jdk.GarbageCollection"});
                if (eventAvailability != RulesToolkit.EventAvailability.AVAILABLE) {
                    return RulesToolkit.getEventAvailabilityResult((IRule)SystemGcRule.this, (IItemCollection)items, (RulesToolkit.EventAvailability)eventAvailability, (String[])new String[]{"com.oracle.jdk.GarbageCollection"});
                }
                GarbageCollectionsInfo aggregate = (GarbageCollectionsInfo)items.getAggregate(GarbageCollectionsInfo.GC_INFO_AGGREGATOR);
                return SystemGcRule.this.getSystemGcResult(aggregate.getSystemGcCount(), aggregate.getGcCount(), (IQuantity)valueProvider.getPreferenceValue(SYSTEM_GC_RATIO_LIMIT));
            }
        });
        return evaluationTask;
    }

    private Result getSystemGcResult(double systemGcCount, double totalCcCount, IQuantity limit) {
        if (systemGcCount > 0.0) {
            double systemGcRatio = systemGcCount / totalCcCount;
            double score = RulesToolkit.mapExp100((double)systemGcRatio, (double)limit.doubleValue());
            String text = MessageFormat.format(Messages.getString("SystemGcRuleFactory_TEXT_INFO"), UnitLookup.PERCENT_UNITY.quantity(systemGcRatio).displayUsing("auto"));
            String longText = Messages.getString("SystemGcRuleFactory_TEXT_INFO_LONG");
            return new Result((IRule)this, score, text, longText, JdkQueries.GARBAGE_COLLECTION);
        }
        return new Result((IRule)this, 0.0, Messages.getString("SystemGcRuleFactory_TEXT_OK"));
    }

    public Collection<TypedPreference<?>> getConfigurationAttributes() {
        return CONFIG_ATTRIBUTES;
    }

    public String getId() {
        return SYSTEM_GC_RESULT_ID;
    }

    public String getName() {
        return Messages.getString("SystemGcRuleFactory_RULE_NAME");
    }

    public String getTopic() {
        return "garbage_collection";
    }
}

