/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.flightrecorder.rules.jdk.memory;

import com.oracle.jmc.common.item.Aggregators;
import com.oracle.jmc.common.item.IAggregator;
import com.oracle.jmc.common.item.IAttribute;
import com.oracle.jmc.common.item.ICanonicalAccessorFactory;
import com.oracle.jmc.common.item.IItemCollection;
import com.oracle.jmc.common.item.IItemFilter;
import com.oracle.jmc.common.item.ItemFilters;
import com.oracle.jmc.common.unit.IPersister;
import com.oracle.jmc.common.unit.IQuantity;
import com.oracle.jmc.common.unit.IUnit;
import com.oracle.jmc.common.unit.UnitLookup;
import com.oracle.jmc.common.util.IPreferenceValueProvider;
import com.oracle.jmc.common.util.TypedPreference;
import com.oracle.jmc.flightrecorder.JfrAttributes;
import com.oracle.jmc.flightrecorder.jdk.JdkAggregators;
import com.oracle.jmc.flightrecorder.jdk.JdkAttributes;
import com.oracle.jmc.flightrecorder.rules.IRule;
import com.oracle.jmc.flightrecorder.rules.Result;
import com.oracle.jmc.flightrecorder.rules.jdk.memory.CollectorType;
import com.oracle.jmc.flightrecorder.rules.jdk.messages.internal.Messages;
import com.oracle.jmc.flightrecorder.rules.util.RulesToolkit;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;

public class LongGcPauseRule
implements IRule {
    private static final String RESULT_ID = "LongGcPause";
    public static final TypedPreference<IQuantity> GC_PAUSE_INFO_LIMIT = new TypedPreference("gc.pause.info.limit", Messages.getString("LongGcPauseRule_CONFIG_INFO_LIMIT"), Messages.getString("LongGcPauseRule_CONFIG_INFO_LIMIT_LONG"), (IPersister)UnitLookup.TIMESPAN, (Object)UnitLookup.MILLISECONDS.quantity(1000L));
    private static final List<TypedPreference<?>> CONFIG_ATTRIBUTES = Arrays.asList(GC_PAUSE_INFO_LIMIT);

    private Result getResult(IItemCollection items, IPreferenceValueProvider vp) {
        RulesToolkit.EventAvailability eventAvailability = RulesToolkit.getEventAvailability((IItemCollection)items, (String[])new String[]{"com.oracle.jdk.GCPhasePause", "com.oracle.jdk.GCConfiguration", "com.oracle.jdk.GCHeapConfiguration", "com.oracle.jdk.GCPhasePauseLevel1"});
        if (eventAvailability == RulesToolkit.EventAvailability.DISABLED || eventAvailability == RulesToolkit.EventAvailability.UNAVAILABLE) {
            return RulesToolkit.getEventAvailabilityResult((IRule)this, (IItemCollection)items, (RulesToolkit.EventAvailability)RulesToolkit.EventAvailability.DISABLED, (String[])new String[]{"com.oracle.jdk.GCPhasePause", "com.oracle.jdk.GCConfiguration", "com.oracle.jdk.GCHeapConfiguration", "com.oracle.jdk.GCPhasePauseLevel1"});
        }
        IQuantity maxPause = (IQuantity)items.getAggregate(JdkAggregators.LONGEST_GC_PAUSE);
        if (maxPause != null) {
            double gcPauseScore = RulesToolkit.mapExp74((double)maxPause.doubleValueIn((IUnit)UnitLookup.MILLISECONDS), (double)((IQuantity)vp.getPreferenceValue(GC_PAUSE_INFO_LIMIT)).doubleValueIn((IUnit)UnitLookup.MILLISECONDS));
            String longMessage = null;
            if (gcPauseScore >= 25.0) {
                longMessage = LongGcPauseRule.getLivesetMessage(items);
                longMessage = LongGcPauseRule.appendMessage(longMessage, LongGcPauseRule.getSemiRefsMessage(items));
                if ((longMessage = LongGcPauseRule.appendMessage(longMessage, LongGcPauseRule.getCollectorMessage(items))) == null) {
                    longMessage = Messages.getString("LongGcPauseRuleFactory_TEXT_INFO");
                }
            }
            String message = MessageFormat.format(Messages.getString("LongGcPauseRuleFactory_TEXT_INFO"), maxPause.displayUsing("auto"));
            return new Result((IRule)this, gcPauseScore, message, longMessage);
        }
        return new Result((IRule)this, 0.0, Messages.getString("LongGcPauseRuleFactory_TEXT_OK"));
    }

    public RunnableFuture<Result> evaluate(final IItemCollection items, final IPreferenceValueProvider valueProvider) {
        FutureTask<Result> evaluationTask = new FutureTask<Result>(new Callable<Result>(){

            @Override
            public Result call() throws Exception {
                return LongGcPauseRule.this.getResult(items, valueProvider);
            }
        });
        return evaluationTask;
    }

    private static String appendMessage(String message, String newMessage) {
        if (message == null) {
            return newMessage;
        }
        if (newMessage == null) {
            return message;
        }
        return String.valueOf(message) + " " + newMessage;
    }

    private static String getCollectorMessage(IItemCollection items) {
        CollectorType oldCollectorType = CollectorType.getOldCollectorType(items);
        if (oldCollectorType != CollectorType.G1_OLD) {
            return Messages.getString("LongGcPauseRuleFactory_TEXT_INFO_G1");
        }
        return null;
    }

    private static String getLivesetMessage(IItemCollection items) {
        int live;
        IQuantity liveSet = (IQuantity)items.getAggregate(JdkAggregators.AVG_HEAP_USED_AFTER_GC);
        IQuantity maxMx = (IQuantity)items.getAggregate(JdkAggregators.HEAP_CONF_MAX_SIZE);
        if (liveSet != null && maxMx != null && (live = (int)(liveSet.ratioTo(maxMx) * 100.0)) < 50) {
            return Messages.getString("LongGcPauseRuleFactory_TEXT_INFO_MX");
        }
        return null;
    }

    private static String getSemiRefsMessage(IItemCollection items) {
        IQuantity aggregate = (IQuantity)items.getAggregate(Aggregators.filter((IAggregator)Aggregators.max((String)"com.oracle.jdk.GCPhasePauseLevel1", (IAttribute)JfrAttributes.DURATION), (IItemFilter)ItemFilters.equals((ICanonicalAccessorFactory)JdkAttributes.GC_PHASE_NAME, (Object)"References")));
        if (aggregate == null) {
            return null;
        }
        int max = aggregate.compareTo((Object)UnitLookup.MILLISECONDS.quantity(50L));
        if (max >= 50) {
            return Messages.getString("LongGcPauseRuleFactory_TEXT_INFO_REFERENCES");
        }
        return null;
    }

    public Collection<TypedPreference<?>> getConfigurationAttributes() {
        return CONFIG_ATTRIBUTES;
    }

    public String getId() {
        return RESULT_ID;
    }

    public String getName() {
        return Messages.getString("LongGcPauseRuleFactory_RULE_NAME");
    }

    public String getTopic() {
        return "garbage_collection";
    }
}

